/*
 * Decompiled with CFR 0.152.
 */
package obp.cc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.cc.CcVisitor;
import obp.predicate.Predicate;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class State
implements BoostObject {
    private boolean unstable;
    private final List<Predicate> invariantList = new ArrayList<Predicate>();

    public State() {
    }

    protected State(Boost boost) {
        boost.register((BoostObject)this);
        this.unstable = boost.readBoolean();
        for (Predicate oneChild : BoostUtil.readObjectList((Boost)boost, Predicate.class)) {
            this.invariantList.add(oneChild);
        }
    }

    public boolean isUnstable() {
        return this.unstable;
    }

    public void setUnstable(boolean newValue) {
        if (this.unstable != newValue) {
            this.unstable = newValue;
        }
    }

    public List<Predicate> getInvariantList() {
        return Collections.unmodifiableList(this.invariantList);
    }

    public int getInvariantCount() {
        return this.invariantList.size();
    }

    public Predicate getInvariant(int index) {
        if (index < 0 || index >= this.getInvariantCount()) {
            return null;
        }
        return this.invariantList.get(index);
    }

    public void addInvariant(Predicate newValue) {
        this.addInvariant(this.getInvariantCount(), newValue);
    }

    public void addInvariant(int index, Predicate newValue) {
        this.invariantList.add(index, newValue);
    }

    public Predicate setInvariant(int index, Predicate newValue) {
        return this.invariantList.set(index, newValue);
    }

    public void addAllInvariant(Collection<Predicate> toAddList) {
        for (Predicate newValue : toAddList) {
            this.addInvariant(this.getInvariantCount(), newValue);
        }
    }

    public void removeInvariant(Predicate value) {
        int index = this.invariantList.indexOf(value);
        if (index >= 0) {
            this.removeInvariant(index);
        }
    }

    public void removeInvariant(int index) {
        this.invariantList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        boost.writeBoolean(this.unstable);
        BoostUtil.writeObjectCollection((Boost)boost, this.invariantList);
    }

    public void accept(CcVisitor visitor) {
        visitor.visitState(this);
    }
}

