/*
 * Decompiled with CFR 0.152.
 */
package tuml.interpreter;

import abcd.expression.parser.ABCDExpressionParser;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import tuml.interpreter.Environment;
import tuml.interpreter.IAbstractVisitor;

public class ActiveObject {
    private final Environment env;
    private final Class type;
    private final String name;
    private final List<Vertex> states;
    private final Map<Vertex, Integer> state2int;
    private final Map<Integer, Vertex> int2state;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private Queue<Signal> eventPool = new ArrayDeque<Signal>();
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private State currentState;
    public static int maxEventPoolSize = 10;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final HashMap<String, ActiveObject> peers = new HashMap();
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final HashMap<String, Object> localVars = new HashMap();
    private final HashSet<Signal> vocabulary = new HashSet();
    private final UMLFactory umlFactory = UMLFactory.eINSTANCE;
    private final Pattern sendPattern = Pattern.compile("^send (\\S+) to (\\S+)$");
    private final String identRegex = "([A-Za-z_]\\w*)";
    private final Pattern identPattern = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"^");
            _builder.append((Object)"([A-Za-z_]\\w*)", "");
            _builder.append((Object)"$");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private final Pattern assignPattern = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"^");
            _builder.append((Object)"([A-Za-z_]\\w*)", "");
            _builder.append((Object)" := (.*)$");
            Pattern _compile = Pattern.compile(_builder.toString());
            return _compile;
        }
    }.apply();
    private final ABCDExpressionParser abcd = new ABCDExpressionParser();

    public ActiveObject(Environment env, Class type, String name) {
        boolean _notEquals;
        HashMap _fold;
        EList _subvertices;
        this.env = env;
        this.type = type;
        this.name = name;
        Behavior _classifierBehavior = type.getClassifierBehavior();
        EList _regions = ((StateMachine)_classifierBehavior).getRegions();
        Region region = (Region)_regions.get(0);
        this.states = _subvertices = region.getSubvertices();
        HashMap<Integer, Vertex> _hashMap = new HashMap<Integer, Vertex>();
        this.int2state = _hashMap;
        Iterable _indexed = IterableExtensions.indexed(this.states);
        HashMap _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        Functions.Function2<HashMap<Vertex, Integer>, Pair<Integer, Vertex>, HashMap<Vertex, Integer>> _function = new Functions.Function2<HashMap<Vertex, Integer>, Pair<Integer, Vertex>, HashMap<Vertex, Integer>>(){

            public HashMap<Vertex, Integer> apply(HashMap<Vertex, Integer> map, Pair<Integer, Vertex> pair) {
                HashMap<Vertex, Integer> _xblockexpression = null;
                Vertex _value = (Vertex)pair.getValue();
                Integer _key = (Integer)pair.getKey();
                map.put(_value, _key);
                Integer _key_1 = (Integer)pair.getKey();
                Vertex _value_1 = (Vertex)pair.getValue();
                ActiveObject.this.int2state.put(_key_1, _value_1);
                _xblockexpression = map;
                return _xblockexpression;
            }
        };
        this.state2int = _fold = (HashMap)IterableExtensions.fold((Iterable)_indexed, (Object)_newHashMap, (Functions.Function2)_function);
        EList _subvertices_1 = region.getSubvertices();
        Functions.Function1<Vertex, Boolean> _function_1 = new Functions.Function1<Vertex, Boolean>(){

            public Boolean apply(Vertex v) {
                PseudostateKind _kind;
                int _value;
                boolean _xifexpression = false;
                _xifexpression = v instanceof Pseudostate ? (_value = (_kind = ((Pseudostate)v).getKind()).getValue()) == 0 : false;
                return _xifexpression;
            }
        };
        Vertex _findFirst = (Vertex)IterableExtensions.findFirst((Iterable)_subvertices_1, (Functions.Function1)_function_1);
        EList initialTransitions = _findFirst.getOutgoings();
        int _size = initialTransitions.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            throw new RuntimeException();
        }
        Transition _get = (Transition)initialTransitions.get(0);
        Vertex target = _get.getTarget();
        this.currentState = (State)target;
        if (env.outputPlantUMLStates) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"hnote over ");
            _builder.append((Object)name, "");
            _builder.append((Object)" : ");
            String _name = this.currentState.getName();
            _builder.append((Object)_name, "");
            InputOutput.println((Object)_builder.toString());
        }
        EList _attributes = type.getAttributes();
        Functions.Function1<Property, Boolean> _function_2 = new Functions.Function1<Property, Boolean>(){

            public Boolean apply(Property it) {
                int _intValue;
                VisibilityKind _visibility = it.getVisibility();
                int _value = _visibility.getValue();
                return _value == (_intValue = Integer.valueOf(1).intValue());
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_attributes, (Functions.Function1)_function_2);
        Consumer<Property> _function_3 = new Consumer<Property>(){

            @Override
            public void accept(Property at) {
                String _name = at.getName();
                ActiveObject.this.localVars.put(_name, false);
            }
        };
        _filter.forEach(_function_3);
        Behavior _classifierBehavior_1 = type.getClassifierBehavior();
        EList _regions_1 = ((StateMachine)_classifierBehavior_1).getRegions();
        Region _get_1 = (Region)_regions_1.get(0);
        EList _transitions = _get_1.getTransitions();
        Functions.Function2<HashSet<Signal>, Transition, HashSet<Signal>> _function_4 = new Functions.Function2<HashSet<Signal>, Transition, HashSet<Signal>>(){

            public HashSet<Signal> apply(HashSet<Signal> vocab, Transition t) {
                HashSet<Signal> _xblockexpression = null;
                EList _triggers = t.getTriggers();
                Functions.Function1<Trigger, Event> _function = new Functions.Function1<Trigger, Event>(){

                    public Event apply(Trigger it) {
                        return it.getEvent();
                    }
                };
                List _map = ListExtensions.map((List)_triggers, (Functions.Function1)_function);
                Iterable _filter = Iterables.filter((Iterable)_map, SignalEvent.class);
                Functions.Function1<SignalEvent, Signal> _function_1 = new Functions.Function1<SignalEvent, Signal>(){

                    public Signal apply(SignalEvent it) {
                        return it.getSignal();
                    }
                };
                Iterable _map_1 = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
                Set signalz = IterableExtensions.toSet((Iterable)_map_1);
                vocab.addAll(signalz);
                _xblockexpression = vocab;
                return _xblockexpression;
            }
        };
        IterableExtensions.fold((Iterable)_transitions, this.vocabulary, (Functions.Function2)_function_4);
    }

    public ActiveObject addPeer(final String name, ActiveObject peer) {
        boolean _not;
        Functions.Function1<Property, Boolean> _function;
        ActiveObject _xblockexpression = null;
        EList _allAttributes = this.type.allAttributes();
        boolean _exists = IterableExtensions.exists((Iterable)_allAttributes, (Functions.Function1)(_function = new Functions.Function1<Property, Boolean>(){

            public Boolean apply(Property a) {
                String _name = a.getName();
                return Objects.equal((Object)_name, (Object)name);
            }
        }));
        boolean bl = _not = !_exists;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Class ");
            String _name = this.type.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)" does not have an attribute named ");
            _builder.append((Object)name, "");
            throw new RuntimeException(_builder.toString());
        }
        _xblockexpression = this.peers.put(name, peer);
        return _xblockexpression;
    }

    public String getName() {
        return this.name;
    }

    public boolean queue(Signal s) {
        return this.eventPool.add(s);
    }

    public Transition createIgnoringTransition(Set<Signal> ignoredTriggers) {
        Transition _xblockexpression = null;
        Transition ignoringTransition = this.umlFactory.createTransition();
        Functions.Function1<Signal, Trigger> _function = new Functions.Function1<Signal, Trigger>(){

            public Trigger apply(Signal signal) {
                Trigger _xblockexpression = null;
                SignalEvent sE = ActiveObject.this.umlFactory.createSignalEvent();
                sE.setSignal(signal);
                Trigger trig = ActiveObject.this.umlFactory.createTrigger();
                trig.setEvent((Event)sE);
                _xblockexpression = trig;
                return _xblockexpression;
            }
        };
        Iterable triggers = IterableExtensions.map(ignoredTriggers, (Functions.Function1)_function);
        EList _triggers = ignoringTransition.getTriggers();
        Iterables.addAll((Collection)_triggers, (Iterable)triggers);
        ignoringTransition.setSource((Vertex)this.currentState);
        ignoringTransition.setTarget((Vertex)this.currentState);
        _xblockexpression = ignoringTransition;
        return _xblockexpression;
    }

    public Set<Pair<ActiveObject, Transition>> fireableTransitions() {
        Functions.Function1<Pair<ActiveObject, Transition>, Boolean> _function_2;
        Iterable triggered;
        boolean _isEmpty_1;
        boolean _not;
        Set _xblockexpression = null;
        EList _outgoings = this.currentState.getOutgoings();
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition t) {
                boolean _contains;
                boolean _not;
                EList _triggers = t.getTriggers();
                boolean _isEmpty = _triggers.isEmpty();
                if (_isEmpty) {
                    String _guard = ActiveObject.this.guard(t);
                    return ActiveObject.this.eval(_guard);
                }
                EList _triggers_1 = t.getTriggers();
                Functions.Function1<Trigger, Event> _function = new Functions.Function1<Trigger, Event>(){

                    public Event apply(Trigger it) {
                        return it.getEvent();
                    }
                };
                List _map = ListExtensions.map((List)_triggers_1, (Functions.Function1)_function);
                Iterable _filter = Iterables.filter((Iterable)_map, SignalEvent.class);
                Functions.Function1<SignalEvent, Signal> _function_1 = new Functions.Function1<SignalEvent, Signal>(){

                    public Signal apply(SignalEvent it) {
                        return it.getSignal();
                    }
                };
                Iterable _map_1 = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
                Set signals = IterableExtensions.toSet((Iterable)_map_1);
                String _guard_1 = ActiveObject.this.guard(t);
                boolean _eval = ActiveObject.this.eval(_guard_1);
                boolean bl = _not = !_eval;
                if (_not) {
                    return false;
                }
                boolean _isEmpty_1 = signals.isEmpty();
                if (_isEmpty_1) {
                    return true;
                }
                boolean _isEmpty_2 = ActiveObject.this.eventPool.isEmpty();
                if (_isEmpty_2) {
                    return false;
                }
                Signal availableSignal = (Signal)ActiveObject.this.eventPool.peek();
                boolean _and = false;
                boolean _isEmpty_3 = ActiveObject.this.eventPool.isEmpty();
                boolean _not_1 = !_isEmpty_3;
                _and = !_not_1 ? false : (_contains = signals.contains(availableSignal));
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_outgoings, (Functions.Function1)_function);
        Functions.Function1<Transition, Pair<ActiveObject, Transition>> _function_1 = new Functions.Function1<Transition, Pair<ActiveObject, Transition>>(){

            public Pair<ActiveObject, Transition> apply(Transition it) {
                return Pair.of((Object)ActiveObject.this, (Object)it);
            }
        };
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        Set res = IterableExtensions.toSet((Iterable)_map);
        boolean _isEmpty = this.eventPool.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not && (_isEmpty_1 = IterableExtensions.isEmpty((Iterable)(triggered = IterableExtensions.filter((Iterable)res, (Functions.Function1)(_function_2 = new Functions.Function1<Pair<ActiveObject, Transition>, Boolean>(){

            public Boolean apply(Pair<ActiveObject, Transition> t) {
                Transition _value = (Transition)t.getValue();
                EList _triggers = _value.getTriggers();
                Functions.Function1<Trigger, Event> _function = new Functions.Function1<Trigger, Event>(){

                    public Event apply(Trigger it) {
                        return it.getEvent();
                    }
                };
                List _map = ListExtensions.map((List)_triggers, (Functions.Function1)_function);
                Iterable _filter = Iterables.filter((Iterable)_map, SignalEvent.class);
                Functions.Function1<SignalEvent, Signal> _function_1 = new Functions.Function1<SignalEvent, Signal>(){

                    public Signal apply(SignalEvent it) {
                        return it.getSignal();
                    }
                };
                Iterable _map_1 = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
                Set sigs = IterableExtensions.toSet((Iterable)_map_1);
                Signal _peek = (Signal)ActiveObject.this.eventPool.peek();
                return sigs.contains(_peek);
            }
        })))))) {
            Signal _peek = this.eventPool.peek();
            Set<Signal> _singleton = Collections.singleton(_peek);
            Transition _createIgnoringTransition = this.createIgnoringTransition(_singleton);
            Pair _mappedTo = Pair.of((Object)this, (Object)_createIgnoringTransition);
            res.add(_mappedTo);
        }
        _xblockexpression = res;
        return _xblockexpression;
    }

    public void executeEffect(Transition t) {
        boolean _notEquals;
        Behavior _effect = t.getEffect();
        boolean bl = _notEquals = !Objects.equal((Object)_effect, null);
        if (_notEquals) {
            Behavior _effect_1 = t.getEffect();
            EList _bodies = ((OpaqueBehavior)_effect_1).getBodies();
            String body = (String)_bodies.get(0);
            String[] _split = body.split(";");
            Functions.Function1<String, Matcher> _function = new Functions.Function1<String, Matcher>(){

                public Matcher apply(String stmt) {
                    String _trim = stmt.trim();
                    return ActiveObject.this.sendPattern.matcher(_trim);
                }
            };
            List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_split)), (Functions.Function1)_function);
            Functions.Function1<Matcher, Boolean> _function_1 = new Functions.Function1<Matcher, Boolean>(){

                public Boolean apply(Matcher it) {
                    return it.matches();
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_map, (Functions.Function1)_function_1);
            Functions.Function1<Matcher, Pair<String, String>> _function_2 = new Functions.Function1<Matcher, Pair<String, String>>(){

                public Pair<String, String> apply(Matcher matcher) {
                    String _group = matcher.group(1);
                    String _group_1 = matcher.group(2);
                    return Pair.of((Object)_group, (Object)_group_1);
                }
            };
            Iterable sends = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_2);
            this.env.getClass();
            Consumer<Pair<String, String>> _function_4 = new Consumer<Pair<String, String>>(){

                @Override
                public void accept(Pair<String, String> toSend) {
                    int _size;
                    boolean _greaterThan;
                    String _value = (String)toSend.getValue();
                    ActiveObject _get = (ActiveObject)ActiveObject.this.peers.get(_value);
                    Queue eventPool = _get.eventPool;
                    boolean _and = false;
                    _and = maxEventPoolSize <= 0 ? false : (_greaterThan = (_size = eventPool.size()) > maxEventPoolSize);
                    if (_and) {
                        throw new RuntimeException("EventPool size exceeded");
                    }
                    String _value_1 = (String)toSend.getValue();
                    ActiveObject _get_1 = (ActiveObject)ActiveObject.this.peers.get(_value_1);
                    String _key = (String)toSend.getKey();
                    Signal _signal = ActiveObject.this.env.getSignal(_key);
                    _get_1.queue(_signal);
                }
            };
            sends.forEach(_function_4);
            String[] _split_1 = body.split(";");
            Functions.Function1<String, Matcher> _function_5 = new Functions.Function1<String, Matcher>(){

                public Matcher apply(String stmt) {
                    String _trim = stmt.trim();
                    return ActiveObject.this.assignPattern.matcher(_trim);
                }
            };
            List _map_1 = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)_split_1)), (Functions.Function1)_function_5);
            Functions.Function1<Matcher, Boolean> _function_6 = new Functions.Function1<Matcher, Boolean>(){

                public Boolean apply(Matcher it) {
                    return it.matches();
                }
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_map_1, (Functions.Function1)_function_6);
            Consumer<Matcher> _function_7 = new Consumer<Matcher>(){

                @Override
                public void accept(Matcher matcher) {
                    String _group = matcher.group(1);
                    String _group_1 = matcher.group(2);
                    boolean _eval = ActiveObject.this.eval(_group_1);
                    ActiveObject.this.localVars.put(_group, _eval);
                }
            };
            _filter_1.forEach(_function_7);
        }
    }

    public String guard(Transition t) {
        String _xblockexpression = null;
        Constraint _guard = t.getGuard();
        boolean _equals = Objects.equal((Object)_guard, null);
        if (_equals) {
            return "true";
        }
        Constraint _guard_1 = t.getGuard();
        ValueSpecification _specification = _guard_1.getSpecification();
        EList _bodies = ((OpaqueExpression)_specification).getBodies();
        _xblockexpression = (String)_bodies.get(0);
        return _xblockexpression;
    }

    public String condition(Transition t) {
        boolean _notEquals;
        String _xblockexpression = null;
        EList _ownedRules = t.getOwnedRules();
        int _size = _ownedRules.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            throw new RuntimeException();
        }
        EList _ownedRules_1 = t.getOwnedRules();
        Constraint _get = (Constraint)_ownedRules_1.get(0);
        ValueSpecification spec = _get.getSpecification();
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && spec instanceof OpaqueExpression) {
            _matched = true;
            EList _bodies = ((OpaqueExpression)spec).getBodies();
            _switchResult = (String)_bodies.get(0);
        }
        if (!_matched) {
            throw new RuntimeException();
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    public boolean eval(String condition) {
        Object _eval = this.abcd.eval(condition, this.localVars);
        Boolean evaled = (Boolean)_eval;
        return evaled;
    }

    public String fire(Transition t) {
        EList _triggers;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        String _xblockexpression = null;
        boolean _and = false;
        boolean _isEmpty = this.eventPool.isEmpty();
        boolean bl = _not = !_isEmpty;
        _and = !_not ? false : (_not_1 = !(_isEmpty_1 = (_triggers = t.getTriggers()).isEmpty()));
        if (_and) {
            _triggers = this.eventPool.remove();
        }
        this.executeEffect(t);
        Vertex target = t.getTarget();
        block3: while (target instanceof Pseudostate) {
            PseudostateKind _kind = ((Pseudostate)target).getKind();
            int _value = _kind.getValue();
            switch (_value) {
                case 6: {
                    Vertex _target;
                    Transition tr = null;
                    EList _outgoings = ((Pseudostate)target).getOutgoings();
                    Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            String _condition = ActiveObject.this.condition(it);
                            return !Objects.equal((Object)_condition, (Object)"else");
                        }
                    };
                    Iterable _filter = IterableExtensions.filter((Iterable)_outgoings, (Functions.Function1)_function);
                    for (Transition e : _filter) {
                        boolean _and_1 = false;
                        boolean _equals = Objects.equal((Object)tr, null);
                        if (!_equals) {
                            _and_1 = false;
                        } else {
                            boolean _eval;
                            String _condition = this.condition(e);
                            _and_1 = _eval = this.eval(_condition);
                        }
                        if (!_and_1) continue;
                        tr = e;
                    }
                    boolean _equals_1 = Objects.equal((Object)tr, null);
                    if (_equals_1) {
                        Transition _findFirst;
                        EList _outgoings_1 = ((Pseudostate)target).getOutgoings();
                        Functions.Function1<Transition, Boolean> _function_1 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                String _condition = ActiveObject.this.condition(it);
                                return Objects.equal((Object)_condition, (Object)"else");
                            }
                        };
                        tr = _findFirst = (Transition)IterableExtensions.findFirst((Iterable)_outgoings_1, (Functions.Function1)_function_1);
                    }
                    this.executeEffect(tr);
                    target = _target = tr.getTarget();
                    continue block3;
                }
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Unsupported PseudostateKind: ");
            _builder.append((Object)target, "");
            throw new RuntimeException(_builder.toString());
        }
        this.currentState = (State)target;
        String _xifexpression = null;
        if (this.env.outputPlantUMLStates) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"hnote over ");
            _builder.append((Object)this.name, "");
            _builder.append((Object)" : ");
            String _name = this.currentState.getName();
            _builder.append((Object)_name, "");
            _xifexpression = (String)InputOutput.println((Object)_builder.toString());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public CharSequence toShortString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)this.name, "");
        _builder.append((Object)":");
        String _name = this.type.getName();
        _builder.append((Object)_name, "");
        return _builder;
    }

    public String toString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)this.name, "");
        _builder.append((Object)":");
        String _name = this.type.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(currentState = ");
        String _name_1 = this.currentState.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)", eventPool = ");
        Functions.Function1<Signal, String> _function = new Functions.Function1<Signal, String>(){

            public String apply(Signal it) {
                return it.getName();
            }
        };
        Iterable _map = IterableExtensions.map(this.eventPool, (Functions.Function1)_function);
        _builder.append((Object)_map, "");
        _builder.append((Object)", peers = ");
        Functions.Function1<ActiveObject, String> _function_1 = new Functions.Function1<ActiveObject, String>(){

            public String apply(ActiveObject it) {
                return it.name;
            }
        };
        Map _mapValues = MapExtensions.mapValues(this.peers, (Functions.Function1)_function_1);
        _builder.append((Object)_mapValues, "");
        _builder.append((Object)")");
        return _builder.toString();
    }

    public int getIntBufferSize() {
        int _size = this.eventPool.size();
        int _plus = 2 + _size;
        int _size_1 = this.localVars.size();
        return _plus + _size_1;
    }

    public int getBufferSize() {
        int _intBufferSize = this.getIntBufferSize();
        return _intBufferSize * 4;
    }

    public void encode(final ByteBuffer buffer) {
        if (this.currentState instanceof Pseudostate) {
            throw new RuntimeException();
        }
        Integer _get = this.state2int.get(this.currentState);
        buffer.putInt(_get);
        int _size = this.eventPool.size();
        buffer.putInt(_size);
        Consumer<Signal> _function = new Consumer<Signal>(){

            @Override
            public void accept(Signal t) {
                Map<Signal, Integer> _signal2id = ActiveObject.this.env.signal2id();
                Integer _get = _signal2id.get(t);
                buffer.putInt(_get);
            }
        };
        this.eventPool.forEach(_function);
        BiConsumer<String, Object> _function_1 = new BiConsumer<String, Object>(){

            @Override
            public void accept(String k, Object v) {
                if (v instanceof Boolean) {
                    boolean _booleanValue = (Boolean)v;
                    if (_booleanValue) {
                        buffer.put((byte)1);
                    } else {
                        buffer.put((byte)0);
                    }
                } else if (v instanceof Integer) {
                    int iv = (Integer)v;
                    buffer.putInt(iv);
                } else {
                    throw new RuntimeException();
                }
            }
        };
        this.localVars.forEach(_function_1);
    }

    public void decode(final ByteBuffer buffer) {
        int stateID = buffer.getInt();
        Vertex _get = this.int2state.get(stateID);
        if (_get instanceof Pseudostate) {
            throw new RuntimeException();
        }
        Vertex _get_1 = this.int2state.get(stateID);
        this.currentState = (State)_get_1;
        int epSize = buffer.getInt();
        ArrayDeque<Signal> _arrayDeque = new ArrayDeque<Signal>(epSize);
        this.eventPool = _arrayDeque;
        for (int i = 0; i < epSize; ++i) {
            List<Signal> _signals = this.env.signals();
            int _int = buffer.getInt();
            Signal _get_2 = _signals.get(_int);
            this.eventPool.add(_get_2);
        }
        BiConsumer<String, Object> _function = new BiConsumer<String, Object>(){

            @Override
            public void accept(String k, Object v) {
                if (v instanceof Boolean) {
                    byte bv = buffer.get();
                    if (bv == 1) {
                        ActiveObject.this.localVars.put(k, true);
                    } else {
                        ActiveObject.this.localVars.put(k, false);
                    }
                } else if (v instanceof Integer) {
                    int iv = buffer.getInt();
                    ActiveObject.this.localVars.put(k, iv);
                } else {
                    throw new RuntimeException();
                }
            }
        };
        this.localVars.forEach(_function);
    }

    public <T> T accept(IAbstractVisitor<T> visitor) {
        return visitor.visitActiveObject(this);
    }

    @Pure
    public Queue<Signal> getEventPool() {
        return this.eventPool;
    }

    @Pure
    public State getCurrentState() {
        return this.currentState;
    }

    @Pure
    public HashMap<String, ActiveObject> getPeers() {
        return this.peers;
    }

    @Pure
    public HashMap<String, Object> getLocalVars() {
        return this.localVars;
    }
}

