/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.dot.diagram;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import obp.dot.Node;
import obp.ui.dot.diagram.DotColor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.xid.basics.geometry.Geometry;
import org.xid.basics.ui.diagram.DiagramContext;
import org.xid.basics.ui.diagram.Element;
import org.xid.basics.ui.diagram.gc.GC;
import org.xid.basics.ui.diagram.gc.GcUtils;

public class NodeElement
extends Element.Stub
implements Element {
    public static final RGB backgroundRgb = new RGB(140, 210, 250);
    private final Node model;
    private static final Pattern htmlColor = Pattern.compile("#([0-9aAbBcCdDeEfF]{2})([0-9aAbBcCdDeEfF]{2})([0-9aAbBcCdDeEfF]{2})");

    public NodeElement(Node model) {
        this.model = model;
    }

    public Node getModel() {
        return this.model;
    }

    public float[] getPoint() {
        return this.model.getPosition();
    }

    public void computeBounds(float[] result, DiagramContext context) {
        Geometry.setNullRectangle((float[])result);
        Geometry.copyPoints((float[])this.model.getPosition(), (float[])result);
        Geometry.expandRectangle((float[])result, (float)5.0f, (float)5.0f);
    }

    private RGB getColor() {
        RGB color = null;
        if (this.model.getColor() != null) {
            Matcher matcher = htmlColor.matcher(this.model.getColor());
            if (matcher.matches()) {
                int red = Integer.parseInt(matcher.group(1), 16);
                int green = Integer.parseInt(matcher.group(2), 16);
                int blue = Integer.parseInt(matcher.group(3), 16);
                color = new RGB(red, green, blue);
            } else {
                color = DotColor.getRGB(this.model.getColor());
            }
        }
        if (color == null) {
            color = DotColor.getRGB("white");
        }
        return color;
    }

    public void display(GC gc, DiagramContext context) {
        gc.setBackground(context.getResources().getColor(this.getColor()));
        for (int i = this.model.getPeripheries() - 1; i >= 0; --i) {
            this.displayShape(gc, context, 1.0f + (float)i * 0.1f);
        }
        this.displayLabel(gc, context);
    }

    private void displayShape(GC gc, DiagramContext context, float ratio) {
        float[] rectangle = Geometry.copyPoints((float[])this.model.getPosition());
        float dx = (ratio - 1.0f) * (rectangle[2] - rectangle[0]);
        float dy = (ratio - 1.0f) * (rectangle[3] - rectangle[1]);
        Geometry.expandRectangle((float[])rectangle, (float)dx, (float)dy);
        switch (this.model.getShape()) {
            case square: {
                this.squarifyRectangle(rectangle);
            }
            case box: 
            case rect: 
            case rectangle: {
                GcUtils.drawRectangle((GC)gc, (float[])rectangle, (boolean)true);
                break;
            }
            case polygon: {
                GcUtils.drawPolyline((GC)gc, (float[])this.polygonePolyline(rectangle, this.model.getSides()), (boolean)true);
                break;
            }
            case diamond: {
                GcUtils.drawPolyline((GC)gc, (float[])this.polygonePolyline(rectangle, 4), (boolean)true);
                break;
            }
            case pentagon: {
                GcUtils.drawPolyline((GC)gc, (float[])this.polygonePolyline(rectangle, 5), (boolean)true);
                break;
            }
            case hexagon: {
                GcUtils.drawPolyline((GC)gc, (float[])this.polygonePolyline(rectangle, 6), (boolean)true);
                break;
            }
            case septagon: {
                GcUtils.drawPolyline((GC)gc, (float[])this.polygonePolyline(rectangle, 7), (boolean)true);
                break;
            }
            case octagon: {
                GcUtils.drawPolyline((GC)gc, (float[])this.polygonePolyline(rectangle, 8), (boolean)true);
                break;
            }
            case circle: {
                this.squarifyRectangle(rectangle);
            }
            case ellipse: {
                float[] ellipseUpperLeftPoint = Geometry.getPoint((float[])rectangle, (int)0);
                float ellipseWidth = rectangle[2] - rectangle[0];
                float ellipseHeight = rectangle[3] - rectangle[1];
                gc.fillOval(Math.round(ellipseUpperLeftPoint[0]), Math.round(ellipseUpperLeftPoint[1]), Math.round(ellipseWidth), Math.round(ellipseHeight));
                gc.drawOval(Math.round(ellipseUpperLeftPoint[0]), Math.round(ellipseUpperLeftPoint[1]), Math.round(ellipseWidth), Math.round(ellipseHeight));
                break;
            }
            case point: {
                float[] center = Geometry.getRectanglePoint((float[])rectangle, (int)-1);
                float size = 5.0f;
                Color oldBackground = gc.getBackground();
                gc.setBackground(gc.getForeground());
                gc.fillOval(Math.round(center[0] - size / 2.0f), Math.round(center[1] - size / 2.0f), Math.round(size), Math.round(size));
                gc.drawOval(Math.round(center[0] - size / 2.0f), Math.round(center[1] - size / 2.0f), Math.round(size), Math.round(size));
                gc.setBackground(oldBackground);
                break;
            }
            case triangle: {
                rectangle[3] = rectangle[3] - (rectangle[2] - rectangle[0]) * 1.0f / 5.0f;
                GcUtils.drawTriangle((GC)gc, (float[])rectangle, (int)6, (boolean)true);
                break;
            }
            case invtriangle: {
                rectangle[1] = rectangle[1] + (rectangle[2] - rectangle[0]) * 1.0f / 5.0f;
                GcUtils.drawTriangle((GC)gc, (float[])rectangle, (int)2, (boolean)true);
                break;
            }
        }
    }

    private void squarifyRectangle(float[] rectangle) {
        float width = rectangle[2] - rectangle[0];
        float height = rectangle[3] - rectangle[1];
        if (width < height) {
            rectangle[0] = rectangle[0] - (height - width) / 2.0f;
            rectangle[2] = rectangle[2] + (height - width) / 2.0f;
        } else {
            rectangle[1] = rectangle[1] - (width - height) / 2.0f;
            rectangle[3] = rectangle[3] + (width - height) / 2.0f;
        }
    }

    private float[] polygonePolyline(float[] rectangle, int sides) {
        float[] polyline = new float[(sides + 1) * 2];
        float[] upperLeftPoint = Geometry.getRectanglePoint((float[])rectangle, (int)5);
        float[] centerPoint = Geometry.getRectanglePoint((float[])rectangle, (int)-1);
        double radius = Math.sqrt(Geometry.distanceSquared((float[])upperLeftPoint, (float[])centerPoint));
        for (int i = 0; i <= sides; ++i) {
            double angle = Math.PI * 2 / (double)sides * (double)i;
            Geometry.copyPoints((float[])this.getRectanglePoint(rectangle, angle, radius, centerPoint), (int)0, (int)1, (float[])polyline, (int)i);
        }
        return polyline;
    }

    private float[] getRectanglePoint(float[] rectangle, double angle, double radius, float[] center) {
        float[] point = new float[]{(float)(Math.cos(angle) * radius + (double)center[0]), (float)(Math.sin(angle) * radius + (double)center[1])};
        Geometry.projectPointOnRectangle((float[])point, (float[])rectangle);
        return point;
    }

    private void displayLabel(GC gc, DiagramContext context) {
        float[] centerPoint = this.getLabelPosition();
        String label = this.model.getId();
        if (this.model.getLabel() != null && !"\\N".equals(this.model.getLabel())) {
            label = this.model.getLabel();
        }
        GcUtils.drawTextAligned((GC)gc, (String)label, (float)centerPoint[0], (float)centerPoint[1], (int)-1);
    }

    private float[] getLabelPosition() {
        if (this.model.getLabelPosition() != null) {
            return Geometry.copyPoints((float[])this.model.getLabelPosition());
        }
        return Geometry.getRectanglePoint((float[])this.model.getPosition(), (int)-1);
    }
}

