/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter.runtime;

import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.core.Transition;
import obp.interpreter.IProgram;
import obp.interpreter.runtime.EventImpl;
import obp.interpreter.runtime.InterpreterContext;
import obp.interpreter.runtime.RootConfigurationImpl;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class RootBehaviorImpl
extends ProcessBehavior {
    private final InterpreterContext context;

    public RootBehaviorImpl(InterpreterContext context, IProgram program) {
        super(program.getName(), context.getSymbols());
        this.context = context;
    }

    @Override
    public BehaviorConfiguration createInitialConfiguration(Configuration conf) {
        RootConfigurationImpl initial = new RootConfigurationImpl();
        initial.events = new EventImpl[0];
        return initial;
    }

    @Override
    public BehaviorConfiguration readConfiguration(Boost boost) {
        RootConfigurationImpl read = new RootConfigurationImpl();
        read.events = (EventImpl[])BoostUtil.readObjectArray((Boost)boost, EventImpl.class);
        return read;
    }

    @Override
    public void writeConfiguration(Boost boost, BehaviorConfiguration processConfiguration) {
        RootConfigurationImpl wrote = (RootConfigurationImpl)processConfiguration;
        BoostUtil.writeObjectArray((Boost)boost, (BoostObject[])wrote.events);
    }

    @Override
    public Transition[] getTransitions(Configuration configuration) {
        return Transition.NO_TRANSITIONS;
    }

    @Override
    public String toStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
        RootConfigurationImpl toPrint = (RootConfigurationImpl)behaviorConfiguration;
        StringBuilder text = new StringBuilder();
        text.append("'");
        text.append(this.name);
        text.append("' ");
        text.append(this.toStringEvents(toPrint.events));
        return text.toString();
    }

    @Override
    public String toDotStringConfiguration(BehaviorConfiguration behaviorConfiguration) {
        return this.toStringConfiguration(behaviorConfiguration);
    }

    private String toStringEvents(EventImpl[] events) {
        StringBuilder text = new StringBuilder();
        text.append("[");
        for (int i = 0; i < events.length; ++i) {
            if (text.length() > 1) {
                text.append(", ");
            }
            text.append(events[i].toFancyString(this.context.getSymbols()));
        }
        text.append("]");
        return text.toString();
    }
}

