/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.Element;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NodeDecl;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class Program
implements BoostObject,
Element {
    private final List<Declaration> declarationList = new ArrayList<Declaration>();
    private NodeDecl root;

    public Program() {
    }

    protected Program(Boost boost) {
        boost.register((BoostObject)this);
        for (Declaration oneChild : BoostUtil.readObjectList((Boost)boost, Declaration.class)) {
            this.declarationList.add(oneChild);
        }
        this.root = (NodeDecl)boost.readObject(NodeDecl.class);
    }

    public List<Declaration> getDeclarationList() {
        return Collections.unmodifiableList(this.declarationList);
    }

    public int getDeclarationCount() {
        return this.declarationList.size();
    }

    public Declaration getDeclaration(int index) {
        if (index < 0 || index >= this.getDeclarationCount()) {
            return null;
        }
        return this.declarationList.get(index);
    }

    public void addDeclaration(Declaration newValue) {
        this.addDeclaration(this.getDeclarationCount(), newValue);
    }

    public void addDeclaration(int index, Declaration newValue) {
        this.declarationList.add(index, newValue);
    }

    public Declaration setDeclaration(int index, Declaration newValue) {
        return this.declarationList.set(index, newValue);
    }

    public void addAllDeclaration(Collection<Declaration> toAddList) {
        for (Declaration newValue : toAddList) {
            this.addDeclaration(this.getDeclarationCount(), newValue);
        }
    }

    public void removeDeclaration(Declaration value) {
        int index = this.declarationList.indexOf(value);
        if (index >= 0) {
            this.removeDeclaration(index);
        }
    }

    public void removeDeclaration(int index) {
        this.declarationList.remove(index);
    }

    public NodeDecl getRoot() {
        return this.root;
    }

    public void setRoot(NodeDecl newValue) {
        if (this.root == null ? newValue != null : !this.root.equals(newValue)) {
            this.root = newValue;
        }
    }

    public void writeToBoost(Boost boost) {
        BoostUtil.writeObjectCollection((Boost)boost, this.declarationList);
        boost.writeObject((BoostObject)this.root);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        visitor.visitProgram(this);
    }
}

