/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.ffi.try0;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import obp.fiacre.model.Array;
import obp.fiacre.model.ArrayedType;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Field;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;

public class TCValues2Fiacre
extends ModelVisitor.Stub {
    Map<Object, String> fieldIndex2objectName = new HashMap<Object, String>();
    Map<Object, String> field2indexName = new HashMap<Object, String>();
    Map<Object, String> cvalueNameMap = new HashMap<Object, String>();
    boolean isReturn = false;
    Stack<String> idxContext = new Stack();
    Stack<String> objContext = new Stack();
    Stack<String> cvalueContext = new Stack();
    StringBuilder code = new StringBuilder();

    @Override
    public void visitBoolType(BoolType toVisit) {
        if (this.isReturn) {
            this.code.append("\treturn result;\n");
            return;
        }
        this.code.append("\t(*env)->SetBooleanField(env, " + this.objContext.peek() + ", " + this.idxContext.peek() + ", " + this.cvalueContext.peek() + ");\n");
    }

    private void unmarshalInt(Type toVisit) {
        if (this.isReturn) {
            this.code.append("\treturn result;\n");
            return;
        }
        if (this.objContext.size() > 0) {
            this.code.append("\t(*env)->SetIntField(env, " + this.objContext.peek() + ", " + this.idxContext.peek() + ", " + this.cvalueContext.peek() + ");\n");
            return;
        }
        this.code.append("\t(*env)->SetIntField(env, " + this.objContext.peek() + ", " + this.idxContext.peek() + ", " + this.cvalueContext.peek() + ");\n");
    }

    @Override
    public void visitIntType(IntType toVisit) {
        this.unmarshalInt(toVisit);
    }

    @Override
    public void visitNatType(NatType toVisit) {
        this.unmarshalInt(toVisit);
    }

    @Override
    public void visitInterval(Interval toVisit) {
        this.unmarshalInt(toVisit);
    }

    @Override
    public void visitRecord(Record toVisit) {
        if (this.isReturn) {
            this.code.append("\tjclass resultClass = (*env)->FindClass(env, \"ex1/Stru_t\");\n");
            this.code.append("\tjmethodID methodID = (*env)->GetMethodID(env, resultClass, \"<init>\", \"(IZ)V\");\n");
            this.code.append("\tjobject resultObj = (*env)->NewObject(env, resultClass, methodID, ");
            int i = 0;
            for (Field field : toVisit.getFieldList()) {
                if (i > 0) {
                    this.code.append(", ");
                }
                this.code.append(this.cvalueNameMap.get(field));
                ++i;
            }
            this.code.append(");\n");
            this.code.append("\treturn resultObj;\n");
            return;
        }
        for (Field field : toVisit.getFieldList()) {
            String idxName = this.field2indexName.get(field);
            String objName = this.fieldIndex2objectName.get(idxName);
            this.idxContext.push(idxName);
            this.objContext.push(objName);
            this.cvalueContext.push(this.cvalueNameMap.get(field));
            field.getType().accept(this);
            this.idxContext.pop();
            this.objContext.pop();
            this.cvalueContext.pop();
        }
        if (this.objContext.size() > 0) {
            this.code.append("\t(*env)->SetObjectField(env, " + this.objContext.peek() + ", " + this.idxContext.peek() + ", 3);\n");
        }
    }

    private void unmarshalArrayedType(ArrayedType toVisit) {
    }

    @Override
    public void visitArray(Array toVisit) {
        this.unmarshalArrayedType(toVisit);
    }

    @Override
    public void visitUnion(Union toVisit) {
    }

    @Override
    public void visitQueue(Queue toVisit) {
        this.unmarshalArrayedType(toVisit);
    }

    @Override
    public void visitTypeId(TypeId toVisit) {
        toVisit.getDecl().accept(this);
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        toVisit.getIs().accept(this);
    }
}

