/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.checker;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.checker.ProgramAnalyzer;
import obp.fiacre.checker.type.CBool;
import obp.fiacre.checker.type.CExisting;
import obp.fiacre.checker.type.CInt;
import obp.fiacre.checker.type.CType;
import obp.fiacre.checker.type.ExpCTypeInferrer;
import obp.fiacre.model.Arg;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.ConstantDecl;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.DeterministicAssignment;
import obp.fiacre.model.Emission;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.Instance;
import obp.fiacre.model.InterfacedComp;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NonDeterministicAssignment;
import obp.fiacre.model.NullStmt;
import obp.fiacre.model.Par;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Profile;
import obp.fiacre.model.Reception;
import obp.fiacre.model.RefArg;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.SingleAssignment;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Synchronization;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.Wait;
import obp.fiacre.model.WhileStmt;
import obp.fiacre.util.FiacrePrinter;

public class TypeAnalyzer
extends ModelVisitor.Stub {
    private final ProgramAnalyzer caller;
    private final ExpCTypeInferrer inferrer = new ExpCTypeInferrer();
    private final Map<Type, String> typeNames = new LinkedHashMap<Type, String>();
    private final Map<CType, TypeDecl> cTypeMap = new LinkedHashMap<CType, TypeDecl>();
    private boolean valid = true;

    public TypeAnalyzer(ProgramAnalyzer caller) {
        this.caller = caller;
    }

    public Map<Type, String> getTypeNames() {
        return this.typeNames;
    }

    public Map<CType, TypeDecl> getCTypeMap() {
        return this.cTypeMap;
    }

    public boolean analyze() {
        for (Declaration declaration : this.caller.getProgram().getDeclarationList()) {
            declaration.accept(this);
        }
        return this.valid;
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        String typeName = NameUtil.capName(toVisit.getName());
        this.typeNames.put(toVisit.getIs(), typeName);
        this.cTypeMap.put(new CExisting(toVisit.getIs()), toVisit);
    }

    @Override
    public void visitConstantDecl(ConstantDecl toVisit) {
        CType found = this.infer(toVisit.getValue());
        CExisting expected = new CExisting(toVisit.getType());
        this.checksIsAssignable(toVisit.getName(), found, expected);
    }

    @Override
    public void visitComponentDecl(ComponentDecl toVisit) {
        if (toVisit.getInitAction() != null) {
            toVisit.getInitAction().accept(this);
        }
        toVisit.getBody().accept(this);
    }

    @Override
    public void visitProcessDecl(ProcessDecl toVisit) {
        toVisit.getInitAction().accept(this);
        for (Transition transition : toVisit.getTransitionList()) {
            transition.accept(this);
        }
    }

    @Override
    public void visitPar(Par toVisit) {
        for (InterfacedComp comp : toVisit.getArgList()) {
            comp.getComposition().accept(this);
        }
    }

    @Override
    public void visitInstance(Instance toVisit) {
        List<ArgumentVariable> expectedArgumentList = toVisit.getType().getArgList();
        List<Arg> foundArgumentList = toVisit.getArgList();
        if (foundArgumentList.size() == expectedArgumentList.size()) {
            for (int i = 0; i < foundArgumentList.size(); ++i) {
                CType foundCType;
                ArgumentVariable expected = expectedArgumentList.get(i);
                CExisting expectedCType = new CExisting(expected.getType());
                Arg found = foundArgumentList.get(i);
                if (expected.isRef()) {
                    if (found instanceof RefArg) {
                        RefArg refArg = (RefArg)found;
                        foundCType = new CExisting(refArg.getRef().getType());
                        this.checksIsAssignable(refArg.getRef().getName(), foundCType, expectedCType);
                        continue;
                    }
                    this.addError("Argument '" + expected.getName() + "' for node '" + toVisit.getType().getName() + "' instanciation must be a reference.\n");
                    continue;
                }
                Exp exp = (Exp)found;
                foundCType = this.infer(exp);
                this.checksIsAssignable(FiacrePrinter.toString(exp), foundCType, expectedCType);
            }
        } else {
            this.addError("Instanciates '" + toVisit.getType().getName() + "' with " + foundArgumentList.size() + " parameters, but it needs " + expectedArgumentList.size() + ".\n");
        }
    }

    @Override
    public void visitTransition(Transition toVisit) {
        toVisit.getAction().accept(this);
    }

    @Override
    public void visitDeterministicAssignment(DeterministicAssignment toVisit) {
        for (SingleAssignment assignment : toVisit.getAssignmentList()) {
            assignment.accept(this);
        }
    }

    @Override
    public void visitSingleAssignment(SingleAssignment toVisit) {
        CType expected = this.infer(toVisit.getLhs());
        CType found = this.infer(toVisit.getRhs());
        String expression = FiacrePrinter.toString(toVisit.getLhs()) + " := " + FiacrePrinter.toString(toVisit.getRhs());
        this.checksIsAssignable(expression, found, expected);
    }

    @Override
    public void visitNonDeterministicAssignment(NonDeterministicAssignment toVisit) {
        throw new IllegalArgumentException("Non deterministic assignments aren't supported.");
    }

    @Override
    public void visitCaseStmt(CaseStmt toVisit) {
        CType expected = this.infer(toVisit.getExp());
        for (Rule rule : toVisit.getRuleList()) {
            CType found = this.infer(rule.getLhs());
            this.checksIsAssignable(FiacrePrinter.toString(toVisit.getExp()), found, expected);
            rule.getAction().accept(this);
        }
    }

    @Override
    public void visitEmission(Emission toVisit) {
        Profile profile = (Profile)toVisit.getPort().getChannel();
        if (profile.getTypeCount() != toVisit.getArgCount()) {
            this.addError("Port '" + toVisit.getPort().getName() + "' needs " + profile.getTypeCount() + " argument.\n");
            return;
        }
        for (int i = 0; i < profile.getTypeCount(); ++i) {
            CExisting expected = new CExisting(profile.getType(i));
            CType found = this.infer(toVisit.getArg(i));
            this.checksIsAssignable(FiacrePrinter.toString(toVisit), found, expected);
        }
    }

    @Override
    public void visitReception(Reception toVisit) {
        Profile profile = (Profile)toVisit.getPort().getChannel();
        if (profile.getTypeCount() != toVisit.getPatternCount()) {
            this.addError("Port '" + toVisit.getPort().getName() + "' needs " + profile.getTypeCount() + " argument.\n");
            return;
        }
        for (int i = 0; i < profile.getTypeCount(); ++i) {
            CExisting expected = new CExisting(profile.getType(i));
            CType found = this.infer(toVisit.getPattern(i));
            this.checksIsAssignable(FiacrePrinter.toString(toVisit), found, expected);
        }
    }

    @Override
    public void visitForeach(Foreach toVisit) {
        this.checksIsAssignable(toVisit.getIter().getName(), new CExisting(toVisit.getIter().getType()), CInt.intType);
        toVisit.getBody().accept(this);
    }

    @Override
    public void visitIfStmt(IfStmt toVisit) {
        this.checksIsAssignable("if " + FiacrePrinter.toString(toVisit.getCondition()), this.infer(toVisit.getCondition()), CBool.boolType);
        toVisit.getThen().accept(this);
        toVisit.getElse().accept(this);
    }

    @Override
    public void visitWhileStmt(WhileStmt toVisit) {
        this.checksIsAssignable("while " + FiacrePrinter.toString(toVisit.getCondition()), this.infer(toVisit.getCondition()), CBool.boolType);
        toVisit.getBody().accept(this);
    }

    @Override
    public void visitSelect(Select toVisit) {
        for (Statement statement : toVisit.getStatementList()) {
            statement.accept(this);
        }
    }

    @Override
    public void visitSeq(Seq toVisit) {
        for (Statement statement : toVisit.getStatementList()) {
            statement.accept(this);
        }
    }

    @Override
    public void visitSynchronization(Synchronization toVisit) {
    }

    @Override
    public void visitNullStmt(NullStmt toVisit) {
    }

    @Override
    public void visitTo(To toVisit) {
    }

    @Override
    public void visitWait(Wait toVisit) {
    }

    private CType infer(Exp exp) {
        return this.inferrer.infer(exp);
    }

    private CType infer(Pattern pattern) {
        return this.inferrer.infer(pattern);
    }

    private void checksIsAssignable(String expression, CType found, CType expected) {
        if (!found.isAssignableFrom(expected)) {
            this.addError(expression + ": Expected type '" + expected + "' but found '" + found + "'.\n");
        }
    }

    private void addError(String message) {
        this.valid = false;
        this.caller.getErrorHandler().handleError(2, message);
    }
}

