/*
 * Decompiled with CFR 0.152.
 */
package obp;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import obp.OBPController;
import obp.OBPModel;
import obp.cdl.CDLDeclaration;
import obp.explorer.ExplorerConfiguration;
import obp.util.CDLUtil;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.progress.ActionMonitor;

public class OBP {
    private File fiacreProgramPath;
    private File cdlFile;
    private String cdlName;
    private boolean split = false;
    private int initSplit = 1;
    private int stepSplit = 1;
    private String memoryLimit = null;
    private boolean noConfs = false;
    private boolean quiet = false;
    private final ErrorHandler errorHandler = ErrorHandler.simple;
    private boolean isContextDriven = false;

    private void usage() {
        System.out.println("Usage: obp [options] fiacre_file.");
        System.out.println();
        System.out.println("Context parameters:");
        System.out.println("\t[--cdl or -c] (cdl_file)\tPath to associated CDL file.");
        System.out.println("\t[--name or -n] (cdl_name)\tCDL name to use, mandatory when using a CDL file.");
        System.out.println("\t[--split or -s] (init,step)\tSplit with parameters.");
        System.out.println("\t[--context-driven or -cd]\t\t");
        System.out.println();
        System.out.println("Output parameters:");
        System.out.println("\t[--no-confs]\t\t\tIf set, no confs file is created.");
        System.out.println();
        System.out.println("Exploration parameters:");
        System.out.println("\t[--memory or -m] (memory)\tConfigure memory limit for explorer (by default maximum available).");
        System.out.println();
        System.out.println("Other parameters:");
        System.out.println("\t[--quiet]\t\t\tQuiet mode, just presents results a the end.");
        System.out.println("\t[--help or -h]\t\t\tPrints this help and exit.");
    }

    public boolean readArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("--cdl".equals(args[i]) || "-c".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--cdl|-c' needs an argument.");
                    return false;
                }
                this.cdlFile = new File(args[i]);
                continue;
            }
            if ("--context-driven".equals(args[i]) || "-cd".equals(args[i])) {
                if (i == args.length) {
                    System.err.println("Option '--context-driven|-cd' needs an argument.");
                    return false;
                }
                this.isContextDriven = true;
                continue;
            }
            if ("--name".equals(args[i]) || "-n".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--name|-n' needs an argument.");
                    return false;
                }
                this.cdlName = args[i];
                continue;
            }
            if ("--split".equals(args[i]) || "-s".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--split|-s' needs an argument.");
                    return false;
                }
                String[] splitArgs = args[i].split(",");
                if (splitArgs.length != 2) {
                    System.err.println("Split argument must be like '1,1'.");
                    return false;
                }
                this.split = true;
                try {
                    this.initSplit = Integer.parseInt(splitArgs[0]);
                }
                catch (NumberFormatException e) {
                    System.err.println("Init split argument must be an integer.");
                    return false;
                }
                try {
                    this.stepSplit = Integer.parseInt(splitArgs[1]);
                    continue;
                }
                catch (NumberFormatException e) {
                    System.err.println("Step split argument must be an integer.");
                    return false;
                }
            }
            if ("--memory".equals(args[i]) || "-m".equals(args[i])) {
                if (++i == args.length) {
                    System.err.println("Option '--memory|-m' needs an argument.");
                    return false;
                }
                this.memoryLimit = args[i];
                continue;
            }
            if ("--no-confs".equals(args[i])) {
                this.noConfs = true;
                continue;
            }
            if ("--quiet".equals(args[i])) {
                this.quiet = true;
                continue;
            }
            if ("--help".equals(args[i]) || "-h".equals(args[i])) {
                this.usage();
                return false;
            }
            if (args[i].startsWith("-")) {
                System.err.println("Unknown option '" + args[i] + "'.");
                this.usage();
                return false;
            }
            if (this.fiacreProgramPath != null) continue;
            this.fiacreProgramPath = new File(args[i]);
        }
        if (this.fiacreProgramPath == null) {
            System.err.println("Fiacre program file is missing.");
            this.usage();
            return false;
        }
        if (!this.fiacreProgramPath.exists()) {
            System.err.println("Fiacre file '" + this.fiacreProgramPath.getPath() + "' doesn't exist.");
            return false;
        }
        if (!this.fiacreProgramPath.isFile()) {
            System.err.println("Fiacre file '" + this.fiacreProgramPath.getPath() + "' isn't a file.");
            return false;
        }
        if (!this.fiacreProgramPath.canRead()) {
            System.err.println("Fiacre file '" + this.fiacreProgramPath.getPath() + "' can't be read.");
            return false;
        }
        if (this.cdlFile != null && this.cdlName == null) {
            System.err.println("A CDL name ('--name|-n') is needed.");
            return false;
        }
        if (this.cdlFile != null && !this.cdlFile.exists()) {
            System.err.println("CDL file '" + this.cdlFile.getPath() + "' doesn't exist.");
            return false;
        }
        if (this.cdlFile != null && !this.cdlFile.isFile()) {
            System.err.println("CDL file '" + this.cdlFile.getPath() + "' isn't a file.");
            return false;
        }
        if (this.cdlFile != null && !this.cdlFile.canRead()) {
            System.err.println("CDL file '" + this.cdlFile.getPath() + "' can't be read.");
            return false;
        }
        return true;
    }

    public void verify() throws Exception {
        final OBPModel model = new OBPModel(this.errorHandler);
        model.addProgramFile(this.fiacreProgramPath);
        if (this.cdlFile != null) {
            model.setCdlFile(this.cdlFile);
            CDLDeclaration cdlDeclaration = CDLUtil.findDeclaration(model.getCdlUnit(), this.cdlName, CDLDeclaration.class);
            if (cdlDeclaration == null) {
                this.errorHandler.handleError(2, "CDL '" + this.cdlName + "' doesn't in CDL file '" + this.cdlFile.getPath() + "'.");
                return;
            }
            model.setCdl(cdlDeclaration);
            model.setAutoPartition(this.split);
            model.setInitialStep(this.initSplit);
            model.setSplitStep(this.stepSplit);
        }
        model.setNoConfs(this.noConfs);
        ExplorerConfiguration configuration = new ExplorerConfiguration();
        configuration.setContextDirected(this.isContextDriven);
        configuration.setMemoryLimit(this.memoryLimit);
        PrintWriter out = this.quiet ? this.createEmptyWriter() : new PrintWriter(System.out);
        final PrintWriter err = new PrintWriter(System.err);
        final OBPController controller = new OBPController(configuration, out, err);
        model.verify(controller, (ActionMonitor)new ActionMonitor.Stub(){

            public void done() {
                System.out.println(model.getResultDescription());
                err.close();
                controller.stop();
            }
        });
    }

    private PrintWriter createEmptyWriter() {
        return new PrintWriter(new StringWriter());
    }

    public static void verify(String[] args) {
        OBP main = new OBP();
        try {
            if (main.readArguments(args)) {
                main.verify();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(DiagnosticUtil.createMessage((Throwable)e));
        }
    }

    public static void main(String[] args) {
        OBP.verify(args);
    }
}

