/*
 * Decompiled with CFR 0.152.
 */
package plug.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import plug.core.IConfiguration;
import plug.storage.ClusteredSet;
import plug.utils.hash.UniversalHashedInt;

public class HashedClusteredSet<C extends IConfiguration>
extends ClusteredSet<C> {
    Map<UniversalHashedInt, Set<C>> contextMap;

    HashedClusteredSet(int size, Function<C, Integer> clusterIndexGetter) {
        super(size, clusterIndexGetter);
        Random r = new Random();
        UniversalHashedInt.a = r.nextInt(104711) + 1;
        UniversalHashedInt.b = r.nextInt(104711) + 1;
        UniversalHashedInt.p = 104711;
        UniversalHashedInt.m = 65536;
        this.contextMap = new HashMap<UniversalHashedInt, Set<C>>(UniversalHashedInt.m);
    }

    @Override
    protected Set<C> internalGet(int clusterID) {
        UniversalHashedInt key = new UniversalHashedInt(clusterID);
        return this.contextMap.get(key);
    }

    @Override
    protected void setMap(int clusterID, Set<C> map) {
        UniversalHashedInt key = new UniversalHashedInt(clusterID);
        this.contextMap.put(key, map);
    }

    @Override
    public void remove(int clusterID) {
        UniversalHashedInt key = new UniversalHashedInt(clusterID);
        this.contextMap.put(key, null);
    }
}

