/*
 * Decompiled with CFR 0.152.
 */
package plug.modules.synchronization.byClocks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import plug.modules.synchronization.byClocks.IClockSatisfiability;

public class ClockBuDDySatisfiability
implements IClockSatisfiability {
    BDDFactory B;
    Map<Integer, BDD> constraintByAutomaton;
    int numberOfClocks;
    int numberOfAutomata;

    @Override
    public void initialize(int nClocks, int nAutomata) {
        this.B = BDDFactory.init((int)1000000, (int)10000);
        this.B.setVarNum(nClocks);
        this.numberOfClocks = nClocks;
        this.numberOfAutomata = nAutomata;
        this.constraintByAutomaton = new HashMap<Integer, BDD>(nAutomata);
        this.clear();
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.numberOfAutomata; ++i) {
            BDD bdd = this.constraintByAutomaton.get(i);
            if (bdd != null && bdd.equals(this.B.zero())) continue;
            this.constraintByAutomaton.put(i, this.B.zero());
        }
    }

    @Override
    public void addTransitionConstraint(int behaviorID, int[] clockVector, int[] vocabulary) {
        BDD bdd = this.constraintByAutomaton.get(behaviorID);
        bdd.orWith(this.formula4transition(clockVector, vocabulary));
    }

    @Override
    public int[] blockedClocks(int[] clockVector, int[] vocabulary) {
        int[] stalled = new int[vocabulary.length - clockVector.length];
        int idx = 0;
        for (int clkID : vocabulary) {
            if (Arrays.binarySearch(clockVector, clkID) >= 0) continue;
            stalled[idx++] = clkID;
        }
        return stalled;
    }

    private BDD formula4transition(int[] clockVector, int[] vocabulary) {
        BDD local = this.B.one();
        int[] stalled = this.blockedClocks(clockVector, vocabulary);
        for (int clkID = 0; clkID < stalled.length; ++clkID) {
            local.andWith(this.B.ithVar(stalled[clkID]).not());
        }
        BDD localP = this.B.one();
        BDD localM = this.B.one();
        for (int i = 0; i < clockVector.length; ++i) {
            localP.andWith(this.B.ithVar(clockVector[i]));
            localM.andWith(this.B.ithVar(clockVector[i]).not());
        }
        return local.andWith(localP.orWith(localM));
    }

    @Override
    public void globalAllSAT(IClockSatisfiability.ICallbackSAT callback) {
        BDD globalConstraint = this.B.one();
        for (BDD localConstraint : this.constraintByAutomaton.values()) {
            if (localConstraint.equals(this.B.zero())) continue;
            globalConstraint.andWith(localConstraint);
        }
        BDD varSet = this.B.one();
        for (int i = 0; i < this.numberOfClocks; ++i) {
            varSet.andWith(this.B.ithVar(i));
        }
        BDD.BDDIterator iterator = globalConstraint.iterator(varSet);
        boolean[] valuation = new boolean[this.numberOfClocks];
        while (iterator.hasNext()) {
            BDD v = (BDD)iterator.next();
            for (int i = 0; i < this.numberOfClocks; ++i) {
                valuation[i] = !v.and(this.B.ithVar(i)).isZero();
            }
            callback.execute(valuation);
        }
        varSet.free();
        globalConstraint.free();
    }

    @Override
    public void done() {
        if (this.B == null) {
            return;
        }
        this.B.done();
    }
}

