/*
 * Decompiled with CFR 0.152.
 */
package obp.util;

import obp.buchi.BuchiAutomaton;
import obp.buchi.BuchiVisitor;
import obp.cdl.EventReference;
import obp.obs.ObsVisitor;
import obp.obs.Observer;
import obp.obs.Reset;
import obp.obs.State;
import obp.obs.Transition;
import obp.obs.When;
import obp.property.NullityExpression;
import obp.property.OccurrenceEvent;
import obp.property.OccurrenceExpression;
import obp.property.PrecedencyExpression;
import obp.property.Property;
import obp.property.PropertyAbsence;
import obp.property.PropertyBuchi;
import obp.property.PropertyExistence;
import obp.property.PropertyObserver;
import obp.property.PropertyPrecedence;
import obp.property.PropertyResponse;
import obp.property.PropertyVisitor;
import obp.property.Scope;
import obp.property.TempGuard;
import obp.property.TemporalOperator;
import obp.property.TimeConstrain;
import obp.util.PredicateUtil;

public class PropertyUtil
implements PropertyVisitor,
ObsVisitor,
BuchiVisitor {
    private String separator = "\n";
    private String tabulation = "\t";
    private int currentLevel = 0;
    private final StringBuilder string = new StringBuilder();

    public static String print(Property property) {
        PropertyUtil util = new PropertyUtil();
        property.accept(util);
        return util.string.toString();
    }

    public static String print(Observer obs) {
        PropertyUtil util = new PropertyUtil();
        obs.accept(util);
        return util.string.toString();
    }

    public static String print(Transition transition) {
        PropertyUtil util = new PropertyUtil();
        transition.accept(util);
        return util.string.toString();
    }

    private PropertyUtil() {
    }

    private void printSeparator() {
        this.string.append(this.separator);
        for (int i = 0; i < this.currentLevel; ++i) {
            this.string.append(this.tabulation);
        }
    }

    private void levelUp() {
        if (this.currentLevel >= 0) {
            ++this.currentLevel;
        }
    }

    private void levelDown() {
        if (this.currentLevel > 0) {
            --this.currentLevel;
        }
    }

    @Override
    public void visitNullityExpression(NullityExpression toVisit) {
        this.string.append(toVisit.getEvent().getName());
        this.string.append(" ");
        switch (toVisit.getNullity()) {
            case MayNever: {
                this.string.append("may never occur");
                break;
            }
            case Must: {
                this.string.append("must occur");
            }
        }
    }

    @Override
    public void visitOccurrenceEvent(OccurrenceEvent toVisit) {
        switch (toVisit.getArity()) {
            case ExactlyOne: {
                this.string.append("exactly one occurence of");
                break;
            }
            case OneOrMore: {
                this.string.append("one or more occurences of");
            }
        }
        this.string.append(" ");
        this.string.append(toVisit.getEvent().getName());
    }

    @Override
    public void visitOccurrenceExpression(OccurrenceExpression toVisit) {
        switch (toVisit.getOccurrence()) {
            case AllCombined: {
                this.string.append("all combined");
                break;
            }
            case AllOrdered: {
                this.string.append("all ordered");
                break;
            }
            case An: {
                this.string.append("an");
            }
        }
        this.string.append(" {");
        this.levelUp();
        int length = this.string.length();
        for (OccurrenceEvent event : toVisit.getOccurrenceEventList()) {
            if (this.string.length() > length) {
                this.string.append(";");
            }
            this.printSeparator();
            event.accept(this);
        }
        this.levelDown();
        this.printSeparator();
        this.string.append("}");
    }

    @Override
    public void visitPrecedencyExpression(PrecedencyExpression toVisit) {
        this.string.append("one of ");
        int length = this.string.length();
        for (EventReference event : toVisit.getPreEventList()) {
            if (this.string.length() > length) {
                this.string.append(", ");
            }
            this.string.append(event.getName());
        }
        this.string.append(" ");
        switch (toVisit.getPrecedency()) {
            case May: {
                this.string.append("may occur before the first one of");
                break;
            }
            case Cannot: {
                this.string.append("cannot occur before the first one of");
            }
        }
        this.string.append(" ");
        length = this.string.length();
        for (EventReference event : toVisit.getPostEventList()) {
            if (this.string.length() > length) {
                this.string.append(", ");
            }
            this.string.append(event.getName());
        }
    }

    @Override
    public void visitPropertyAbsence(PropertyAbsence toVisit) {
        if (toVisit.getScope() != null) {
            toVisit.getScope().accept(this);
            this.printSeparator();
        }
        toVisit.getOccurrenceExpression().accept(this);
        this.string.append(" occurs never ");
        if (toVisit.getTempGuard() != null) {
            toVisit.getTempGuard().accept(this);
        }
        if (toVisit.isRepeatability()) {
            this.printSeparator();
            this.string.append("repeatability: true");
        }
    }

    @Override
    public void visitPropertyExistence(PropertyExistence toVisit) {
        if (toVisit.getScope() != null) {
            toVisit.getScope().accept(this);
            this.printSeparator();
        }
        toVisit.getOccurrenceExpression().accept(this);
        this.string.append(" occurs ");
        if (toVisit.getTempGuard() != null) {
            toVisit.getTempGuard().accept(this);
        }
        if (toVisit.isRepeatability()) {
            this.printSeparator();
            this.string.append("repeatability: true");
        }
    }

    @Override
    public void visitPropertyPrecedence(PropertyPrecedence toVisit) {
        if (toVisit.getScope() != null) {
            toVisit.getScope().accept(this);
            this.printSeparator();
        }
        toVisit.getPreExpression().accept(this);
        this.printSeparator();
        switch (toVisit.getTemporalOperator().getImmediacy()) {
            case Eventually: {
                this.string.append("eventually");
                break;
            }
            case Immediately: {
                this.string.append("immediately");
            }
        }
        this.string.append(" precedes ");
        toVisit.getTemporalOperator().getTempGuard().accept(this);
        this.printSeparator();
        toVisit.getPostExpression().accept(this);
        this.printSeparator();
        for (NullityExpression nullityExpression : toVisit.getNullityExpressionList()) {
            nullityExpression.accept(this);
            this.printSeparator();
        }
        for (PrecedencyExpression precedencyExpression : toVisit.getPrecedencyExpressionList()) {
            precedencyExpression.accept(this);
            this.printSeparator();
        }
        if (toVisit.isRepeatability()) {
            this.string.append("repeatability: true");
        }
    }

    @Override
    public void visitPropertyResponse(PropertyResponse toVisit) {
        if (toVisit.getScope() != null) {
            toVisit.getScope().accept(this);
            this.printSeparator();
        }
        toVisit.getPreExpression().accept(this);
        this.printSeparator();
        switch (toVisit.getTemporalOperator().getImmediacy()) {
            case Eventually: {
                this.string.append("eventually");
                break;
            }
            case Immediately: {
                this.string.append("immediately");
            }
        }
        this.string.append(" leads-to ");
        toVisit.getTemporalOperator().getTempGuard().accept(this);
        this.printSeparator();
        toVisit.getPostExpression().accept(this);
        this.printSeparator();
        for (NullityExpression nullityExpression : toVisit.getNullityExpressionList()) {
            nullityExpression.accept(this);
            this.printSeparator();
        }
        for (PrecedencyExpression precedencyExpression : toVisit.getPrecedencyExpressionList()) {
            precedencyExpression.accept(this);
            this.printSeparator();
        }
        if (toVisit.isRepeatability()) {
            this.string.append("repeatability: true");
        }
    }

    @Override
    public void visitPropertyObserver(PropertyObserver toVisit) {
        if (toVisit.getScope() != null) {
            toVisit.getScope().accept(this);
            this.printSeparator();
        }
        toVisit.getObserver().accept(this);
    }

    @Override
    public void visitScope(Scope toVisit) {
        this.string.append(toVisit.isStrong() ? "strong" : "weak");
        this.string.append(" scope ");
        this.string.append(PredicateUtil.printPredicate(toVisit.getPredicate()));
    }

    @Override
    public void visitTempGuard(TempGuard toVisit) {
        this.string.append(toVisit.getMin().isStrict() ? "]" : "[");
        this.string.append(toVisit.getMin().getValue());
        this.string.append("..");
        this.string.append(toVisit.getMax().getValue());
        this.string.append(toVisit.getMax().isStrict() ? "[" : "]");
    }

    @Override
    public void visitTemporalOperator(TemporalOperator toVisit) {
    }

    @Override
    public void visitTimeConstrain(TimeConstrain toVisit) {
    }

    @Override
    public void visitObserver(Observer toVisit) {
        if (toVisit.getClock() != null) {
            this.string.append("clock ");
            this.string.append(toVisit.getClock());
            this.string.append(";");
            this.printSeparator();
        }
        int length = this.string.length();
        for (Transition transition : toVisit.getTransitionList()) {
            if (this.string.length() > length) {
                this.string.append(";");
                this.printSeparator();
            }
            transition.accept(this);
        }
    }

    @Override
    public void visitState(State toVisit) {
    }

    @Override
    public void visitTransition(Transition toVisit) {
        this.string.append(toVisit.getSource().getName());
        this.string.append(" -- ");
        if (toVisit.getWhen() != null) {
            toVisit.getWhen().accept(this);
        }
        this.string.append("/ ");
        if (toVisit.getGuard() != null) {
            this.string.append(PredicateUtil.printPredicate(toVisit.getGuard()));
        }
        this.string.append("/ ");
        boolean first = true;
        for (EventReference eR : toVisit.getEventsList()) {
            if (first) {
                first = false;
            } else {
                this.string.append(" & ");
            }
            this.string.append(eR.getName());
        }
        this.string.append("/ ");
        if (toVisit.getReset() != null) {
            toVisit.getReset().accept(this);
        }
        this.string.append(" -> ");
        this.string.append(toVisit.getTarget().getName());
    }

    @Override
    public void visitWhen(When toVisit) {
        this.string.append(toVisit.getClock());
        switch (toVisit.getType()) {
            case GREATER: {
                this.string.append(">");
                break;
            }
            case GREATER_OR_EQUAL: {
                this.string.append(">=");
                break;
            }
            case LESSER: {
                this.string.append("<");
                break;
            }
            case LESSER_OR_EQUAL: {
                this.string.append("<=");
            }
        }
        this.string.append(toVisit.getValue());
    }

    @Override
    public void visitReset(Reset toVisit) {
        this.string.append(toVisit.getClock());
        this.string.append(":=");
        this.string.append(toVisit.getValue());
    }

    @Override
    public void visitPropertyBuchi(PropertyBuchi toVisit) {
        toVisit.getBuchi().accept(this);
    }

    @Override
    public void visitBuchiAutomaton(BuchiAutomaton toVisit) {
        this.string.append("accept ");
        int length = this.string.length();
        for (obp.buchi.State state : toVisit.getStateList()) {
            state.accept(this);
            if (this.string.length() <= length) continue;
            this.string.append(", ");
        }
        this.string.append(";");
        this.printSeparator();
        length = this.string.length();
        for (obp.buchi.Transition transition : toVisit.getTransitionList()) {
            if (this.string.length() > length) {
                this.string.append(";");
                this.printSeparator();
            }
            transition.accept(this);
        }
    }

    @Override
    public void visitState(obp.buchi.State toVisit) {
        if (toVisit.isAccepting()) {
            this.string.append(toVisit.getName());
        }
    }

    @Override
    public void visitTransition(obp.buchi.Transition toVisit) {
        this.string.append(toVisit.getSource().getName());
        this.string.append(" -- ");
        if (toVisit.getGuard() != null) {
            this.string.append(PredicateUtil.printPredicate(toVisit.getGuard()));
        }
        this.string.append(" -> ");
        this.string.append(toVisit.getTarget().getName());
    }
}

