/*
 * Decompiled with CFR 0.152.
 */
package obp.ifx;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import obp.ifx.IFxConfiguration;
import obp.tool.ToolController;
import org.xid.basics.Basics;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.generation.MergerUtil;
import org.xid.basics.progress.ActionMonitor;

public class IFxController
extends ToolController {
    private final String separator = System.getProperty("file.separator");
    private final IFxConfiguration configuration;
    private String baseName;

    public IFxController(IFxConfiguration configuration, PrintWriter out, PrintWriter err) {
        super(out, err);
        this.configuration = configuration;
        this.setVerbose(false);
    }

    public void exploreIF(File ifFile, List<File> observers, ActionMonitor monitor) {
        this.scheduleClearResult();
        monitor.setTaskName("Translating IF to m4");
        this.schedule(ifFile.getParentFile());
        this.baseName = IFxController.getBaseName(ifFile);
        this.if2m4(observers);
        monitor.setTaskName("Compiling");
        this.compile();
        monitor.setTaskName("Exploring model");
        this.explore();
        this.schedule(monitor);
    }

    private void if2m4(List<File> observers) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.configuration.getIfxDirectory() + this.separator + "bin" + this.separator + IFxController.arch() + this.separator + (Basics.isWindows() ? "if2m4.exe" : "if2m4"));
        if (this.configuration.getIf2m4Options() != null) {
            for (String option : this.configuration.getIf2m4Options().split(" ")) {
                command.add(option);
            }
        }
        if (observers != null) {
            for (File observer : observers) {
                command.add("-obs");
                command.add(observer.getAbsolutePath());
            }
        }
        command.add(this.baseName + ".if");
        this.schedule(command.toArray(new String[command.size()]));
        this.scheduleClearResult();
    }

    private void compile() {
        String[] commandH = new String[]{this.configuration.getM4(), "-I", this.configuration.getIfxDirectory() + this.separator + "src" + this.separator + "code", "-D_CTYPE_=h", this.baseName + ".m4"};
        this.schedule(commandH);
        this.schedule(new Runnable(){

            @Override
            public void run() {
                String fileContent = IFxController.this.popResult(String.class);
                File headerFile = new File(IFxController.this.getWorkingDirectory(), IFxController.this.baseName + ".h");
                try {
                    MergerUtil.writeFile((File)headerFile, (String)fileContent, (String)"UTF-8");
                }
                catch (Exception e) {
                    IFxController.this.getErrorHandler().handleError(2, DiagnosticUtil.createMessage((Throwable)e));
                }
            }
        });
        String[] commandC = new String[]{this.configuration.getM4(), "-I", this.configuration.getIfxDirectory() + this.separator + "src" + this.separator + "code", "-D_CTYPE_=C", this.baseName + ".m4"};
        this.schedule(commandC);
        this.schedule(new Runnable(){

            @Override
            public void run() {
                String fileContent = IFxController.this.popResult(String.class);
                File headerFile = new File(IFxController.this.getWorkingDirectory(), IFxController.this.baseName + ".C");
                try {
                    MergerUtil.writeFile((File)headerFile, (String)fileContent, (String)"UTF-8");
                }
                catch (Exception e) {
                    IFxController.this.getErrorHandler().handleError(2, DiagnosticUtil.createMessage((Throwable)e));
                }
            }
        });
        ArrayList<String> compileObject = new ArrayList<String>();
        compileObject.add(this.configuration.getGplusplus());
        for (String option : IFxController.compileOptions()) {
            compileObject.add(option);
        }
        if (this.configuration.getCompileOptions() != null) {
            for (String option : this.configuration.getCompileOptions().split(" ")) {
                compileObject.add(option);
            }
        }
        compileObject.add("-c");
        compileObject.add("-o");
        compileObject.add(this.baseName + ".o");
        compileObject.add("-I" + this.configuration.getIfxDirectory() + this.separator + "src" + this.separator + "simulator");
        compileObject.add("-I" + this.configuration.getIfxDirectory() + this.separator + "src" + this.separator + "simulator-t");
        compileObject.add(this.baseName + ".C");
        this.schedule(compileObject.toArray(new String[compileObject.size()]));
        ArrayList<String> compileExe = new ArrayList<String>();
        compileExe.add(this.configuration.getGplusplus());
        for (String option : IFxController.linkOptions()) {
            compileExe.add(option);
        }
        if (this.configuration.getLinkOptions() != null) {
            for (String option : this.configuration.getLinkOptions().split(" ")) {
                compileExe.add(option);
            }
        }
        compileExe.add("-o");
        compileExe.add(Basics.isWindows() ? this.baseName + ".exe" : this.baseName);
        compileExe.add(this.baseName + ".o");
        compileExe.add("-L" + this.configuration.getIfxDirectory() + this.separator + "bin" + this.separator + IFxController.arch());
        compileExe.add("-L" + this.configuration.getXercesDirectory());
        for (String option : IFxController.linkLibraries()) {
            compileExe.add(option);
        }
        if (this.configuration.getExtraLibOptions() != null) {
            for (String option : this.configuration.getExtraLibOptions().split(" ")) {
                compileExe.add(option);
            }
        }
        this.schedule(compileExe.toArray(new String[compileExe.size()]));
    }

    private void explore() {
        String explorer = Basics.isWindows() ? this.getWorkingDirectory() + this.separator + this.baseName + ".exe" : "." + this.separator + this.baseName;
        String[] explore = new String[]{explorer, "-bfs", "-t", this.baseName + ".aut", "-q", this.baseName + ".states"};
        this.schedule(explore);
    }

    public void clean(ActionMonitor monitor) {
        this.scheduleClearResult();
        if (this.baseName != null) {
            this.schedule(new Runnable(){

                @Override
                public void run() {
                    File[] toRemove;
                    for (File oneFile : toRemove = new File[]{new File(IFxController.this.getWorkingDirectory(), IFxController.this.baseName + ".m4"), new File(IFxController.this.getWorkingDirectory(), IFxController.this.baseName + ".h"), new File(IFxController.this.getWorkingDirectory(), IFxController.this.baseName + ".C"), new File(IFxController.this.getWorkingDirectory(), IFxController.this.baseName + ".o"), new File(IFxController.this.getWorkingDirectory(), Basics.isWindows() ? IFxController.this.baseName + ".exe" : IFxController.this.baseName), new File(IFxController.this.getWorkingDirectory(), IFxController.this.baseName + ".aut"), new File(IFxController.this.getWorkingDirectory(), IFxController.this.baseName + ".states")}) {
                        if (!oneFile.exists()) continue;
                        oneFile.delete();
                    }
                }
            });
        }
        this.schedule(monitor);
    }

    public static String arch() {
        String os = System.getProperty("os.name");
        if (os.contains("Windows")) {
            return "win32";
        }
        if (os.contains("Mac OS X")) {
            return "Mac_iX86";
        }
        return "iX86";
    }

    public static String[] compileOptions() {
        String os = System.getProperty("os.name");
        if (os.contains("Windows")) {
            return new String[0];
        }
        if (os.contains("Mac OS X")) {
            return new String[]{"-arch", "i386"};
        }
        return new String[0];
    }

    public static String[] linkOptions() {
        String os = System.getProperty("os.name");
        if (os.contains("Windows")) {
            return new String[0];
        }
        if (os.contains("Mac OS X")) {
            return new String[]{"-arch", "i386"};
        }
        return new String[0];
    }

    public static String[] linkLibraries() {
        String os = System.getProperty("os.name");
        if (os.contains("Windows")) {
            return new String[]{"-lsimulator", "-lexplorator", "-lxerces-c27.dll"};
        }
        return new String[]{"-lsimulator", "-lexplorator", "-lxerces-c.27"};
    }
}

