/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.Communication;
import obp.fiacre.model.Emission;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Foreach;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.PatternExp;
import obp.fiacre.model.PatternStmt;
import obp.fiacre.model.Reception;
import obp.fiacre.model.Rule;
import obp.fiacre.model.Select;
import obp.fiacre.model.Seq;
import obp.fiacre.model.Statement;
import obp.fiacre.model.Synchronization;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.model.UnExp;
import obp.fiacre.model.UnOp;
import obp.fiacre.model.Variable;
import obp.fiacre.model.Wait;
import obp.fiacre.model.WhileStmt;
import obp.fiacre.util.ExpressionUtil;
import obp.fiacre.util.StatementUtil;
import obp.fiacre.util.TransitionBranch;

public class BranchExtractor {
    public static Collection<TransitionBranch> extractForCompiler(String source, Transition transition) {
        TransitionBranch initial = new TransitionBranch(source);
        Set<TransitionBranch> branches = BranchExtractor.extractForCompiler(transition.getAction(), initial);
        for (TransitionBranch branch : branches) {
            BranchExtractor.checkBranch(branch);
        }
        return branches;
    }

    private static Set<TransitionBranch> extractForCompiler(Statement statement, TransitionBranch current) {
        if (statement instanceof Foreach) {
            if (BranchExtractor.needToBeSplit(statement)) {
                throw new IllegalArgumentException("Statement 'foreach' cannot contain 'select', 'wait' nor communications statements.");
            }
            current.getAction().addStatement(statement);
            return Collections.singleton(current);
        }
        if (statement instanceof WhileStmt) {
            if (BranchExtractor.needToBeSplit(statement)) {
                throw new IllegalArgumentException("Statement 'while' cannot contain 'select', 'wait' nor communications statements.");
            }
            current.getAction().addStatement(statement);
            return Collections.singleton(current);
        }
        if (statement instanceof CaseStmt) {
            if (BranchExtractor.needToBeSplit(statement)) {
                CaseStmt caseStmt = (CaseStmt)statement;
                Exp expression = caseStmt.getExp();
                BranchExtractor.checkExpressionContainsModifiedVariable(current, expression);
                LinkedHashSet<TransitionBranch> result = new LinkedHashSet<TransitionBranch>();
                for (Rule rule : caseStmt.getRuleList()) {
                    TransitionBranch newBranch = BranchExtractor.copyBranch(current);
                    PatternExp patternExp = new PatternExp();
                    patternExp.setExp(expression);
                    patternExp.setPattern(rule.getLhs());
                    newBranch.getConditionList().add(patternExp);
                    PatternStmt patternStmt = new PatternStmt();
                    patternStmt.setExp(expression);
                    patternStmt.setPattern(rule.getLhs());
                    Seq ruleSeq = new Seq();
                    ruleSeq.addStatement(patternStmt);
                    ruleSeq.addStatement(rule.getAction());
                    result.addAll(BranchExtractor.extractForCompiler(ruleSeq, newBranch));
                }
                return result;
            }
            current.getAction().addStatement(statement);
            return Collections.singleton(current);
        }
        if (statement instanceof IfStmt) {
            if (BranchExtractor.needToBeSplit(statement)) {
                IfStmt ifStmt = (IfStmt)statement;
                Exp expression = ifStmt.getCondition();
                BranchExtractor.checkExpressionContainsModifiedVariable(current, expression);
                LinkedHashSet<TransitionBranch> result = new LinkedHashSet<TransitionBranch>();
                TransitionBranch thenBranch = BranchExtractor.copyBranch(current);
                thenBranch.getConditionList().add(expression);
                result.addAll(BranchExtractor.extractForCompiler(ifStmt.getThen(), thenBranch));
                if (ifStmt.getElse() != null) {
                    TransitionBranch elseBranch = BranchExtractor.copyBranch(current);
                    UnExp notCondition = new UnExp();
                    notCondition.setUnop(UnOp.UNOT);
                    notCondition.setExp(expression);
                    elseBranch.getConditionList().add(notCondition);
                    result.addAll(BranchExtractor.extractForCompiler(ifStmt.getElse(), elseBranch));
                }
                return result;
            }
            current.getAction().addStatement(statement);
            return Collections.singleton(current);
        }
        if (statement instanceof Seq) {
            Seq seq = (Seq)statement;
            if (seq.getStatementCount() == 0) {
                throw new IllegalArgumentException("Sequence doesn't have children (shoudln't exist).");
            }
            Set<TransitionBranch> currentResult = BranchExtractor.extractForCompiler(seq.getStatement(0), current);
            for (int i = 1; i < seq.getStatementCount(); ++i) {
                LinkedHashSet<TransitionBranch> newResult = new LinkedHashSet<TransitionBranch>();
                for (TransitionBranch currentBranch : currentResult) {
                    if (currentBranch.isComplete()) {
                        newResult.add(currentBranch);
                        continue;
                    }
                    newResult.addAll(BranchExtractor.extractForCompiler(seq.getStatement(i), currentBranch));
                }
                currentResult = newResult;
            }
            return currentResult;
        }
        if (statement instanceof Select) {
            Select select = (Select)statement;
            LinkedHashSet<TransitionBranch> result = new LinkedHashSet<TransitionBranch>();
            for (Statement child : select.getStatementList()) {
                result.addAll(BranchExtractor.extractForCompiler(child, BranchExtractor.copyBranch(current)));
            }
            return result;
        }
        if (statement instanceof To) {
            current.getAction().addStatement(statement);
            current.setComplete(true);
            return Collections.singleton(current);
        }
        current.getAction().addStatement(statement);
        return Collections.singleton(current);
    }

    private static void checkExpressionContainsModifiedVariable(TransitionBranch current, Exp expression) {
        Set<Variable> usedVariables = ExpressionUtil.findUsedVariables(expression);
        Set<Variable> modifiedVariables = StatementUtil.findModifiedVariables(current.getAction());
        for (Variable usedVariable : usedVariables) {
            if (!modifiedVariables.contains(usedVariable)) continue;
            throw new IllegalArgumentException("Variable '" + usedVariable.getName() + "' has been modified, can't split the if statement that uses it.");
        }
    }

    private static void checkBranch(TransitionBranch branch) {
        Seq seq = branch.getAction();
        List<Communication> comms = StatementUtil.findAll(Communication.class, seq);
        List<Wait> waits = StatementUtil.findAll(Wait.class, seq);
        if (comms.size() > 1) {
            throw new IllegalArgumentException("A transition from state '" + branch.getSource() + "' contains more than one communication, it's forbidden.");
        }
        if (waits.size() > 1) {
            throw new IllegalArgumentException("A transition from state '" + branch.getSource() + "' contains more than one wait, it's forbidden.");
        }
        if (comms.size() > 0 && waits.size() > 0) {
            throw new IllegalArgumentException("A transition from state '" + branch.getSource() + "' contains both wait and communication, it's forbidden.");
        }
        ToBeforeWaitOrCommunicationVisitor visitor = new ToBeforeWaitOrCommunicationVisitor();
        branch.getAction().accept(visitor);
    }

    private static TransitionBranch copyBranch(TransitionBranch branch) {
        TransitionBranch copy = new TransitionBranch(branch.getSource());
        for (Exp condition : branch.getConditionList()) {
            copy.getConditionList().add(condition);
        }
        for (Statement statement : branch.getAction().getStatementList()) {
            copy.getAction().addStatement(statement);
        }
        copy.setComplete(branch.isComplete());
        return copy;
    }

    private static boolean needToBeSplit(Statement statement) {
        if (StatementUtil.findFirst(Select.class, statement) != null) {
            return true;
        }
        if (StatementUtil.findFirst(Communication.class, statement) != null) {
            return true;
        }
        return StatementUtil.findFirst(Wait.class, statement) != null;
    }

    private static class ToBeforeWaitOrCommunicationVisitor
    extends ModelVisitor.Stub {
        boolean toFound = false;

        private ToBeforeWaitOrCommunicationVisitor() {
        }

        @Override
        public void visitCaseStmt(CaseStmt toVisit) {
            boolean original = this.toFound;
            boolean result = this.toFound;
            for (Rule rule : toVisit.getRuleList()) {
                this.toFound = original;
                rule.getAction().accept(this);
                result |= this.toFound;
            }
            this.toFound = result;
        }

        @Override
        public void visitForeach(Foreach toVisit) {
            toVisit.getBody().accept(this);
        }

        @Override
        public void visitIfStmt(IfStmt toVisit) {
            boolean original = this.toFound;
            boolean result = this.toFound;
            toVisit.getThen().accept(this);
            result |= this.toFound;
            if (toVisit.getElse() != null) {
                this.toFound = original;
                toVisit.getElse().accept(this);
                result |= this.toFound;
            }
            this.toFound = result;
        }

        @Override
        public void visitSeq(Seq toVisit) {
            for (Statement statement : toVisit.getStatementList()) {
                statement.accept(this);
            }
        }

        @Override
        public void visitSelect(Select toVisit) {
            throw new IllegalArgumentException("Select statement should be split upstream (shoudn't happen contact OBP team).");
        }

        @Override
        public void visitWhileStmt(WhileStmt toVisit) {
            toVisit.getBody().accept(this);
        }

        @Override
        public void visitEmission(Emission toVisit) {
            this.checkToFound();
        }

        @Override
        public void visitReception(Reception toVisit) {
            this.checkToFound();
        }

        @Override
        public void visitSynchronization(Synchronization toVisit) {
            this.checkToFound();
        }

        @Override
        public void visitWait(Wait toVisit) {
            this.checkToFound();
        }

        @Override
        public void visitTo(To toVisit) {
            this.toFound = true;
        }

        void checkToFound() {
            if (this.toFound) {
                throw new IllegalArgumentException("Unsupported transition containing a 'to' before a communication or a wait.");
            }
        }
    }
}

