/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer;

import java.io.File;
import java.util.Arrays;
import obp.cc.ConcreteContext;
import obp.explorer.runtime.ProgramLoader;
import obp.result.ExplorationResultInfo;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class ExplorerResult
extends ExplorationResultInfo {
    private final ProgramLoader programLoader;
    private String[] observerDescriptions;
    private int[] observerRejectReachedFirstConfiguration;
    private int[] observerSuccessReachedFirstConfiguration;
    private boolean[] observerMovement;
    private String[] assertDescriptions;
    private int[] assertsViolatedFirstConfiguration;
    private int[] finalConfigurations;

    public ExplorerResult(ProgramLoader programLoader, ConcreteContext context, File ccsl, File resultFile) {
        super(context, ccsl, resultFile);
        this.programLoader = programLoader;
    }

    protected ExplorerResult(Boost boost) {
        super(boost);
        this.programLoader = (ProgramLoader)boost.readObject(ProgramLoader.class);
        this.observerDescriptions = BoostUtil.readStringArray((Boost)boost);
        this.observerRejectReachedFirstConfiguration = BoostUtil.readIntArray((Boost)boost);
        this.observerSuccessReachedFirstConfiguration = BoostUtil.readIntArray((Boost)boost);
        this.observerMovement = BoostUtil.readBooleanArray((Boost)boost);
        this.assertDescriptions = BoostUtil.readStringArray((Boost)boost);
        this.assertsViolatedFirstConfiguration = BoostUtil.readIntArray((Boost)boost);
        this.finalConfigurations = BoostUtil.readIntArray((Boost)boost);
    }

    public void initialize(String[] observerDescriptions, String[] assertDescriptions) {
        this.observerDescriptions = observerDescriptions;
        this.observerRejectReachedFirstConfiguration = new int[observerDescriptions.length];
        Arrays.fill(this.observerRejectReachedFirstConfiguration, -1);
        this.observerSuccessReachedFirstConfiguration = new int[observerDescriptions.length];
        Arrays.fill(this.observerSuccessReachedFirstConfiguration, -1);
        this.observerMovement = new boolean[observerDescriptions.length];
        this.assertDescriptions = assertDescriptions;
        this.assertsViolatedFirstConfiguration = new int[assertDescriptions.length];
        Arrays.fill(this.assertsViolatedFirstConfiguration, -1);
        this.finalConfigurations = new int[0];
    }

    public ProgramLoader getProgramLoader() {
        return this.programLoader;
    }

    public String[] getObserverDescriptions() {
        return this.observerDescriptions;
    }

    public int[] getObserverRejectReachedFirstConfiguration() {
        return this.observerRejectReachedFirstConfiguration;
    }

    public int[] getObserverSuccessReachedFirstConfiguration() {
        return this.observerSuccessReachedFirstConfiguration;
    }

    public boolean[] getObserverMovement() {
        return this.observerMovement;
    }

    public String[] getAssertDescriptions() {
        return this.assertDescriptions;
    }

    public int[] getAssertsViolatedFirstConfiguration() {
        return this.assertsViolatedFirstConfiguration;
    }

    public int[] getFinalConfigurations() {
        return this.finalConfigurations;
    }

    public void setFinalConfigurations(int[] finalConfigurations) {
        this.finalConfigurations = finalConfigurations;
    }

    @Override
    public void writeToBoost(Boost boost) {
        super.writeToBoost(boost);
        boost.writeObject((BoostObject)this.programLoader);
        BoostUtil.writeStringArray((Boost)boost, (String[])this.observerDescriptions);
        BoostUtil.writeIntArray((Boost)boost, (int[])this.observerRejectReachedFirstConfiguration);
        BoostUtil.writeIntArray((Boost)boost, (int[])this.observerSuccessReachedFirstConfiguration);
        BoostUtil.writeBooleanArray((Boost)boost, (boolean[])this.observerMovement);
        BoostUtil.writeStringArray((Boost)boost, (String[])this.assertDescriptions);
        BoostUtil.writeIntArray((Boost)boost, (int[])this.assertsViolatedFirstConfiguration);
        BoostUtil.writeIntArray((Boost)boost, (int[])this.finalConfigurations);
    }

    @Override
    public String toString() {
        int i;
        StringBuilder description = new StringBuilder();
        description.append(super.toString());
        description.append("\n");
        description.append("--------------------Verification---------------------");
        description.append("\n");
        if (this.observerDescriptions != null && this.observerDescriptions.length > 0) {
            int i2;
            int obsCount = this.observerDescriptions.length;
            boolean oneRejectReached = false;
            boolean oneSuccessReached = false;
            for (i2 = 0; i2 < obsCount; ++i2) {
                oneRejectReached |= this.observerRejectReachedFirstConfiguration[i2] >= 0;
                oneSuccessReached |= this.observerSuccessReachedFirstConfiguration[i2] >= 0;
            }
            if (oneRejectReached || oneSuccessReached) {
                description.append("Properties:\n");
                for (i2 = 0; i2 < obsCount; ++i2) {
                    if (this.observerRejectReachedFirstConfiguration[i2] < 0 && this.observerSuccessReachedFirstConfiguration[i2] < 0) continue;
                    description.append("- '");
                    description.append(this.observerDescriptions[i2]);
                    description.append("': ");
                    int length = description.length();
                    if (this.observerRejectReachedFirstConfiguration[i2] >= 0) {
                        description.append(" reached reject the first time in configuration ");
                        description.append(this.observerRejectReachedFirstConfiguration[i2]);
                    }
                    if (this.observerSuccessReachedFirstConfiguration[i2] >= 0) {
                        if (length < description.length()) {
                            description.append(" and");
                        }
                        description.append(" reached success the first time in configuration ");
                        description.append(this.observerSuccessReachedFirstConfiguration[i2]);
                    }
                    description.append(".\n");
                }
                description.append("\n");
            }
        }
        if (this.assertsViolatedFirstConfiguration != null && this.assertsViolatedFirstConfiguration.length > 0) {
            boolean oneViolated = false;
            for (i = 0; i < this.assertsViolatedFirstConfiguration.length; ++i) {
                oneViolated |= this.assertsViolatedFirstConfiguration[i] >= 0;
            }
            if (oneViolated) {
                description.append("Violated asserts:\n");
                for (i = 0; i < this.assertsViolatedFirstConfiguration.length; ++i) {
                    if (this.assertsViolatedFirstConfiguration[i] < 0) continue;
                    StringBuilder message = new StringBuilder();
                    message.append("- '");
                    message.append(this.assertDescriptions[i]);
                    message.append("' the first time in configuration ");
                    message.append(this.assertsViolatedFirstConfiguration[i]);
                    message.append(".\n");
                    description.append((CharSequence)message);
                }
            } else {
                description.append("No assert violated.\n");
            }
            description.append("\n");
        }
        description.append("--------------------Warning---------------------");
        description.append("\n");
        StringBuilder warning = new StringBuilder();
        if (this.observerMovement != null) {
            for (i = 0; i < this.observerMovement.length; ++i) {
                if (this.observerMovement[i]) continue;
                warning.append("Observer '");
                warning.append(this.observerDescriptions[i]);
                warning.append("' never left start state.\n");
            }
        }
        if (this.finalConfigurations.length > 0) {
            warning.append("Final states: ");
            for (i = 0; i < this.finalConfigurations.length; ++i) {
                if (i > 0) {
                    warning.append(", ");
                }
                warning.append(this.finalConfigurations[i]);
            }
            warning.append("\n");
        }
        if (warning.length() > 0) {
            description.append((CharSequence)warning);
        } else {
            description.append("No warning.");
        }
        return description.toString();
    }
}

