/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.actions;

import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.actions.Action;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.variable.ChannelVariable;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.util.StringWriter;

public class ExprAction
extends Action {
    private final Expression expr;

    public ExprAction(Expression expression) {
        super(expression.getToken());
        this.expr = expression;
        for (VariableAccess variableAccess : expression.readVariables()) {
            variableAccess.getVar().setRead(true);
        }
    }

    @Override
    public String getEnabledExpression() throws ParseException {
        String string = this.expr.getBoolExpression();
        if (string == null || string.equals("true")) {
            return null;
        }
        return string;
    }

    @Override
    public boolean isLocal(Proctype proctype) {
        for (VariableAccess variableAccess : this.expr.readVariables()) {
            if (proctype.hasVariable(variableAccess.getVar().getName()) && !(variableAccess.getVar() instanceof ChannelVariable)) continue;
            return false;
        }
        return super.isLocal(proctype);
    }

    @Override
    public void printTakeStatement(StringWriter stringWriter) throws ParseException {
        String string = this.expr.getSideEffect();
        if (string != null) {
            stringWriter.appendLine(string, ";");
        }
    }

    @Override
    public void printUndoStatement(StringWriter stringWriter) throws ParseException {
        if (this.expr.getSideEffect() != null) {
            stringWriter.appendLine("endProcess();");
        }
    }

    @Override
    public String toString() {
        return this.expr.toString();
    }

    public Expression getExpression() {
        return this.expr;
    }
}

