/*
 * Decompiled with CFR 0.152.
 */
package plug.statespace.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.statespace.ITransitionStorage;
import plug.statespace.transitions.FiredTransition;

public class TargetOnlyTransitionStorage<C extends IConfiguration, A>
implements ITransitionStorage<C, A> {
    Map<C, Set<C>> adjacencyList = new HashMap<C, Set<C>>();
    int size = 0;
    int edgeCount = 0;

    @Override
    public IFiredTransition put(IFiredTransition<C, A> transition) {
        ++this.size;
        this.edgeCount += transition.getTargets().size();
        Set<C> fanout = this.adjacencyList.get(transition.getSource());
        if (fanout == null) {
            fanout = new HashSet<C>();
            this.adjacencyList.put(transition.getSource(), fanout);
        }
        for (IConfiguration target : transition.getTargets()) {
            fanout.add(target);
        }
        return transition;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public C getParent(C configuration) {
        for (Map.Entry<C, Set<C>> entry : this.adjacencyList.entrySet()) {
            for (IConfiguration target : entry.getValue()) {
                if (target != configuration) continue;
                return (C)((IConfiguration)entry.getKey());
            }
        }
        return null;
    }

    @Override
    public Collection<IFiredTransition<C, A>> getFiredFrom(C configuration) {
        Set<C> result = this.adjacencyList.get(configuration);
        if (result == null) {
            return Collections.emptyList();
        }
        ArrayList<IFiredTransition<C, A>> fired = new ArrayList<IFiredTransition<C, A>>(result.size());
        for (IConfiguration target : result) {
            fired.add(new FiredTransition<IConfiguration, Object>((IConfiguration)configuration, target, null));
        }
        return fired;
    }

    @Override
    public Collection<IFiredTransition<C, A>> getFiredTo(C configuration) {
        return Collections.emptyList();
    }

    @Override
    public int getEdgeCount() {
        return this.edgeCount;
    }
}

