/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.error;

import org.xid.basics.Basics;
import org.xid.basics.error.Diagnostic;

public interface Validator<T> {
    public boolean isValid(T var1);

    public Diagnostic getDiagnostic();

    public static abstract class Stub<T>
    implements Validator<T> {
        protected final int style;
        protected final Diagnostic diagnostic;

        public Stub(int level, String message) {
            this(new Diagnostic.Stub(level, message), Basics.NONE);
        }

        public Stub(int level, String message, int style) {
            this(new Diagnostic.Stub(level, message), style);
        }

        public Stub(Diagnostic diagnostic, int style) {
            this.diagnostic = diagnostic;
            this.style = style;
        }

        @Override
        public Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        public boolean hasStyle(int mask) {
            return (this.style & mask) != 0;
        }
    }
}

