/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.compiler;

import java.util.List;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.checker.type.CExisting;
import obp.fiacre.compiler.NodeGenerator;
import obp.fiacre.compiler.ProgramGenerator;
import obp.fiacre.model.Arg;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Instance;
import obp.fiacre.model.LocalPortDecl;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.PortDecl;
import obp.fiacre.model.RefArg;
import obp.fiacre.model.Type;
import obp.fiacre.model.Variable;
import obp.fiacre.util.ComponentUtil;
import obp.fiacre.util.TypeUtil;
import org.xid.basics.generation.java.Java;

public class ComponentGenerator
extends NodeGenerator {
    public ComponentGenerator(ProgramGenerator caller) {
        super(caller);
    }

    public void generateComponent(ComponentDecl componentDecl) {
        if (this.needBehavior(componentDecl)) {
            this.createConfigurationClass(componentDecl);
            this.createBehaviorClass(componentDecl);
        }
        this.createCompositionClass(componentDecl);
    }

    private boolean needBehavior(ComponentDecl componentDecl) {
        return !ComponentUtil.getReferencedVariables(componentDecl).isEmpty();
    }

    private boolean needInstanceName(ComponentDecl componentDecl) {
        return !this.needBehavior(componentDecl) && componentDecl.getLocalPortCount() > 0;
    }

    private void createCompositionClass(ComponentDecl component) {
        this.getDependencyManager().clear();
        String compositionName = ProgramGenerator.getCompositionName(component);
        this.content.beginFile(compositionName + ".java");
        this.content.markImports();
        this.getDependencyManager().getShortName("obp.explorer.runtime.Component");
        this.getDependencyManager().getShortName("obp.explorer.runtime.core.Channel");
        this.getDependencyManager().getShortName("obp.explorer.runtime.Composition");
        this.content.annotation("SuppressWarnings", "\"all\"");
        this.content.beginClass(4, compositionName, "Composition", null);
        if (this.needInstanceName(component)) {
            this.generateIdSeedField();
        }
        this.content.beginAttribute(17, "Component[]", "components");
        this.content.endAttribute("components");
        this.content.beginAttribute(17, "Channel[]", "channels");
        this.content.endAttribute("channels");
        this.generateCompositionConstructors(component);
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "Component[]", "getComponents", null, new Java.Parameter[0]);
        this.content.codeln(0, "return components;");
        this.content.endMethod("getComponents");
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "Channel[]", "getChannels", null, new Java.Parameter[0]);
        this.content.codeln(0, "return channels;");
        this.content.endMethod("getChannels");
        this.content.endClass(compositionName);
        this.caller.generateImports();
        this.content.endFile(compositionName + ".java");
    }

    private void generateCompositionConstructors(ComponentDecl component) {
        String name;
        int i;
        this.getDependencyManager().getShortName("obp.explorer.runtime.SymbolsTable");
        String compositionName = ProgramGenerator.getCompositionName(component);
        Java.Parameter[] constructorParametersArray = new Java.Parameter[1 + component.getPortCount() + component.getArgCount()];
        constructorParametersArray[0] = new Java.Parameter(0, "SymbolsTable", "symbols");
        int delta = 1;
        for (i = 0; i < component.getPortCount(); ++i) {
            ParamPortDecl port = component.getPort(i);
            name = NameUtil.uncapName(port.getName());
            String broadcastShortname = this.getDependencyManager().getShortName("obp.explorer.runtime.core.BroadcastChannel");
            constructorParametersArray[i + delta] = new Java.Parameter(0, broadcastShortname, name);
        }
        delta += component.getPortCount();
        for (i = 0; i < component.getArgCount(); ++i) {
            ArgumentVariable parameter = component.getArg(i);
            name = NameUtil.uncapName(parameter.getName());
            Type type = TypeUtil.referencedType(parameter.getType());
            String typeDeclaration = TypeUtil.toJavaDeclaration(type, this.getTypeNames());
            if (parameter.isRef()) {
                String referencedArgumentImport = "obp.explorer.runtime.ReferencedArgument";
                String referencedArgumentDeclaration = "ReferencedArgument<" + typeDeclaration + ">";
                if (TypeUtil.isIntegerType(type)) {
                    referencedArgumentImport = "obp.explorer.runtime.ReferencedArgumentInt";
                    referencedArgumentDeclaration = "ReferencedArgumentInt";
                } else if (type instanceof BoolType) {
                    referencedArgumentImport = "obp.explorer.runtime.ReferencedArgumentBoolean";
                    referencedArgumentDeclaration = "ReferencedArgumentBoolean";
                }
                this.getDependencyManager().getShortName(referencedArgumentImport);
                typeDeclaration = referencedArgumentDeclaration;
            }
            constructorParametersArray[i + delta] = new Java.Parameter(0, typeDeclaration, name);
            constructorParametersArray[i + delta] = new Java.Parameter(0, typeDeclaration, name);
        }
        this.content.beginMethod(4, null, compositionName, null, constructorParametersArray);
        if (this.needBehavior(component)) {
            String behaviorName = ProgramGenerator.getBehaviorName(component);
            StringBuilder code = new StringBuilder();
            code.append(behaviorName);
            code.append(" me = new ");
            code.append(behaviorName);
            code.append("(symbols");
            for (int i2 = 1; i2 < constructorParametersArray.length; ++i2) {
                code.append(",");
                code.append(constructorParametersArray[i2].name);
            }
            code.append(");");
            this.content.codeln(0, code.toString());
            this.content.comment(1, 0, "Initializes variables");
            this.content.codeln(0, "me.createInitialConfiguration(null);");
            this.content.codeln(0, "");
        }
        String instanceName = "me.name";
        if (this.needInstanceName(component)) {
            this.content.codeln(0, "final String name = symbols.newComponentName(\"" + component.getName() + "\", idSeed++);");
            instanceName = "name";
        }
        this.getDependencyManager().getShortName("obp.explorer.runtime.core.Channel");
        StringBuilder channelArrayCode = new StringBuilder();
        channelArrayCode.append("channels = new Channel[] { ");
        for (LocalPortDecl localPortDecl : component.getLocalPortList()) {
            String name2 = NameUtil.uncapName(localPortDecl.getName());
            int[] connectedBehaviorCounts = this.getNodeAnalyzer().getConnectedBehaviorCount(localPortDecl);
            String broadcastShortname = this.getDependencyManager().getShortName("obp.explorer.runtime.core.BroadcastChannel");
            StringBuilder code = new StringBuilder();
            code.append(broadcastShortname);
            code.append(" ");
            code.append(name2);
            code.append(" = new ");
            code.append(broadcastShortname);
            code.append("(");
            code.append(instanceName);
            code.append("+\":");
            code.append(localPortDecl.getName());
            code.append("\", symbols, ");
            code.append(connectedBehaviorCounts[0]);
            code.append(", ");
            code.append(connectedBehaviorCounts[1]);
            if (localPortDecl.getMini() != null && localPortDecl.getMaxi() != null) {
                code.append(this.toJavaCode(localPortDecl.getMini()));
                code.append(this.toJavaCode(localPortDecl.getMaxi()));
            }
            code.append(");");
            this.content.codeln(0, code.toString());
            channelArrayCode.append(name2);
            channelArrayCode.append(", ");
        }
        channelArrayCode.append(" };");
        this.content.codeln(0, channelArrayCode.toString());
        this.content.codeln(0, "");
        this.content.codeln(0, "components = new Component[] {");
        if (this.needBehavior(component)) {
            this.content.codeln(2, "me,");
        }
        this.nodeInstantiationCode(ComponentUtil.getInstances(component));
        this.content.codeln(1, "};");
        this.content.codeln(0, "");
        this.content.endMethod(compositionName);
    }

    private void nodeInstantiationCode(List<Instance> instanceList) {
        for (int i = 0; i < instanceList.size(); ++i) {
            Instance instance = instanceList.get(i);
            String componentName = ProgramGenerator.getComponentName(instance.getType());
            StringBuilder code = new StringBuilder();
            code.append("new ");
            code.append(componentName);
            code.append("(symbols");
            for (PortDecl portDecl : instance.getPortList()) {
                code.append(", ");
                code.append(NameUtil.uncapName(portDecl.getName()));
            }
            for (int j = 0; j < instance.getArgCount(); ++j) {
                Arg arg = instance.getArg(j);
                code.append(", ");
                if (arg instanceof RefArg) {
                    Variable ref = ((RefArg)arg).getRef();
                    if (ref instanceof ArgumentVariable) {
                        code.append(NameUtil.uncapName(ref.getName()));
                        continue;
                    }
                    code.append("me.get");
                    code.append(NameUtil.capName(ref.getName()));
                    code.append("Ref()");
                    continue;
                }
                if (!(arg instanceof Exp)) continue;
                CExisting cType = new CExisting(instance.getType().getArg(j).getType());
                code.append(this.getExpressionGenerator().generateForComposition(cType, (Exp)arg));
            }
            code.append(")");
            if (i < instanceList.size() - 1) {
                code.append(",");
            }
            this.content.codeln(2, code.toString());
        }
    }

    private void createConfigurationClass(ComponentDecl component) {
        this.getDependencyManager().clear();
        String configurationName = ProgramGenerator.getConfigurationName(component);
        this.content.beginFile(configurationName + ".java");
        this.content.markImports();
        this.getDependencyManager().getShortName("obp.explorer.runtime.BehaviorConfiguration");
        this.content.annotation("SuppressWarnings", "\"all\"");
        this.content.beginClass(4, configurationName, "BehaviorConfiguration", null);
        this.generateConfigurationFields(component);
        this.generateConfigurationConstructors(component);
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "BehaviorConfiguration", "createCopy", null, new Java.Parameter[0]);
        this.content.codeln(0, "return new " + configurationName + "(this);");
        this.content.endMethod("createCopy");
        this.generateConfigurationEqualsAndHashCode(component);
        this.content.endClass(configurationName);
        this.caller.generateImports();
        this.content.endFile(configurationName + ".java");
    }

    private void createBehaviorClass(ComponentDecl component) {
        String processBehaviorName = ProgramGenerator.getBehaviorName(component);
        this.getDependencyManager().clear();
        this.content.beginFile(processBehaviorName + ".java");
        this.content.markImports();
        this.getDependencyManager().getShortName("obp.explorer.runtime.core.Transition");
        this.getDependencyManager().getShortName("obp.explorer.runtime.ProcessBehavior");
        this.getDependencyManager().getShortName("obp.explorer.runtime.core.Channel");
        this.content.annotation("SuppressWarnings", "\"all\"");
        this.content.beginClass(4, processBehaviorName, "ProcessBehavior", null);
        this.generateIdSeedField();
        this.generateBehaviorFields(component);
        this.generateBehaviorConstructorsStart(component);
        this.generateBehaviorConstructorsEnd(component);
        for (LocalVariable variable : ComponentUtil.getReferencedVariables(component)) {
            this.generateVariableReference(component, variable);
        }
        this.content.beginAttribute(17, "Transition[]", "transitions");
        this.content.code("new Transition[0]");
        this.content.endAttribute("transitions");
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "Transition[]", "getTransitions", null, new Java.Parameter[]{new Java.Parameter(0, "Configuration", "configuration")});
        this.content.codeln(0, "return transitions;");
        this.content.endMethod("getTransitions");
        this.generateBehaviorInitialConfigurationMethod(component);
        this.generateBehaviorToString(component);
        this.generateBehaviorReadWriteConfigurationMethod(component);
        this.content.endClass(processBehaviorName);
        this.caller.generateImports();
        this.content.endFile(processBehaviorName + ".java");
    }

    private void generateVariableReference(ComponentDecl component, LocalVariable variable) {
        Type type = TypeUtil.referencedType(variable.getType());
        String typeDeclaration = TypeUtil.toJavaDeclaration(type, this.getTypeNames());
        boolean genericTypeArgument = true;
        String referencedArgumentImport = "obp.explorer.runtime.ReferencedArgument";
        String referencedArgumentDeclaration = "ReferencedArgument<" + typeDeclaration + ">";
        if (TypeUtil.isIntegerType(type)) {
            referencedArgumentImport = "obp.explorer.runtime.ReferencedArgumentInt";
            referencedArgumentDeclaration = "ReferencedArgumentInt";
            genericTypeArgument = false;
        } else if (type instanceof BoolType) {
            referencedArgumentImport = "obp.explorer.runtime.ReferencedArgumentBoolean";
            referencedArgumentDeclaration = "ReferencedArgumentBoolean";
            genericTypeArgument = false;
        }
        this.getDependencyManager().getShortName(referencedArgumentImport);
        this.getDependencyManager().getShortName("obp.explorer.runtime.Configuration");
        String configurationName = ProgramGenerator.getConfigurationName(component);
        String name = NameUtil.uncapName(variable.getName());
        String methodName = "get" + NameUtil.capName(variable.getName()) + "Ref";
        this.content.beginMethod(4, referencedArgumentDeclaration, methodName, null, new Java.Parameter[0]);
        this.content.code("return ");
        this.content.beginAnonymousClass(referencedArgumentDeclaration, new String[]{"id"});
        this.content.annotation("Override", null);
        this.content.beginMethod(4, typeDeclaration, "get", null, new Java.Parameter[]{new Java.Parameter(0, "Configuration", "configuration")});
        this.content.codeln(0, configurationName + " me = (" + configurationName + ") configuration.behaviorConfigurations[ownerId];");
        this.content.codeln(0, "return me." + name + ";");
        this.content.endMethod("get");
        this.content.annotation("Override", null);
        this.content.beginMethod(4, "void", "set", null, new Java.Parameter[]{new Java.Parameter(0, "Configuration", "configuration"), new Java.Parameter(0, typeDeclaration, "value")});
        this.content.codeln(0, configurationName + " me = (" + configurationName + ") configuration.behaviorConfigurations[ownerId];");
        this.content.codeln(0, "me." + name + " = value;");
        this.content.endMethod("set");
        if (genericTypeArgument) {
            this.content.annotation("Override", null);
            this.content.beginMethod(4, " Class<" + typeDeclaration + ">", "getArgumentType", null, new Java.Parameter[0]);
            this.content.codeln(0, "return " + typeDeclaration + ".class;");
            this.content.endMethod("getArgumentType");
        }
        this.content.endAnnonymousClass(referencedArgumentDeclaration);
        this.content.code(";");
        this.content.endMethod(methodName);
    }
}

