/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.buchikripke.runtime;

import java.util.HashMap;
import java.util.LinkedList;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.language.buchikripke.runtime.KRIPKE2TBA_TBA_ProductSemantics;
import obp2.language.buchikripke.runtime.KripkeBuchiConfiguration;
import obp2.language.buchikripke.runtime.KripkeBuchiMarshaller;
import obp2.language.buchikripke.runtime.KripkeBuchiRuntimeView;
import obp2.language.buchikripke.runtime.SE_KRIPKE_TBA_ProductSemantics;
import obp2.runtime.core.IAtomicPropositionsEvaluator;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.LanguageModule;
import plug.utils.Pair;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.PropositionalLogic.interpreter.EvaluatorSpaghetti;
import properties.PropositionalLogic.interpreter.IAtomEvaluator;
import properties.PropositionalLogic.interpreter.atom.AtomArrayValuationEvaluator;

public class KripkeBuchiLanguageModule
extends LanguageModule<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object, Object>, GuardedTransition>, Void> {
    public ILanguageModule kripke;
    public ILanguageModule buchi;
    public final EvaluatorSpaghetti buchiEvaluator = new EvaluatorSpaghetti();
    public final AtomArrayValuationEvaluator apValuationEvaluator;

    public KripkeBuchiLanguageModule(ILanguageModule kripke, ILanguageModule buchi, Semantics semantics) throws Exception {
        this.kripke = kripke;
        this.buchi = buchi;
        boolean hasDeadlockAtomicProposition = false;
        LinkedList<String> atoms = new LinkedList<String>();
        HashMap<String, Integer> atomMap = new HashMap<String, Integer>();
        int idx = 0;
        String firstAtom = null;
        for (String atom : buchi.getAtomicPropositionsProvider().getAtomicPropositions()) {
            if (firstAtom == null && atom != null) {
                firstAtom = atom;
            }
            if (atom == null || atomMap.containsKey(atom)) continue;
            if (atom.equals("deadlock")) {
                hasDeadlockAtomicProposition = true;
                atomMap.put(atom, 0);
                atomMap.put(firstAtom, idx++);
                if (firstAtom.equals(atom)) continue;
                atoms.removeFirst();
                atoms.addLast(firstAtom);
                continue;
            }
            atoms.addLast(atom);
            atomMap.put(atom, idx++);
        }
        IAtomicPropositionsEvaluator kripkeEvaluator = kripke.getAtomicPropositionEvaluator();
        kripkeEvaluator.registerAtomicPropositions(atoms.toArray(new String[0]));
        this.apValuationEvaluator = new AtomArrayValuationEvaluator(atomMap);
        this.buchiEvaluator.setDefaultEvaluator((IAtomEvaluator)this.apValuationEvaluator);
        switch (semantics) {
            case KRIPKE2TBA_TBA: {
                this.transitionRelation = new KRIPKE2TBA_TBA_ProductSemantics(this);
                break;
            }
            case SE_KRIPKE_TBA: {
                this.transitionRelation = new SE_KRIPKE_TBA_ProductSemantics(this, hasDeadlockAtomicProposition);
            }
        }
        this.treeProjector = new KripkeBuchiRuntimeView(this);
        this.marshaller = new KripkeBuchiMarshaller(this);
        this.isAcceptingPredicate = c -> c.buchiState.isAccepting();
    }

    public void close() throws Exception {
        this.kripke.close();
        this.buchi.close();
    }

    public static enum Semantics {
        KRIPKE2TBA_TBA,
        SE_KRIPKE_TBA;

    }
}

