/*
 * Decompiled with CFR 0.152.
 */
package obp2.ui2.simulation.fireables;

import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableSet;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import obp2.runtime.core.ITreeProjector;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.utils.ui.fx.GuiFxUtils;

class FireableTransitionCell<C, A, O>
extends ListCell<A> {
    private final ObjectProperty<ITreeProjector<C, A, O>> runtimeViewProperty;
    private final ObservableSet<A> alreadyFiredSet;
    HBox hbox = new HBox();
    Label label = new Label("(empty)");
    FontIcon stepOverIcon = new FontIcon("gmi-play-arrow:30:#2ecc71");

    public FireableTransitionCell(Consumer<A> fireCallback, ObjectProperty<ITreeProjector<C, A, O>> runtimeViewProperty, ObservableSet<A> inAlreadyFiredSet) {
        this.runtimeViewProperty = runtimeViewProperty;
        this.alreadyFiredSet = inAlreadyFiredSet;
        Tooltip tooltip = new Tooltip("Fire transition");
        tooltip.setFont(Font.font((String)"Times"));
        Tooltip.install((Node)this.stepOverIcon, (Tooltip)tooltip);
        GuiFxUtils.addButtonEffects((Node)this.stepOverIcon);
        this.hbox.getChildren().addAll((Object[])new Node[]{this.stepOverIcon, this.label});
        this.hbox.setAlignment(Pos.CENTER_LEFT);
        this.stepOverIcon.setOnMouseClicked(e -> fireCallback.accept(this.getItem()));
    }

    protected void updateItem(A item, boolean empty) {
        super.updateItem(item, empty);
        this.setText(null);
        if (empty) {
            this.setGraphic(null);
        } else {
            String text = null;
            if (this.runtimeViewProperty.get() != null) {
                text = ((ITreeProjector)this.runtimeViewProperty.get()).projectFireable(item).name;
            }
            this.label.setText(text != null ? text : item.toString());
            if (this.alreadyFiredSet.contains(item)) {
                this.label.setTextFill((Paint)Color.GRAY);
                this.stepOverIcon.setIconColor((Paint)Color.GRAY);
            } else {
                this.label.setTextFill((Paint)Color.BLACK);
                this.stepOverIcon.setIconColor((Paint)Color.valueOf((String)"#2ecc71"));
            }
            this.setGraphic((Node)this.hbox);
        }
    }
}

