/*
 * Decompiled with CFR 0.152.
 */
package obp2.ui2.execution_units;

import java.util.Collections;
import java.util.function.Consumer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;
import obp2.core.execution.Execution;
import obp2.core.fx.IAppContext;
import obp2.simulation.trace_storage.TraceStore;
import obp2.ui2.simulation.SimulationView;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.utils.ui.fx.GuiFxUtils;

public class ExecutionView
extends GridPane {
    Execution execution;
    protected final FontIcon controlIcon = new FontIcon("gmi-play-arrow:30");
    protected final FontIcon simulationIcon = new FontIcon("gmi-directions-run:20");
    protected final FontIcon stopIcon = new FontIcon("gmi-stop:20");
    protected final FontIcon clearIcon = new FontIcon("gmi-delete:15");
    protected final FontIcon progressIcon = new FontIcon("gmi-settings:15");
    protected final Label nameLabel = new Label();
    protected final Label detailsLabel = new Label();
    protected final Timeline blinkingAnimation = new Timeline(20.0, new KeyFrame[]{new KeyFrame(Duration.valueOf((String)"1s"), "rotate", new KeyValue[]{new KeyValue((WritableValue)this.progressIcon.rotateProperty(), (Object)360)}), new KeyFrame(Duration.ZERO, "update item", event -> this.updateView(), new KeyValue[0])});
    Consumer<Execution> onExecutionError;
    IAppContext appContext;

    public ExecutionView(Execution execution, Consumer<Execution> onExecutionError, IAppContext appContext) {
        this.execution = execution;
        this.onExecutionError = onExecutionError;
        this.appContext = appContext;
        this.blinkingAnimation.setCycleCount(-1);
        this.detailsLabel.setFont(new Font(10.0));
        GuiFxUtils.addButtonEffects((Node)this.controlIcon);
        GuiFxUtils.addButtonEffects((Node)this.simulationIcon);
        GuiFxUtils.addButtonEffects((Node)this.stopIcon);
        GuiFxUtils.addButtonEffects((Node)this.clearIcon);
        this.add((Node)this.nameLabel, 1, 0);
        this.add((Node)this.detailsLabel, 1, 1);
        this.add((Node)this.controlIcon, 0, 0, 1, 2);
        this.add((Node)this.simulationIcon, 3, 0, 1, 2);
        this.getColumnConstraints().add((Object)new ColumnConstraints(60.0));
        this.getColumnConstraints().add((Object)new ColumnConstraints(40.0, 60.0, Double.MAX_VALUE, Priority.ALWAYS, HPos.CENTER, true));
        this.getColumnConstraints().add((Object)new ColumnConstraints(10.0));
        this.getRowConstraints().add((Object)new RowConstraints(20.0, 20.0, 20.0, Priority.NEVER, VPos.CENTER, false));
        this.getRowConstraints().add((Object)new RowConstraints(20.0, 20.0, 20.0, Priority.NEVER, VPos.CENTER, false));
        Tooltip tooltip = new Tooltip("Click for trace simulation");
        tooltip.setFont(Font.font((String)"Times"));
        Tooltip.install((Node)this.simulationIcon, (Tooltip)tooltip);
        this.updateView();
    }

    void updateView() {
        switch (this.execution.status) {
            case CREATED: 
            case INITIALIZED: {
                this.controlIcon.setIconLiteral("gmi-play-arrow:30:black");
                this.controlIcon.setOnMouseClicked(c -> {
                    if (this.execution.status == Execution.Status.CREATED) {
                        this.execution.initialize();
                    }
                    this.execution.run();
                    this.updateView();
                });
                this.nameLabel.setGraphic(null);
                this.detailsLabel.setGraphic(null);
                this.blinkingAnimation.stop();
                break;
            }
            case RUNNING: {
                this.controlIcon.setIconLiteral("gmi-pause:30:black");
                this.controlIcon.setOnMouseClicked(c -> {
                    this.execution.pause();
                    this.updateView();
                });
                this.nameLabel.setGraphic((Node)this.stopIcon);
                this.stopIcon.setOnMouseClicked(c -> {
                    this.execution.stop();
                    this.updateView();
                });
                this.detailsLabel.setGraphic((Node)this.progressIcon);
                this.blinkingAnimation.play();
                break;
            }
            case PAUSED: {
                this.controlIcon.setIconLiteral("gmi-play-arrow:30:black");
                this.controlIcon.setOnMouseClicked(c -> {
                    this.execution.resume();
                    this.updateView();
                });
                this.nameLabel.setGraphic((Node)this.stopIcon);
                this.stopIcon.setOnMouseClicked(c -> {
                    this.execution.stop();
                    this.updateView();
                });
                this.blinkingAnimation.stop();
                break;
            }
            case STOPPED: {
                this.controlIcon.setIconLiteral("gmi-play-arrow:30:black");
                this.controlIcon.setOnMouseClicked(c -> {
                    this.execution.resume();
                    this.updateView();
                });
                this.nameLabel.setGraphic(null);
                this.detailsLabel.setGraphic(null);
                this.blinkingAnimation.stop();
                break;
            }
            case FINISHED: {
                this.controlIcon.setIconLiteral("gmi-play-arrow:30:black");
                this.controlIcon.setOnMouseClicked(c -> {
                    this.execution.reset();
                    this.execution.run();
                    this.updateView();
                });
                this.nameLabel.setGraphic((Node)this.clearIcon);
                this.clearIcon.setOnMouseClicked(c -> {
                    this.execution.reset();
                    this.updateView();
                });
                if (this.execution.getViolation() != null) {
                    this.simulationIcon.setIconColor(Paint.valueOf((String)"red"));
                } else {
                    this.simulationIcon.setIconColor(Paint.valueOf((String)"green"));
                }
                this.detailsLabel.setGraphic(null);
                this.blinkingAnimation.stop();
                break;
            }
            case FAILED: {
                this.controlIcon.setIconLiteral("gmi-rotate-right:30:black");
                this.controlIcon.setOnMouseClicked(c -> {
                    this.execution.reset();
                    this.updateView();
                });
                this.nameLabel.setGraphic(null);
                this.detailsLabel.setGraphic(null);
                this.blinkingAnimation.stop();
                this.onExecutionError.accept(this.execution);
            }
        }
        this.nameLabel.setText(this.execution.getName());
        this.detailsLabel.setText(this.execution.getDetails());
        this.simulationIcon.setOnMouseClicked(this::startSimulation);
    }

    void startSimulation(MouseEvent event) {
        SimpleObjectProperty executionTraceProperty = new SimpleObjectProperty((Object)this.execution.traceStore);
        SimpleObjectProperty initialConfigurationsProperty = ((TraceStore)executionTraceProperty.get()).getRoots().isEmpty() ? new SimpleObjectProperty((Object)this.execution.getTransitionRelation().initialConfigurations()) : new SimpleObjectProperty(Collections.emptySet());
        SimulationView simulationView = new SimulationView(new SimpleObjectProperty((Object)this.execution.getTransitionRelation()), new SimpleObjectProperty((Object)this.execution.getRuntimeView()), initialConfigurationsProperty, executionTraceProperty);
        this.appContext.openView("Analyze execution '" + this.execution.getName() + "'", (Region)simulationView, null);
    }
}

