/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.progress.ActionMonitor;

public class BatchCommand {
    public static boolean execute(String command, PrintWriter outWriter, PrintWriter errWriter) {
        return BatchCommand.execute(command, null, null, outWriter, errWriter, null, null);
    }

    public static boolean execute(String command, File workingDir, PrintWriter outWriter, PrintWriter errWriter) {
        return BatchCommand.execute(command, workingDir, null, outWriter, errWriter, null, null);
    }

    public static boolean execute(String command, File workingDir, PrintWriter outWriter, PrintWriter errWriter, ActionMonitor progress) {
        return BatchCommand.execute(command, workingDir, null, outWriter, errWriter, progress, null);
    }

    public static boolean execute(String command, File workingDir, String[] env, PrintWriter outWriter, PrintWriter errWriter, ActionMonitor monitor, ErrorHandler errorHandler) {
        if (monitor == null) {
            monitor = ActionMonitor.empty;
        }
        if (errorHandler == null) {
            errorHandler = ErrorHandler.simple;
        }
        int status = -1;
        try {
            monitor.setTaskName("Executing " + command);
            Process process = Runtime.getRuntime().exec(command, env, workingDir);
            BufferedReader outReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader errReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while (BatchCommand.isRunning(process)) {
                if (outReader.ready()) {
                    outWriter.println(outReader.readLine());
                    outWriter.flush();
                }
                if (errReader.ready()) {
                    errWriter.println(errReader.readLine());
                    errWriter.flush();
                }
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
            BatchCommand.flushReader(outReader, outWriter);
            BatchCommand.flushReader(errReader, errWriter);
            status = process.exitValue();
            monitor.done();
        }
        catch (Exception e) {
            errorHandler.handleError(2, e.getClass().getSimpleName() + ": " + e.getMessage());
            return false;
        }
        return status == 0;
    }

    private static boolean isRunning(Process process) {
        try {
            process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
        return false;
    }

    private static void flushReader(BufferedReader reader, PrintWriter writer) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            writer.println(line);
            line = reader.readLine();
        }
        writer.flush();
    }
}

