/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.sexp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Stack;
import org.xid.basics.sexp.SAtom;
import org.xid.basics.sexp.SExp;
import org.xid.basics.sexp.SList;
import org.xid.basics.sexp.SVariable;

public class SExpParser {
    private final String encoding;
    private Reader reader;
    private boolean eof = false;
    private char lookAheadChar = '\u0000';

    public SExpParser() {
        this("UTF-8");
    }

    public SExpParser(String encoding) {
        this.encoding = encoding;
    }

    public SExp parse(InputStream stream) throws IOException {
        SList rootSList;
        this.reader = new BufferedReader(new InputStreamReader(stream, this.encoding));
        this.basicReadChar();
        Stack<SList> sListStack = new Stack<SList>();
        SList currentSList = rootSList = new SList();
        sListStack.push(currentSList);
        while (!this.eof) {
            String next = this.nextToken();
            if (next.equals("(")) {
                SList newSList = new SList();
                currentSList.addChild(newSList);
                sListStack.push(newSList);
                currentSList = newSList;
                continue;
            }
            if (next.equals(")")) {
                if (sListStack.size() < 1) {
                    throw new IOException("Unexpected parenthesis ')'.");
                }
                sListStack.pop();
                currentSList = (SList)sListStack.peek();
                continue;
            }
            if (next.startsWith("${") && next.endsWith("}")) {
                String name = next.substring(2, next.length() - 1);
                currentSList.addChild(new SVariable(name));
                continue;
            }
            currentSList.addChild(new SAtom(next));
        }
        if (sListStack.size() != 1) {
            throw new IOException("Missing parenthesis ')'.");
        }
        return ((SList)sListStack.peek()).getChild(0);
    }

    private String nextToken() throws IOException {
        if (this.eof) {
            return null;
        }
        StringBuilder tokenBuffer = new StringBuilder();
        block6: while (!this.eof) {
            switch (this.lookAheadChar) {
                case '(': 
                case ')': {
                    if (tokenBuffer.length() > 0 && tokenBuffer.charAt(0) == '\'') {
                        tokenBuffer.append(this.lookAheadChar);
                        this.basicReadChar();
                        continue block6;
                    }
                    if (tokenBuffer.length() == 0) {
                        tokenBuffer.append(this.lookAheadChar);
                        this.basicReadChar();
                    }
                    return tokenBuffer.toString();
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (tokenBuffer.length() > 0 && tokenBuffer.charAt(0) == '\'') {
                        tokenBuffer.append(this.lookAheadChar);
                        this.basicReadChar();
                        continue block6;
                    }
                    this.basicReadChar();
                    if (tokenBuffer.length() <= 0) continue block6;
                    return tokenBuffer.toString();
                }
                case '\'': {
                    tokenBuffer.append(this.lookAheadChar);
                    this.basicReadChar();
                    if (tokenBuffer.length() <= 1) continue block6;
                    return tokenBuffer.toString();
                }
                case '\\': {
                    tokenBuffer.append(this.lookAheadChar);
                    this.basicReadChar();
                    if (tokenBuffer.length() <= 0 || tokenBuffer.charAt(0) != '\'') continue block6;
                    tokenBuffer.append(this.lookAheadChar);
                    this.basicReadChar();
                    continue block6;
                }
            }
            tokenBuffer.append(this.lookAheadChar);
            this.basicReadChar();
        }
        return tokenBuffer.toString();
    }

    private void basicReadChar() throws IOException {
        int read = this.reader.read();
        this.eof = read == -1;
        this.lookAheadChar = (char)read;
    }
}

