/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.progress;

public interface ActionMonitor {
    public static final int UNKNOWN = -1;
    public static final ActionMonitor empty = new Stub();

    public void setTaskName(String var1);

    public void begin(int var1);

    public void worked(int var1, int var2);

    public void done();

    public void canceled();

    public static class Sub
    implements ActionMonitor {
        private final ActionMonitor parent;
        private final int start;
        private final int length;

        public Sub(ActionMonitor parent, int start, int length) {
            this.parent = parent;
            this.start = start;
            this.length = length;
        }

        @Override
        public void setTaskName(String name) {
            this.parent.setTaskName(name);
        }

        @Override
        public void begin(int remaining) {
            this.parent.worked(this.start, this.length);
        }

        @Override
        public void worked(int workIncrement, int remaining) {
            int parentWorked = workIncrement / (workIncrement + remaining) * this.length;
            this.parent.worked(parentWorked, this.length - parentWorked);
        }

        @Override
        public void done() {
            this.parent.worked(this.start + this.length, 0);
        }

        @Override
        public void canceled() {
            this.parent.canceled();
        }
    }

    public static class Stub
    implements ActionMonitor {
        @Override
        public void setTaskName(String name) {
        }

        @Override
        public void begin(int remaining) {
        }

        @Override
        public void worked(int workIncrement, int remaining) {
        }

        @Override
        public void done() {
        }

        @Override
        public void canceled() {
        }
    }
}

