/*
 * Decompiled with CFR 0.152.
 */
package plug.storage;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import plug.core.IConfiguration;
import plug.statespace.IConfigurationStorage;
import plug.storage.ArrayedClusteredSet;
import plug.storage.HashedClusteredSet;

public abstract class ClusteredSet<C extends IConfiguration>
implements IConfigurationStorage<C> {
    int tally;
    Function<C, Integer> clusterIndexGetter;

    public static <C extends IConfiguration> ClusteredSet<C> createSet(int size, Function<C, Integer> clusterIndexGetter) {
        if (size < 65536) {
            return new ArrayedClusteredSet<C>(size, clusterIndexGetter);
        }
        return new HashedClusteredSet<C>(size, clusterIndexGetter);
    }

    ClusteredSet(int size, Function<C, Integer> clusterIndexGetter) {
        this.tally = size;
        this.clusterIndexGetter = clusterIndexGetter;
    }

    public boolean contains(C element) {
        int clusterID = this.clusterIndexGetter.apply(element);
        Set<C> map = this.internalGet(clusterID);
        if (map == null) {
            return false;
        }
        return map.contains(element);
    }

    public C get(C element) {
        return null;
    }

    public C put(C element) {
        int clusterID = this.clusterIndexGetter.apply(element);
        Set<C> map = this.internalGet(clusterID);
        if (map == null) {
            map = new HashSet<C>();
            this.setMap(clusterID, map);
        }
        map.add(element);
        return element;
    }

    public int size() {
        int count = 0;
        for (int i = 0; i < this.tally; ++i) {
            count = (int)((long)count + this.size(i));
        }
        return count;
    }

    public long size(int clusterID) {
        Set<C> map = this.internalGet(clusterID);
        return map == null ? 0L : (long)map.size();
    }

    public Collection<C> getConfigurations() {
        HashSet<C> result = new HashSet<C>();
        for (int i = 0; i < this.tally; ++i) {
            Set<C> data = this.internalGet(i);
            if (data == null) continue;
            result.addAll(data);
        }
        return result;
    }

    abstract Set<C> internalGet(int var1);

    abstract void setMap(int var1, Set<C> var2);

    public abstract void remove(int var1);
}

