/*
 * Decompiled with CFR 0.152.
 */
package spinja.store;

import java.util.Arrays;
import spinja.store.StateStore;
import spinja.store.hash.HashAlgorithm;
import spinja.store.hash.JenkinsHash;

public final class HashTable
extends StateStore {
    private final byte[][][] table;
    private int collisions;
    private int stored;
    private long bytes;
    private final HashAlgorithm hash;
    private final int mask;

    public HashTable(int n) {
        this(n, new JenkinsHash());
    }

    public HashTable(int n, HashAlgorithm hashAlgorithm) {
        if (n <= 0 || n > 31) {
            throw new IllegalArgumentException("The size should always be between 1 and 31");
        }
        this.table = new byte[1 << n][][];
        this.collisions = 0;
        this.stored = 0;
        this.hash = hashAlgorithm;
        this.mask = this.table.length - 1;
        this.bytes = 40 + 4 * this.table.length;
    }

    @Override
    public int addState(byte[] byArray) {
        int n = this.hash.hash(byArray, 0) & this.mask;
        Object object = this.table[n];
        if (object == null) {
            this.table[n] = new byte[][]{byArray};
            this.bytes += (long)(16 + (20 + byArray.length >> 3 << 3));
            ++this.stored;
        } else {
            int n2 = 0;
            for (n2 = 0; n2 < ((byte[][])object).length && object[n2] != null; ++n2) {
                if (!Arrays.equals(object[n2], byArray)) continue;
                return -n - 1;
            }
            if (n2 >= ((byte[][])object).length) {
                byte[][] byArrayArray = new byte[((byte[][])object).length << 1][];
                System.arraycopy(object, 0, byArrayArray, 0, ((byte[][])object).length);
                object = byArrayArray;
                this.table[n] = byArrayArray;
                this.bytes += (long)(4 * ((byte[][])object).length);
            }
            object[n2] = byArray;
            this.collisions += n2;
            this.bytes += (long)(20 + byArray.length >> 3 << 3);
            ++this.stored;
        }
        return n;
    }

    @Override
    public long getBytes() {
        return this.bytes;
    }

    @Override
    public void printSummary() {
        System.out.printf("hash conflicts: %d (resolved)\n", this.collisions);
        System.out.println();
    }

    @Override
    public int getStored() {
        return this.stored;
    }
}

