/*
 * Decompiled with CFR 0.152.
 */
package spinja.search;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedList;
import spinja.exceptions.SpinJaException;
import spinja.model.Model;
import spinja.model.Transition;
import spinja.search.Queue;
import spinja.search.SearchAlgorithm;
import spinja.search.SearchableStack;
import spinja.search.TransitionCalculator;
import spinja.store.StateStore;
import spinja.util.ByteArrayStorage;

public class BreadthFirstSearch<M extends Model<T>, T extends Transition>
extends SearchAlgorithm<M, T> {
    private static final long serialVersionUID = 4164987979846L;
    private final Queue queue;
    protected Queue.State fromState;
    private int depth;
    protected T last;

    public BreadthFirstSearch(M m, StateStore stateStore, boolean bl, int n, boolean bl2, TransitionCalculator<M, T> transitionCalculator) {
        this(new Queue(), m, stateStore, bl, n, bl2, transitionCalculator);
    }

    public BreadthFirstSearch(Queue queue, M m, StateStore stateStore, boolean bl, int n, boolean bl2, TransitionCalculator<M, T> transitionCalculator) {
        super(m, stateStore, bl, n, bl2, transitionCalculator);
        this.queue = queue;
        this.depth = 0;
    }

    @Override
    public SearchableStack getSearchableStack() {
        return this.queue.peek();
    }

    @Override
    protected boolean addState(byte[] byArray, int n) {
        Queue queue = this.queue;
        queue.getClass();
        return this.queue.add(new Queue.State(queue, this.fromState, byArray, this.last == null ? -1 : ((Transition)this.last).getId()));
    }

    @Override
    protected boolean checkModelState() {
        byte[] byArray = this.storeModel();
        return Arrays.equals(byArray, this.fromState.state);
    }

    @Override
    public void freeMemory() {
        this.queue.clear();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    protected T getLastTransition() {
        return this.last;
    }

    protected T nextTransition() {
        T t;
        this.last = t = this.nextTransition.next(this.model, this.last);
        return t;
    }

    @Override
    protected void outputTrace(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string + ".trail")));
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            Queue.State state = this.fromState;
            while (state.previous != null) {
                linkedList.add(0, state.transId);
                state = state.previous;
            }
            for (int i = 0; i < linkedList.size(); ++i) {
                printWriter.println(linkedList);
            }
            printWriter.flush();
            printWriter.close();
            System.out.println("spinja: wrote " + string + ".trail\n");
        }
        catch (IOException iOException) {
            System.out.println("spinja: error while writing " + string + ".trail: " + iOException.getMessage());
        }
    }

    @Override
    protected boolean restoreState() {
        if (this.fromState == null) {
            this.fromState = this.queue.remove();
            if (this.fromState == null) {
                return false;
            }
            ByteArrayStorage byteArrayStorage = new ByteArrayStorage();
            byteArrayStorage.setBuffer(this.fromState.state);
            this.model.decode(byteArrayStorage);
            this.last = null;
        } else if (this.last != null) {
            ((Transition)this.last).undo();
        }
        return true;
    }

    @Override
    protected void stateDone() {
        this.fromState = null;
    }

    @Override
    protected void takeTransition(Transition transition) throws SpinJaException {
        assert (this.print("Taking transition: " + transition));
        transition.take();
    }

    @Override
    protected void undoTransition() {
    }
}

