/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.expression;

import java.util.Set;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.parser.MyParseException;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.ChannelType;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.promela.compiler.variable.VariableType;

public class ChannelLengthExpression
extends Expression {
    private final Expression expr;

    public ChannelLengthExpression(Token token, Expression expression) throws ParseException {
        super(token);
        this.expr = expression;
        if (!expression.getResultType().canConvert(ChannelType.UNASSIGNED_CHANNEL)) {
            throw new MyParseException("A len operator can only be executed on a channel!", this.getToken());
        }
    }

    @Override
    public String getIntExpression() throws ParseException {
        return "_channels[" + this.expr.getIntExpression() + "].length()";
    }

    @Override
    public VariableType getResultType() {
        return VariableType.INT;
    }

    @Override
    public Set<VariableAccess> readVariables() {
        return this.expr.readVariables();
    }

    @Override
    public String toString() {
        return "len(" + this.expr.toString() + ")";
    }
}

