/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.obs.Action;
import obp.simulation.model.Previous;
import obp.simulation.model.SimulatedConfiguration;
import obp.simulation.observer.ConfigurationObservable;
import obp.simulation.observer.ConfigurationObserver;

public class ConfigurationModel
implements ConfigurationObservable {
    private List<ConfigurationObserver> observer = new ArrayList<ConfigurationObserver>();
    private Map<Integer, SimulatedConfiguration> configurationLTS = new HashMap<Integer, SimulatedConfiguration>();
    private int currentConfigId = 0;

    public Configuration alreadyFired(Transition toFire) {
        Map<Transition, Configuration> LTS2;
        if (this.configurationLTS.containsKey(this.currentConfigId) && (LTS2 = this.configurationLTS.get(this.currentConfigId).getLTS()).containsKey(toFire)) {
            return LTS2.get(toFire);
        }
        return null;
    }

    public void addConfiguration(Configuration config, Transition fired, Action action, String firedToString) {
        if (!this.configurationLTS.containsKey(config.id)) {
            SimulatedConfiguration newSimConf = new SimulatedConfiguration(config);
            this.configurationLTS.put(config.id, newSimConf);
            newSimConf.addPreviousConfig(this.getCurrentConfig(), action, firedToString);
            this.currentConfigId = config.id;
            this.configurationLTS.get(this.getPreviousConfigId()).addToLTS(fired, config);
            this.notifyChangeConfig(this);
        } else {
            SimulatedConfiguration configuration = this.configurationLTS.get(config.id);
            configuration.addPreviousConfig(this.getCurrentConfig(), action, firedToString);
            this.returnTo(config.id);
            this.configurationLTS.get(this.getPreviousConfigId()).addToLTS(fired, config);
        }
    }

    public Configuration getConfiguration(int id) {
        return this.configurationLTS.get(id).getConfiguration();
    }

    public SimulatedConfiguration getConfigurationFromLts(int id) {
        return this.configurationLTS.get(id);
    }

    public void reset() {
        this.configurationLTS.clear();
        this.currentConfigId = 0;
    }

    public int getNbConfig() {
        return this.configurationLTS.size();
    }

    public int nbPrevious() {
        return this.configurationLTS.get(this.currentConfigId).nbPrevious();
    }

    public int getCurrentConfigId() {
        return this.currentConfigId;
    }

    public int getPreviousConfigId() {
        return this.configurationLTS.get(this.currentConfigId).getPreviousConfiguration().getId();
    }

    public int getPreviousConfigIdOf(int id) {
        return this.configurationLTS.get(id).getPreviousConfiguration().getId();
    }

    public Previous getPreviousConfigWithAction() {
        return this.configurationLTS.get(this.currentConfigId).getPreviousConfiguration();
    }

    public Previous getPreviousConfigWithActionOf(int id) {
        return this.configurationLTS.get(id).getPreviousConfiguration();
    }

    public Configuration getCurrentConfig() {
        return this.configurationLTS.get(this.currentConfigId).getConfiguration();
    }

    public Configuration getPreviousConfig() {
        return this.getConfiguration(this.configurationLTS.get(this.currentConfigId).getPreviousConfiguration().getId());
    }

    public Configuration returnToPrevious() {
        Configuration previous = this.getPreviousConfig();
        this.currentConfigId = previous.id;
        this.notifyChangeConfig(this);
        return previous;
    }

    public Configuration returnTo(int id) {
        Configuration config = this.getConfiguration(id);
        if (config != null) {
            this.currentConfigId = config.id;
        }
        this.notifyChangeConfig(this);
        return config;
    }

    @Override
    public void addObserver(ConfigurationObserver obs) {
        this.observer.add(obs);
    }

    @Override
    public void removeObserver() {
        this.observer = new ArrayList<ConfigurationObserver>();
    }

    @Override
    public void notifyChangeConfig(ConfigurationObservable confModel) {
        for (ConfigurationObserver obs : this.observer) {
            obs.changeConfig(confModel);
        }
    }

    public Map<Integer, Previous> getPreviousList() {
        return this.configurationLTS.get(this.currentConfigId).getPreviousList();
    }

    public Map<Integer, Previous> getPreviousListOf(int id) {
        return this.configurationLTS.get(id).getPreviousList();
    }
}

