/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.graph;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.glyphs.Glyph;
import java.awt.Color;
import java.io.File;
import javax.swing.JPanel;
import net.claribole.zgrviewer.ConfigManager;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.LEdge;
import net.claribole.zgrviewer.LNode;
import net.claribole.zgrviewer.LogicalStructure;
import net.claribole.zgrviewer.MyZgrViewer;
import net.claribole.zgrviewer.Utils;
import obp.dot.util.DotUtil;
import obp.simulation.zgr.Observateur;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ZGRPanelViewer {
    public MyZgrViewer zgrViewer;
    private JPanel panelView;
    private GraphicsManager graphicsManager;

    public ZGRPanelViewer() {
        if (!new File(System.getProperty("user.home") + "/.zgrviewer").exists()) {
            System.out.println("le fichier de configuration n'existe pas");
            this.createConfigFile();
        }
        this.zgrViewer = new MyZgrViewer();
        this.panelView = this.zgrViewer.getPanelView();
        this.graphicsManager = this.zgrViewer.getGraphicsManager();
    }

    public JPanel getPanel() {
        return this.panelView;
    }

    public void loadFile(File dotFile) {
        this.zgrViewer.setFile(dotFile);
    }

    public void reload(boolean withFocus, String title) {
        if (this.zgrViewer.getLastFileOpened() != null) {
            this.zgrViewer.reload();
            if (withFocus) {
                this.focusOn(title);
            }
        }
    }

    public LNode getNode(String title) {
        LogicalStructure ls;
        if (title.startsWith("0") && title.length() > 1) {
            title = title.substring(1, title.length());
        }
        if ((ls = this.zgrViewer.getLogicalStructure()) != null) {
            LNode node = ls.getNode(title);
            return node;
        }
        System.err.println("ZGRPanelViewer.java: Pas de logical structure");
        return null;
    }

    public void focusOn(String title) {
        LogicalStructure ls;
        if (title.startsWith("0") && title.length() > 1) {
            title = title.substring(1, title.length());
        }
        if ((ls = this.zgrViewer.getLogicalStructure()) != null) {
            LNode node = ls.getNode(title);
            if (node != null) {
                Glyph g = node.getGlyphs()[0];
                Camera cam = this.graphicsManager.getGraphCamera();
                this.changeAllBorder(Color.white);
                g.setBorderColor(Color.GREEN);
                this.graphicsManager.mainView.centerOnGlyph(g, cam, 300, true, ConfigManager.MAG_FACTOR);
            } else {
                System.err.println("Node " + title + " Introuvable");
            }
        } else {
            System.err.println("ZGRPanelViewer.java: Pas de logical structure");
        }
    }

    public void svgExport(File file) {
        this.zgrViewer.exportSVG(file);
    }

    public void setBorderOn(String title) {
        LogicalStructure ls;
        if (title.startsWith("0") && title.length() > 1) {
            title = title.substring(1, title.length());
        }
        if ((ls = this.zgrViewer.getLogicalStructure()) != null) {
            LNode node = ls.getNode(title);
            if (node != null) {
                Glyph g = node.getGlyphs()[0];
                this.changeAllBorder(Color.white);
                g.setBorderColor(Color.GREEN);
            } else {
                System.err.println("Node " + title + " Introuvable");
            }
        } else {
            System.err.println("ZGRPanelViewer.java: Pas de logical structure");
        }
    }

    public void highLigthEdge(int node1, int node2) {
        LNode nodeTarget = this.getNode(Integer.toString(node1));
        LNode nodeSource = this.getNode(Integer.toString(node2));
        if (nodeSource != null && nodeTarget != null) {
            for (LEdge edge : nodeTarget.getIncomingArcs()) {
                if (!edge.getTail().equals(nodeSource)) continue;
                for (Glyph gl : edge.getGlyphs()) {
                    gl.setColor(Color.green);
                }
            }
        }
    }

    public void unHighLigthAllEdge() {
        if (this.zgrViewer.getLogicalStructure() != null) {
            for (LEdge edge : this.zgrViewer.getLogicalStructure().getAllEdges()) {
                for (Glyph gl : edge.getGlyphs()) {
                    gl.setColor(Color.black);
                }
            }
        }
    }

    public void changeAllBorder(Color color) {
        for (LNode node : this.zgrViewer.getLogicalStructure().getAllNodes()) {
            Glyph g = node.getGlyphs()[0];
            g.setBorderColor(color);
        }
    }

    public void exit() {
        this.zgrViewer.exit();
    }

    public void addObservateur(Observateur obs) {
        this.zgrViewer.addObservateur(obs);
    }

    public void createConfigFile() {
        DOMImplementationImpl di = new DOMImplementationImpl();
        Document cfg = di.createDocument("http://zvtm.sourceforge.net/zgrviewer", "zgrv:config", null);
        Element rt = cfg.getDocumentElement();
        rt.setAttribute("xmlns:zgrv", "http://zvtm.sourceforge.net/zgrviewer");
        Element dirs = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:directories");
        rt.appendChild(dirs);
        Element aDir = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:tmpDir");
        dirs.appendChild(aDir);
        aDir = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:graphDir");
        dirs.appendChild(aDir);
        aDir = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:dot");
        aDir.appendChild(cfg.createTextNode(DotUtil.dotExecutable));
        dirs.appendChild(aDir);
        aDir = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:neato");
        aDir.appendChild(cfg.createTextNode("neato"));
        dirs.appendChild(aDir);
        aDir = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:circo");
        aDir.appendChild(cfg.createTextNode("circo"));
        dirs.appendChild(aDir);
        aDir = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:twopi");
        aDir.appendChild(cfg.createTextNode("twopi"));
        dirs.appendChild(aDir);
        aDir = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:graphvizFontDir");
        dirs.appendChild(aDir);
        Element consts = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:webBrowser");
        consts.setAttribute("autoDetect", String.valueOf(true));
        consts.setAttribute("path", "");
        consts.setAttribute("options", "");
        rt.appendChild(consts);
        consts = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:proxy");
        consts.setAttribute("enable", String.valueOf(false));
        consts.setAttribute("host", "");
        consts.setAttribute("port", "80");
        rt.appendChild(consts);
        consts = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:preferences");
        rt.appendChild(consts);
        consts.setAttribute("antialiasing", String.valueOf(true));
        consts.setAttribute("dynaspot", String.valueOf(false));
        consts.setAttribute("highlightColor", Integer.toString(-65536));
        consts.setAttribute("silent", String.valueOf(true));
        consts.setAttribute("saveWindowLayout", String.valueOf(false));
        consts.setAttribute("sdZoom", String.valueOf(false));
        consts.setAttribute("sdZoomFactor", String.valueOf(2));
        consts.setAttribute("magFactor", String.valueOf(0.5));
        consts.setAttribute("cmdL_options", "");
        Element pluginsEL = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:plugins");
        rt.appendChild(pluginsEL);
        consts = cfg.createElementNS("http://zvtm.sourceforge.net/zgrviewer", "zgrv:commandLines");
        File cfgFile = new File(System.getProperty("user.home") + "/.zgrviewer");
        if (cfgFile.exists()) {
            cfgFile.delete();
        }
        Utils.serialize((Document)cfg, (File)cfgFile);
    }
}

