/*
 * Decompiled with CFR 0.152.
 */
package DVE.fiacre;

import DVE.evaluation.StaticEvaluator;
import DVE.fiacre.DVE2FiacreNames;
import DVE.fiacre.DVEFixBooleanExpressions;
import DVE.fiacre.DVEGlobalUsageExtractor;
import DVE.model.ArrayLiteral;
import DVE.model.ArrayType;
import DVE.model.Assignment;
import DVE.model.BinaryExpression;
import DVE.model.ByteType;
import DVE.model.ChannelDeclaration;
import DVE.model.ChannelReference;
import DVE.model.ConstantDeclaration;
import DVE.model.Element;
import DVE.model.Expression;
import DVE.model.FalseLiteral;
import DVE.model.IndexedExpression;
import DVE.model.InputSynchronization;
import DVE.model.IntegerType;
import DVE.model.NamedDeclaration;
import DVE.model.NumberLiteral;
import DVE.model.OutputSynchronization;
import DVE.model.Process;
import DVE.model.State;
import DVE.model.StateReference;
import DVE.model.Synchronous;
import DVE.model.SystemProperties;
import DVE.model.TrueLiteral;
import DVE.model.TypedChannelDeclaration;
import DVE.model.UnaryExpression;
import DVE.model.VariableDeclaration;
import DVE.model.VariableReference;
import DVE.model.util.ModelSwitch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import obp.fiacre.model.ArgumentVariable;
import obp.fiacre.model.BinOp;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.ComponentDecl;
import obp.fiacre.model.ConstantDecl;
import obp.fiacre.model.ContainerDecl;
import obp.fiacre.model.Declaration;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Field;
import obp.fiacre.model.Instance;
import obp.fiacre.model.IntType;
import obp.fiacre.model.InterfacedComp;
import obp.fiacre.model.Interval;
import obp.fiacre.model.Literal;
import obp.fiacre.model.LocalPortDecl;
import obp.fiacre.model.LocalVariable;
import obp.fiacre.model.NodeDecl;
import obp.fiacre.model.NullStmt;
import obp.fiacre.model.Par;
import obp.fiacre.model.ParamPortDecl;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.PortDecl;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Profile;
import obp.fiacre.model.Program;
import obp.fiacre.model.Queue;
import obp.fiacre.model.RefArg;
import obp.fiacre.model.Seq;
import obp.fiacre.model.Statement;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.Variable;
import obp.fiacre.util.FiacreBuilder;
import org.eclipse.emf.ecore.EObject;

public class DVE2Fiacre {
    ModelSwitch<obp.fiacre.model.Element> modelSwitch = new ModelSwitch<obp.fiacre.model.Element>(){
        Map<Element, obp.fiacre.model.Element> visited = new HashMap<Element, obp.fiacre.model.Element>();
        Stack<obp.fiacre.model.Element> fcrContext = new Stack();
        FiacreBuilder fcrBuilder = new FiacreBuilder();
        TypeDecl byteType;
        DVEGlobalUsageExtractor globalsUsageExtractor;
        Stack<Boolean> rhsContextStack = new Stack();

        @Override
        public obp.fiacre.model.Element caseSystem(DVE.model.System object) {
            obp.fiacre.model.Element decl;
            obp.fiacre.model.Element o = this.visited.get(object);
            if (o != null) {
                return o;
            }
            this.doSwitch(object.getProperties());
            new DVE2FiacreNames().fixNames(object);
            this.globalsUsageExtractor = new DVEGlobalUsageExtractor();
            this.globalsUsageExtractor.extract(object);
            Program fcrP = new Program();
            this.fcrContext.push(fcrP);
            Interval intv = this.fcrBuilder.interval(this.fcrBuilder.literal(0), this.fcrBuilder.literal(255));
            this.byteType = new TypeDecl();
            this.byteType.setIs(intv);
            this.byteType.setName("byte");
            fcrP.addDeclaration(this.byteType);
            ComponentDecl compDecl = new ComponentDecl();
            compDecl.setName("sys");
            fcrP.setRoot(compDecl);
            Par par = new Par();
            compDecl.setBody(par);
            ArrayList<Process> processes = new ArrayList<Process>();
            HashMap<String, LocalPortDecl> channels2ports = new HashMap<String, LocalPortDecl>();
            HashMap<String, LocalVariable> variable2localvar = new HashMap<String, LocalVariable>();
            for (NamedDeclaration nD : object.getDeclarations()) {
                if (nD instanceof ConstantDeclaration) {
                    decl = (obp.fiacre.model.Element)this.doSwitch(nD);
                    fcrP.addDeclaration((ConstantDecl)decl);
                    continue;
                }
                if (nD instanceof VariableDeclaration) {
                    decl = (obp.fiacre.model.Element)this.doSwitch(nD);
                    compDecl.addVar((LocalVariable)decl);
                    variable2localvar.put(nD.getName(), (LocalVariable)decl);
                    continue;
                }
                if (nD instanceof Process) {
                    processes.add((Process)nD);
                    continue;
                }
                if (!(nD instanceof ChannelDeclaration)) continue;
                if (nD instanceof TypedChannelDeclaration) {
                    TypedChannelDeclaration chan = (TypedChannelDeclaration)nD;
                    int bufferSize = 0;
                    if (chan.getBufferSize() != null) {
                        bufferSize = ((NumberLiteral)StaticEvaluator.evaluate(chan.getBufferSize())).getValue().intValue();
                    }
                    if (bufferSize > 0) {
                        obp.fiacre.model.Element decl2 = (obp.fiacre.model.Element)this.doSwitch(nD);
                        compDecl.addVar((LocalVariable)decl2);
                        variable2localvar.put(nD.getName(), (LocalVariable)decl2);
                        continue;
                    }
                }
                LocalPortDecl port = (LocalPortDecl)this.doSwitch(nD);
                compDecl.addLocalPort(port);
                channels2ports.put(nD.getName(), port);
            }
            for (NamedDeclaration nD : processes) {
                decl = (ProcessDecl)this.doSwitch(nD);
                fcrP.addDeclaration((Declaration)decl);
                InterfacedComp instI = new InterfacedComp();
                Instance fcrInst = new Instance();
                fcrInst.setType((NodeDecl)decl);
                for (ParamPortDecl lpd : ((NodeDecl)decl).getPortList()) {
                    LocalPortDecl port = (LocalPortDecl)channels2ports.get(lpd.getName());
                    fcrInst.addPort(port);
                }
                for (ArgumentVariable av : ((ContainerDecl)decl).getArgList()) {
                    LocalVariable lv = (LocalVariable)variable2localvar.get(av.getName());
                    RefArg rA = new RefArg();
                    rA.setRef(lv);
                    fcrInst.addArg(rA);
                }
                instI.setComposition(fcrInst);
                par.addArg(instI);
            }
            fcrP.addDeclaration(compDecl);
            return this.fcrContext.pop();
        }

        @Override
        public Type caseByteType(ByteType object) {
            Type type = this.fcrBuilder.type(this.byteType);
            this.visited.put(object, type);
            return type;
        }

        @Override
        public obp.fiacre.model.Element caseIntegerType(IntegerType object) {
            IntType type = this.fcrBuilder.intType();
            this.visited.put(object, type);
            return type;
        }

        @Override
        public obp.fiacre.model.Element caseArrayType(ArrayType object) {
            obp.fiacre.model.Element o = this.visited.get(object);
            if (o != null) {
                return o;
            }
            Type elementType = (Type)this.doSwitch(object.getElementType());
            this.rhsContextStack.push(true);
            Exp sizeE = (Exp)this.doSwitch(object.getSize());
            this.rhsContextStack.pop();
            Type type = this.fcrBuilder.arrayType(sizeE, elementType);
            this.visited.put(object, type);
            return type;
        }

        @Override
        public ConstantDecl caseConstantDeclaration(ConstantDeclaration object) {
            obp.fiacre.model.Element o = this.visited.get(object);
            if (o != null) {
                return (ConstantDecl)o;
            }
            Type fcrType = (Type)this.doSwitch(object.getType());
            Exp initial = null;
            if (object.getInitial() != null) {
                this.rhsContextStack.push(true);
                initial = (Exp)this.doSwitch(object.getInitial());
                this.rhsContextStack.pop();
            }
            ConstantDecl cons = this.fcrBuilder.constantDecl(object.getName(), fcrType, initial);
            this.visited.put(object, cons);
            return cons;
        }

        @Override
        public LocalVariable caseVariableDeclaration(VariableDeclaration object) {
            obp.fiacre.model.Element o = this.visited.get(object);
            if (o != null) {
                return (LocalVariable)o;
            }
            Type fcrType = (Type)this.doSwitch(object.getType());
            Exp initial = null;
            if (object.getInitial() != null) {
                this.rhsContextStack.push(true);
                initial = (Exp)this.doSwitch(object.getInitial());
                this.rhsContextStack.pop();
            }
            LocalVariable var = this.fcrBuilder.localVariable(object.getName(), fcrType, initial);
            this.visited.put(object, var);
            return var;
        }

        @Override
        public obp.fiacre.model.Element caseChannelDeclaration(ChannelDeclaration object) {
            obp.fiacre.model.Element o = this.visited.get(object);
            if (o != null) {
                return o;
            }
            LocalPortDecl channel = this.fcrBuilder.localPortDecl(object.getName(), new Profile());
            this.visited.put(object, channel);
            return channel;
        }

        Type synthesizeRecord(List<DVE.model.Type> types) {
            ArrayList<Field> fields = new ArrayList<Field>();
            int idx = 0;
            for (DVE.model.Type ty : types) {
                fields.add(this.fcrBuilder.field("f" + idx, (Type)this.doSwitch(ty)));
            }
            return this.fcrBuilder.record(fields);
        }

        @Override
        public obp.fiacre.model.Element caseTypedChannelDeclaration(TypedChannelDeclaration object) {
            obp.fiacre.model.Element o = this.visited.get(object);
            if (o != null) {
                return o;
            }
            int bufferSize = 0;
            if (object.getBufferSize() != null) {
                bufferSize = ((NumberLiteral)StaticEvaluator.evaluate(object.getBufferSize())).getValue().intValue();
            }
            if (bufferSize > 0) {
                Type elementType = object.getTypes().size() > 1 ? this.synthesizeRecord((List<DVE.model.Type>)object.getTypes()) : (Type)this.doSwitch((EObject)object.getTypes().get(0));
                Queue fcrType = this.fcrBuilder.queueType(this.fcrBuilder.literal(bufferSize), elementType);
                LocalVariable var = this.fcrBuilder.localVariable(object.getName(), fcrType);
                this.visited.put(object, var);
                return var;
            }
            Profile prf = new Profile();
            for (DVE.model.Type type : object.getTypes()) {
                Type fcrType = (Type)this.doSwitch(type);
                prf.addType(fcrType);
            }
            LocalPortDecl channel = this.fcrBuilder.localPortDecl(object.getName(), prf);
            this.visited.put(object, channel);
            return channel;
        }

        @Override
        public Literal caseNumberLiteral(NumberLiteral object) {
            return this.fcrBuilder.literal(object.getValue().intValue());
        }

        @Override
        public Literal caseTrueLiteral(TrueLiteral object) {
            return this.fcrBuilder.literal(true);
        }

        @Override
        public Literal caseFalseLiteral(FalseLiteral object) {
            return this.fcrBuilder.literal(false);
        }

        @Override
        public obp.fiacre.model.Element caseArrayLiteral(ArrayLiteral object) {
            ArrayList<Exp> exps = new ArrayList<Exp>(object.getValues().size());
            for (Expression e : object.getValues()) {
                exps.add((Exp)this.doSwitch(e));
            }
            return this.fcrBuilder.literalArray(exps);
        }

        @Override
        public obp.fiacre.model.Element caseVariableReference(VariableReference object) {
            if (object.getRef() instanceof ConstantDeclaration) {
                ConstantDecl cd = (ConstantDecl)this.visited.get(object.getRef());
                return this.fcrBuilder.constantRef(cd);
            }
            Variable var = (Variable)this.visited.get(object.getRef());
            return this.fcrBuilder.varRef(var);
        }

        @Override
        public obp.fiacre.model.Element caseChannelReference(ChannelReference object) {
            return this.visited.get(object.getRef());
        }

        @Override
        public obp.fiacre.model.Element caseUnaryExpression(UnaryExpression object) {
            if (object.getOperand() instanceof StateReference) {
                DVE2Fiacre.this.reportError("Fiacre support state expressions");
                return this.fcrBuilder.literal(1);
            }
            switch (object.getOperator()) {
                case BNOT: {
                    DVE2Fiacre.this.reportError("Fiacre does not have the binary not operator");
                    return (obp.fiacre.model.Element)this.doSwitch(object.getOperand());
                }
                case MINUS: {
                    return this.fcrBuilder.minus((Exp)this.doSwitch(object.getOperand()));
                }
                case NOT: {
                    return this.fcrBuilder.not((Exp)this.doSwitch(object.getOperand()));
                }
            }
            return null;
        }

        @Override
        public obp.fiacre.model.Element caseBinaryExpression(BinaryExpression object) {
            if (object.getOperands().get(0) instanceof StateReference || object.getOperands().get(1) instanceof StateReference) {
                DVE2Fiacre.this.reportError("Fiacre support state expressions");
                return this.fcrBuilder.literal(1);
            }
            BinOp op = null;
            switch (object.getOperator()) {
                case AND: {
                    op = BinOp.BAND;
                    break;
                }
                case BAND: {
                    DVE2Fiacre.this.reportError("Fiacre does not have the binary and operator");
                    op = BinOp.BAND;
                    break;
                }
                case BOR: {
                    DVE2Fiacre.this.reportError("Fiacre does not have the binary or operator");
                    op = BinOp.BOR;
                    break;
                }
                case BXOR: {
                    DVE2Fiacre.this.reportError("Fiacre does not have the binary xor operator");
                    op = BinOp.BOR;
                    break;
                }
                case DIV: {
                    op = BinOp.BDIV;
                    break;
                }
                case EQ: {
                    op = BinOp.BEQ;
                    break;
                }
                case GEQ: {
                    op = BinOp.BGE;
                    break;
                }
                case GT: {
                    op = BinOp.BGT;
                    break;
                }
                case IMPLY: {
                    DVE2Fiacre.this.reportError("Fiacre does not have the 'imply' operator");
                    op = BinOp.BOR;
                    break;
                }
                case LEQ: {
                    op = BinOp.BLE;
                    break;
                }
                case LT: {
                    op = BinOp.BLT;
                    break;
                }
                case MINUS: {
                    op = BinOp.BMINUS;
                    break;
                }
                case MOD: {
                    op = BinOp.BMOD;
                    break;
                }
                case MULT: {
                    op = BinOp.BMUL;
                    break;
                }
                case NEQ: {
                    op = BinOp.BNE;
                    break;
                }
                case OR: {
                    op = BinOp.BOR;
                    break;
                }
                case PLUS: {
                    op = BinOp.BADD;
                    break;
                }
                case SHL: {
                    DVE2Fiacre.this.reportError("Fiacre does not have the << operator");
                    op = BinOp.BADD;
                    break;
                }
                case SHR: {
                    DVE2Fiacre.this.reportError("Fiacre does not have the >> operator");
                    op = BinOp.BADD;
                }
            }
            Exp lhs = (Exp)this.doSwitch((EObject)object.getOperands().get(0));
            Exp rhs = (Exp)this.doSwitch((EObject)object.getOperands().get(1));
            return this.fcrBuilder.expression(op, lhs, rhs);
        }

        @Override
        public obp.fiacre.model.Element caseIndexedExpression(IndexedExpression object) {
            obp.fiacre.model.Element base = (obp.fiacre.model.Element)this.doSwitch(object.getBase());
            this.rhsContextStack.push(true);
            Exp index = (Exp)this.doSwitch(object.getIndex());
            this.rhsContextStack.pop();
            if (this.rhsContextStack.peek().booleanValue()) {
                return this.fcrBuilder.indexedExp((Exp)base, index);
            }
            return this.fcrBuilder.arrayPattern((Pattern)base, index);
        }

        List<ParamPortDecl> buildFiacrePorts(Set<ChannelDeclaration> channels, boolean input, boolean output) {
            ArrayList<ParamPortDecl> fcrPorts = new ArrayList<ParamPortDecl>();
            for (ChannelDeclaration cD : channels) {
                ParamPortDecl port;
                if (cD instanceof TypedChannelDeclaration) {
                    PortDecl pd = (PortDecl)this.doSwitch(cD);
                    port = this.fcrBuilder.portDecl(cD.getName(), pd.getChannel(), input, output);
                } else {
                    port = this.fcrBuilder.portDecl(cD.getName(), (Type)null, input, output);
                }
                this.visited.put(cD, port);
                fcrPorts.add(port);
            }
            return fcrPorts;
        }

        void generateFcrPortsInProcess(Process object, ProcessDecl proc) {
            Set<ChannelDeclaration> inputs = this.globalsUsageExtractor.inputChannelMap.get(object);
            Set<ChannelDeclaration> outputs = this.globalsUsageExtractor.outputChannelMap.get(object);
            HashSet<ChannelDeclaration> io = new HashSet<ChannelDeclaration>(inputs);
            io.retainAll(outputs);
            HashSet<ChannelDeclaration> inOnly = new HashSet<ChannelDeclaration>(inputs);
            inOnly.removeAll(io);
            HashSet<ChannelDeclaration> outOnly = new HashSet<ChannelDeclaration>(outputs);
            outOnly.removeAll(io);
            proc.addAllPort(this.buildFiacrePorts(io, true, true));
            proc.addAllPort(this.buildFiacrePorts(inOnly, true, false));
            proc.addAllPort(this.buildFiacrePorts(outOnly, false, true));
        }

        List<ArgumentVariable> buildFiacreQueues(Set<ChannelDeclaration> vars, boolean input, boolean output) {
            ArrayList<ArgumentVariable> fcrParams = new ArrayList<ArgumentVariable>();
            for (ChannelDeclaration vD : vars) {
                Variable queue = (Variable)this.doSwitch(vD);
                ArgumentVariable param = this.fcrBuilder.argumentVariable(vD.getName(), queue.getType(), input, output, true);
                this.visited.put(vD, param);
                fcrParams.add(param);
            }
            return fcrParams;
        }

        void generateFcrQueuesInProcess(Process object, ProcessDecl proc) {
            Set<ChannelDeclaration> inputs = this.globalsUsageExtractor.inputQueueMap.get(object);
            Set<ChannelDeclaration> outputs = this.globalsUsageExtractor.outputQueueMap.get(object);
            HashSet<ChannelDeclaration> io = new HashSet<ChannelDeclaration>(inputs);
            io.retainAll(outputs);
            HashSet<ChannelDeclaration> inOnly = new HashSet<ChannelDeclaration>(inputs);
            inOnly.removeAll(io);
            HashSet<ChannelDeclaration> outOnly = new HashSet<ChannelDeclaration>(outputs);
            outOnly.removeAll(io);
            proc.addAllArg(this.buildFiacreQueues(io, true, true));
            proc.addAllArg(this.buildFiacreQueues(inOnly, true, false));
            proc.addAllArg(this.buildFiacreQueues(outOnly, false, true));
        }

        List<ArgumentVariable> buildFiacreParams(Set<VariableDeclaration> vars, boolean input, boolean output) {
            ArrayList<ArgumentVariable> fcrParams = new ArrayList<ArgumentVariable>();
            for (VariableDeclaration vD : vars) {
                Type type = (Type)this.doSwitch(vD.getType());
                ArgumentVariable param = this.fcrBuilder.argumentVariable(vD.getName(), type, input, output, true);
                this.visited.put(vD, param);
                fcrParams.add(param);
            }
            return fcrParams;
        }

        void generateFcrParamsInProcess(Process object, ProcessDecl proc) {
            Set<VariableDeclaration> write = this.globalsUsageExtractor.modifiedVariableMap.get(object);
            Set<VariableDeclaration> read = this.globalsUsageExtractor.usedVariableMap.get(object);
            HashSet<VariableDeclaration> rw = new HashSet<VariableDeclaration>(read);
            rw.retainAll(write);
            HashSet<VariableDeclaration> rOnly = new HashSet<VariableDeclaration>(read);
            rOnly.removeAll(rw);
            HashSet<VariableDeclaration> wOnly = new HashSet<VariableDeclaration>(write);
            wOnly.removeAll(rw);
            proc.addAllArg(this.buildFiacreParams(rw, true, true));
            proc.addAllArg(this.buildFiacreParams(rOnly, true, false));
            proc.addAllArg(this.buildFiacreParams(wOnly, false, true));
        }

        @Override
        public ProcessDecl caseProcess(Process object) {
            obp.fiacre.model.Element o = this.visited.get(object);
            if (o != null) {
                return (ProcessDecl)o;
            }
            ProcessDecl proc = new ProcessDecl();
            proc.setName(object.getName());
            this.generateFcrPortsInProcess(object, proc);
            this.generateFcrQueuesInProcess(object, proc);
            this.generateFcrParamsInProcess(object, proc);
            for (NamedDeclaration vD : object.getDeclarations()) {
                LocalVariable lV = (LocalVariable)this.doSwitch(vD);
                proc.addVar(lV);
            }
            for (State state : object.getStates()) {
                proc.addState((obp.fiacre.model.State)this.doSwitch(state));
            }
            To initAct = new To();
            initAct.setDest((obp.fiacre.model.State)this.doSwitch(object.getInitial()));
            proc.setInitAction(initAct);
            for (DVE.model.Transition tran : object.getTransitions()) {
                Transition fcrTran = (Transition)this.doSwitch(tran);
                proc.addTransition(fcrTran);
            }
            if (!object.getCommited().isEmpty()) {
                System.err.println("Fiacre does not support commited states");
            }
            if (!object.getAccepting().isEmpty()) {
                System.err.println("Fiacre does not support accepting states");
            }
            this.visited.put(object, proc);
            return proc;
        }

        @Override
        public Transition caseTransition(DVE.model.Transition object) {
            obp.fiacre.model.Element o = this.visited.get(object);
            if (o != null) {
                return (Transition)o;
            }
            Transition fcrTran = new Transition();
            obp.fiacre.model.State fromState = (obp.fiacre.model.State)this.doSwitch(object.getFrom());
            fcrTran.setFrom(fromState);
            Seq seq = new Seq();
            fcrTran.setAction(seq);
            if (object.getGuard() != null) {
                this.rhsContextStack.push(true);
                Exp condition = (Exp)this.doSwitch(object.getGuard());
                this.rhsContextStack.pop();
                CaseStmt caseS = this.fcrBuilder.caseStmt(condition, this.fcrBuilder.rule(this.fcrBuilder.literal(true), new NullStmt()));
                seq.addStatement(caseS);
            }
            if (object.getSync() != null) {
                Statement syncS = (Statement)this.doSwitch(object.getSync());
                seq.addStatement(syncS);
            }
            if (object.getEffect() != null) {
                for (Assignment assign : object.getEffect()) {
                    Statement eff = (Statement)this.doSwitch(assign);
                    seq.addStatement(eff);
                }
            }
            obp.fiacre.model.State toState = (obp.fiacre.model.State)this.doSwitch(object.getTo());
            To to = new To();
            to.setDest(toState);
            seq.addStatement(to);
            this.visited.put(object, fcrTran);
            return fcrTran;
        }

        @Override
        public obp.fiacre.model.Element caseAssignment(Assignment object) {
            obp.fiacre.model.Element o = this.visited.get(object);
            if (o != null) {
                return o;
            }
            this.rhsContextStack.push(false);
            Pattern lhs = (Pattern)this.doSwitch(object.getLhs());
            this.rhsContextStack.pop();
            this.rhsContextStack.push(true);
            Exp rhs = (Exp)this.doSwitch(object.getRhs());
            this.rhsContextStack.pop();
            Statement assign = this.fcrBuilder.assign(lhs, rhs);
            this.visited.put(object, assign);
            return assign;
        }

        @Override
        public obp.fiacre.model.Element caseInputSynchronization(InputSynchronization object) {
            obp.fiacre.model.Element channel = (obp.fiacre.model.Element)this.doSwitch(object.getChannel());
            if (channel instanceof PortDecl) {
                PortDecl port = (PortDecl)channel;
                if (object.getValue() != null) {
                    this.rhsContextStack.push(false);
                    Pattern pattern = (Pattern)this.doSwitch(object.getValue());
                    this.rhsContextStack.pop();
                    return this.fcrBuilder.oneReception(port, pattern);
                }
                return this.fcrBuilder.oneReception(port, new Pattern[0]);
            }
            Variable var = (Variable)channel;
            Pattern pattern = null;
            if (object.getValue() != null) {
                this.rhsContextStack.push(false);
                pattern = (Pattern)this.doSwitch(object.getValue());
                this.rhsContextStack.pop();
            }
            return this.fcrBuilder.caseStmt(this.fcrBuilder.notEmpty(this.fcrBuilder.varRef(var)), this.fcrBuilder.rule(this.fcrBuilder.literal(true), this.fcrBuilder.seq(this.fcrBuilder.assign(pattern, this.fcrBuilder.first(this.fcrBuilder.varRef(var))), this.fcrBuilder.assign(this.fcrBuilder.varRef(var), this.fcrBuilder.dequeue(this.fcrBuilder.varRef(var))))));
        }

        @Override
        public obp.fiacre.model.Element caseOutputSynchronization(OutputSynchronization object) {
            obp.fiacre.model.Element channel = (obp.fiacre.model.Element)this.doSwitch(object.getChannel());
            if (channel instanceof PortDecl) {
                PortDecl port = (PortDecl)channel;
                if (object.getValue() != null) {
                    this.rhsContextStack.push(true);
                    Exp exp = (Exp)this.doSwitch(object.getValue());
                    this.rhsContextStack.pop();
                    return this.fcrBuilder.emission(port, exp);
                }
                return this.fcrBuilder.emission(port, new Exp[0]);
            }
            Variable var = (Variable)channel;
            Exp expr = null;
            if (object.getValue() != null) {
                this.rhsContextStack.push(true);
                expr = (Exp)this.doSwitch(object.getValue());
                this.rhsContextStack.pop();
            }
            return this.fcrBuilder.caseStmt(this.fcrBuilder.notFull(this.fcrBuilder.varRef(var)), this.fcrBuilder.rule(this.fcrBuilder.literal(true), this.fcrBuilder.seq(this.fcrBuilder.assign(this.fcrBuilder.varRef(var), this.fcrBuilder.enqueue(this.fcrBuilder.varRef(var), expr)))));
        }

        @Override
        public obp.fiacre.model.Element caseState(State object) {
            obp.fiacre.model.Element o = this.visited.get(object);
            if (o != null) {
                return o;
            }
            obp.fiacre.model.State state = new obp.fiacre.model.State();
            state.setName(object.getName());
            this.visited.put(object, state);
            return state;
        }

        @Override
        public obp.fiacre.model.Element caseStateReference(StateReference object) {
            obp.fiacre.model.Element o = this.visited.get(object);
            if (o != null) {
                return o;
            }
            obp.fiacre.model.State state = (obp.fiacre.model.State)this.doSwitch(object.getRef());
            this.visited.put(object, state);
            return state;
        }

        @Override
        public obp.fiacre.model.Element caseSystemProperties(SystemProperties object) {
            this.doSwitch(object.getSystemType());
            if (object.getProperty() != null) {
                System.err.println("Property process '" + object.getProperty().getRefName() + "' cannot be converted");
            }
            return null;
        }

        @Override
        public obp.fiacre.model.Element caseSynchronous(Synchronous object) {
            System.err.println("Cannot handle DVE synchronous composition (does not match Fiacre composition operator)");
            return null;
        }
    };
    Set<String> errorMessages = new LinkedHashSet<String>();

    void reportError(String error) {
        if (!this.errorMessages.contains(error)) {
            this.errorMessages.add(error);
        }
    }

    public Program transform(DVE.model.System sys) {
        DVEFixBooleanExpressions booleanFixer = new DVEFixBooleanExpressions();
        booleanFixer.apply(sys);
        Program program = (Program)this.modelSwitch.doSwitch(sys);
        for (String errorM : this.errorMessages) {
            System.err.println(errorM);
        }
        if (!this.errorMessages.isEmpty()) {
            return null;
        }
        return program;
    }
}

