/*
 * Decompiled with CFR 0.152.
 */
package plug.cli;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.kohsuke.args4j.Option;
import plug.cli.PlugRemoteCLI;
import plug.cli.VerificationMain;
import plug.core.ILanguagePlugin;
import plug.core.ITransitionRelation;
import plug.core.RuntimeDescription;
import plug.language.remote.RemoteLoader;
import plug.language.remote.RemotePlugin;
import plug.language.remote.runtime.RemoteRuntime;

class VerificationRemoteMain
extends VerificationMain {
    @Option(name="-s", aliases={"--language-server"}, usage="The remote language server:port")
    String languageServer;

    VerificationRemoteMain() {
    }

    public void getHelp() {
        PlugRemoteCLI.printHelp(System.out);
    }

    public ILanguagePlugin<ITransitionRelation> getLanguagePlugin() {
        if (this.languageServer == null) {
            PlugRemoteCLI.printHelp(System.out);
            return null;
        }
        final String address = this.languageServer.substring(0, this.languageServer.lastIndexOf(58));
        final int port = Integer.parseInt(this.languageServer.substring(this.languageServer.lastIndexOf(58) + 1));
        System.out.println(address + " : " + port);
        RemotePlugin languagePlugin = new RemotePlugin(new RemoteLoader(){

            public RemoteRuntime getRuntime(URI modelURI, Map<String, Object> options) throws IOException {
                RemoteRuntime runtime = new RemoteRuntime(address, port);
                runtime.initializeRuntime();
                return runtime;
            }
        });
        return languagePlugin;
    }

    public RuntimeDescription getRuntimeDescription() {
        ILanguagePlugin<ITransitionRelation> plugin = this.getLanguagePlugin();
        return new RuntimeDescription(plugin, () -> {
            try {
                return plugin.getLoader().getRuntime((URI)null, null);
            }
            catch (Exception e) {
                System.err.println("Could not load the languagePlugin for " + this.languageServer);
                e.printStackTrace();
                return null;
            }
        });
    }
}

