/*
 * Decompiled with CFR 0.152.
 */
package plug.core.execution;

import announce4j.Announcer;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import plug.core.IConfiguration;
import plug.core.ILanguagePlugin;
import plug.core.IRuntimeView;
import plug.core.ITransitionRelation;
import plug.core.execution.ControllerProviderFunction;
import plug.core.execution.IExecutionController;
import plug.events.ExecutionEndedEvent;
import plug.events.PropertyEvent;
import plug.simulation.trace_storage.TraceStore;
import plug.statespace.IGraphAccess;
import plug.statespace.SimpleStateSpaceManager;
import plug.statespace.graph.FullTransitionStorage;
import plug.statespace.graph.ParentTransitionStorage;
import plug.utils.graph.algorithms.DijkstraShortestPath;
import plug.verifiers.deadlock.FinalStateDetected;

public class Execution {
    public Status status = Status.CREATED;
    protected final String name;
    ILanguagePlugin languagePlugin;
    Path modelPath;
    ControllerProviderFunction description;
    ITransitionRelation transitionRelation;
    IRuntimeView runtimeView;
    IExecutionController controller;
    TransitionStorageType transitionStorageType;
    Set<Object> acceptAllSet;
    public TraceStore traceStore = new TraceStore();
    protected Thread thread;
    Throwable exception;
    PropertyEvent violation;
    protected long loadingTime = 0L;
    boolean firstAcceptAllOK = false;
    protected long startTime = 0L;
    protected long endTime = 0L;

    public Execution(String name, Path modelPath, ILanguagePlugin languagePlugin, ControllerProviderFunction description) {
        this(name, modelPath, languagePlugin, description, TransitionStorageType.PARENT, Collections.emptySet());
    }

    public Execution(String name, Path modelPath, ILanguagePlugin languagePlugin, ControllerProviderFunction description, Set<Object> acceptAllStates) {
        this(name, modelPath, languagePlugin, description, TransitionStorageType.PARENT, acceptAllStates);
    }

    public Execution(String name, Path modelPath, ILanguagePlugin languagePlugin, ControllerProviderFunction description, TransitionStorageType transitionStorageType, Set<Object> acceptAllStates) {
        this.name = name;
        this.modelPath = modelPath;
        this.languagePlugin = languagePlugin;
        this.description = description;
        this.transitionStorageType = transitionStorageType;
        this.acceptAllSet = acceptAllStates;
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
        if (this.transitionRelation != null) {
            this.transitionRelation.close();
        }
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized Status status() {
        return this.status;
    }

    public synchronized PropertyEvent getViolation() {
        return this.violation;
    }

    public synchronized Throwable getException() {
        return this.exception;
    }

    public ITransitionRelation getTransitionRelation() {
        if (this.status != Status.INITIALIZED) {
            this.initialize();
        }
        return this.transitionRelation;
    }

    public synchronized IRuntimeView getRuntimeView() {
        if (this.status != Status.INITIALIZED) {
            this.initialize();
        }
        return this.runtimeView;
    }

    public synchronized void initialize() {
        if (this.status != Status.CREATED && this.status != Status.FAILED) {
            return;
        }
        try {
            long startLoading = System.currentTimeMillis();
            this.transitionRelation = this.languagePlugin.getLoader().getRuntime(this.modelPath != null ? this.modelPath.toAbsolutePath().toString() : null, null);
            this.runtimeView = this.languagePlugin.getRuntimeView(this.transitionRelation);
            SimpleStateSpaceManager stateSpaceManager = new SimpleStateSpaceManager();
            switch (this.transitionStorageType) {
                case FULL: {
                    stateSpaceManager.fullTransitionStorage();
                    break;
                }
                case PARENT: {
                    stateSpaceManager.parentTransitionStorage();
                    break;
                }
                case COUNTING: {
                    stateSpaceManager.countingTransitionStorage();
                    break;
                }
                case NONE: {
                    break;
                }
            }
            this.controller = this.description.createController(this.transitionRelation, stateSpaceManager);
            this.loadingTime = System.currentTimeMillis() - startLoading;
        }
        catch (Throwable e) {
            this.exception = e;
            this.status = Status.FAILED;
            return;
        }
        this.status = this.transitionRelation == null || this.controller == null ? Status.FAILED : Status.INITIALIZED;
    }

    public synchronized Thread run() {
        if (this.status != Status.INITIALIZED) {
            return null;
        }
        try {
            this.thread = new Thread(this::runnerThread);
            this.status = Status.RUNNING;
            this.thread.start();
        }
        catch (Throwable e) {
            this.exception = e;
            if (this.transitionRelation != null) {
                this.transitionRelation.close();
            }
            this.status = Status.FAILED;
            return null;
        }
        return this.thread;
    }

    public synchronized void pause() {
        if (this.status != Status.RUNNING) {
            return;
        }
        this.controller.getMonitor().pause();
        this.status = Status.PAUSED;
    }

    public synchronized void resume() {
        if (this.status != Status.PAUSED) {
            return;
        }
        this.controller.getMonitor().resume();
        this.status = Status.RUNNING;
    }

    public synchronized void stop() {
        if (this.status != Status.PAUSED && this.status != Status.RUNNING) {
            return;
        }
        this.controller.getMonitor().hasToFinish();
        this.status = Status.STOPPED;
    }

    public synchronized void reset() {
        if (this.status != Status.STOPPED && this.status != Status.FAILED && this.status != Status.FINISHED) {
            return;
        }
        if (this.transitionRelation != null) {
            this.transitionRelation.close();
        }
        this.controller = null;
        this.traceStore = new TraceStore();
        this.endTime = 0L;
        this.startTime = 0L;
        this.exception = null;
        this.violation = null;
        this.thread = null;
        this.status = Status.CREATED;
    }

    public synchronized void hardReset() {
        try {
            this.controller.getMonitor().hasToFinish();
            if (this.transitionRelation != null) {
                this.transitionRelation.close();
            }
            this.controller = null;
            this.traceStore = new TraceStore();
            this.endTime = 0L;
            this.startTime = 0L;
            this.exception = null;
            this.violation = null;
            this.thread = null;
        }
        catch (Throwable e) {
            this.exception = e;
            this.status = Status.FAILED;
            return;
        }
        this.status = Status.CREATED;
    }

    boolean notInAcceptAll(Object c) {
        if (c.getClass().getCanonicalName().equals("plug.language.buchikripke.runtime.KripkeBuchiConfiguration")) {
            Field buchiField = FieldUtils.getField(c.getClass(), (String)"buchiState");
            try {
                Object buchiConfiguration = buchiField.get(c);
                Field stateField = FieldUtils.getField(buchiConfiguration.getClass(), (String)"buchiState");
                Object stateObject = stateField.get(buchiConfiguration);
                if (this.acceptAllSet.contains(stateObject)) {
                    if (this.firstAcceptAllOK) {
                        return false;
                    }
                    this.firstAcceptAllOK = true;
                    return true;
                }
            }
            catch (IllegalAccessException e) {
                return true;
            }
        }
        return true;
    }

    void runnerThread() {
        Announcer announcer = this.controller.getAnnouncer();
        announcer.when(ExecutionEndedEvent.class, (a, event) -> {
            this.endTime = System.currentTimeMillis();
            this.status = Status.FINISHED;
        });
        announcer.when(PropertyEvent.class, (a, event) -> {
            if (!event.isVerified()) {
                this.controller.getMonitor().hasToFinish();
                this.violation = event;
                this.endTime = System.currentTimeMillis();
                this.status = Status.FINISHED;
                this.firstAcceptAllOK = false;
                this.traceStore.addSteps(Collections.emptyList(), event.getCounterExample().stream().filter(this::notInAcceptAll).collect(Collectors.toList()), this.transitionRelation::actionFromSourceToTarget);
                this.traceStore.hasCounterExample = true;
            }
        });
        announcer.when(FinalStateDetected.class, (a, event) -> {
            this.controller.getMonitor().hasToFinish();
            this.endTime = System.currentTimeMillis();
            SimpleStateSpaceManager stateSpaceManager = (SimpleStateSpaceManager)this.controller.getStateSpaceManager();
            ArrayList<IConfiguration> counterExample = null;
            if (stateSpaceManager.transitionStorage instanceof FullTransitionStorage) {
                counterExample = new DijkstraShortestPath().getShortestPath(stateSpaceManager.getGraphView(), stateSpaceManager.initialConfigurations(), event.getFinalState());
            } else if (stateSpaceManager.transitionStorage instanceof ParentTransitionStorage) {
                counterExample = new ArrayList();
                counterExample.add((IConfiguration)event.getFinalState());
                IGraphAccess graph = stateSpaceManager.getGraphView();
                Object current = event.getFinalState();
                while (current != null && !stateSpaceManager.initialConfigurations().contains(current)) {
                    IConfiguration parent = (IConfiguration)graph.getParent(current);
                    if (parent != null) {
                        counterExample.add(parent);
                    }
                    current = parent;
                }
                Collections.reverse(counterExample);
            }
            PropertyEvent deadlock = new PropertyEvent(this.controller, false, "deadlock", counterExample);
            this.controller.getAnnouncer().announce(deadlock);
        });
        try {
            this.startTime = System.currentTimeMillis();
            this.controller.execute();
        }
        catch (Throwable e) {
            this.exception = e;
            this.status = Status.FAILED;
            return;
        }
    }

    public synchronized long getElapsedTime() {
        if (this.startTime == 0L) {
            return 0L;
        }
        if (this.endTime == 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.endTime - this.startTime;
    }

    public synchronized long getLoadingTime() {
        return this.loadingTime;
    }

    public synchronized int configurationCount() {
        if (this.controller == null) {
            return 0;
        }
        return this.controller.getStateSpaceManager().size();
    }

    public synchronized int transitionCount() {
        if (this.controller == null) {
            return 0;
        }
        return this.controller.getStateSpaceManager().transitionCount();
    }

    public synchronized String getDetails() {
        int size;
        if (this.status == Status.CREATED) {
            return "initializing";
        }
        if (this.status == Status.INITIALIZED) {
            return "no results";
        }
        StringBuilder result = new StringBuilder();
        if (this.status == Status.FAILED || this.status == Status.STOPPED) {
            result.append("Incomplete ");
        }
        if (this.status == Status.FINISHED) {
            result.append("Finished ");
        }
        if ((size = this.configurationCount()) > 0) {
            result.append(size + " configurations ");
            int transitionCount = this.transitionCount();
            if (transitionCount > 0) {
                result.append(transitionCount + " transitions ");
            }
            result.append("in " + this.getElapsedTime() + " ms");
        }
        return result.toString();
    }

    public synchronized VerificationStatus verificationStatus() {
        if (this.status != Status.FINISHED) {
            return VerificationStatus.UNKNOWN;
        }
        if (this.violation == null) {
            return VerificationStatus.SATISFIED;
        }
        return VerificationStatus.VIOLATED;
    }

    public synchronized CompletenessStatus resultStatus() {
        if (this.status == Status.FINISHED) {
            return CompletenessStatus.COMPLETE;
        }
        return CompletenessStatus.INCOMPLETE;
    }

    public synchronized IGraphAccess getGraphView() {
        if (this.controller == null || this.controller.getStateSpaceManager() == null) {
            return null;
        }
        return this.controller.getStateSpaceManager().getGraphView();
    }

    public static enum CompletenessStatus {
        COMPLETE,
        INCOMPLETE;

    }

    public static enum VerificationStatus {
        SATISFIED,
        VIOLATED,
        UNKNOWN;

    }

    public static enum Status {
        CREATED,
        INITIALIZED,
        RUNNING,
        PAUSED,
        STOPPED,
        FINISHED,
        FAILED;

    }

    public static enum TransitionStorageType {
        NONE,
        COUNTING,
        PARENT,
        FULL;

    }
}

