/*
 * Decompiled with CFR 0.152.
 */
package plug.core.execution;

import java.util.concurrent.Semaphore;

public interface IExecutionMonitor {
    public void pause();

    public void resume();

    public void hasToFinish();

    public static class Simple
    implements IExecutionMonitor {
        protected final Semaphore semaphore = new Semaphore(1);
        protected boolean atEnd = false;

        @Override
        public void pause() {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void resume() {
            this.semaphore.release();
        }

        @Override
        public void hasToFinish() {
            this.atEnd = true;
            this.resume();
        }

        public boolean atEnd() {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.semaphore.release();
            return this.atEnd;
        }
    }
}

