/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.marshaling;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class Unmarshaller {
    public static byte[] readData(int size, InputStream stream) throws IOException {
        int r;
        byte[] data = new byte[size];
        int read = 0;
        do {
            if ((r = stream.read(data, 0, size)) != -1) continue;
            throw new RuntimeException("End of stream reached " + stream.toString());
        } while ((read += r) < size);
        return data;
    }

    public static int readInt(InputStream stream) throws IOException {
        return ByteBuffer.wrap(Unmarshaller.readData(4, stream)).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static boolean readBoolean(InputStream stream) throws IOException {
        return ByteBuffer.wrap(Unmarshaller.readData(1, stream)).order(ByteOrder.LITTLE_ENDIAN).get() > 0;
    }

    public static short readShort(InputStream stream) throws IOException {
        return ByteBuffer.wrap(Unmarshaller.readData(2, stream)).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    public static byte readByte(InputStream stream) throws IOException {
        return ByteBuffer.wrap(Unmarshaller.readData(1, stream)).order(ByteOrder.LITTLE_ENDIAN).get();
    }

    public static char readChar(InputStream stream) throws IOException {
        return ByteBuffer.wrap(Unmarshaller.readData(2, stream)).order(ByteOrder.LITTLE_ENDIAN).getChar();
    }

    public static long readLong(InputStream stream) throws IOException {
        return ByteBuffer.wrap(Unmarshaller.readData(8, stream)).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    public static float readFloat(InputStream stream) throws IOException {
        return ByteBuffer.wrap(Unmarshaller.readData(4, stream)).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public static double readDouble(InputStream stream) throws IOException {
        return ByteBuffer.wrap(Unmarshaller.readData(4, stream)).order(ByteOrder.LITTLE_ENDIAN).getDouble();
    }

    public static String readString(InputStream stream) throws IOException {
        int size = Unmarshaller.readInt(stream);
        return size < 0 ? null : new String(Unmarshaller.readData(size, stream), StandardCharsets.UTF_8);
    }

    public static String[] readStringArray(InputStream stream) throws IOException {
        int count = Unmarshaller.readInt(stream);
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            String atom;
            result[i] = atom = Unmarshaller.readString(stream);
        }
        return result;
    }

    public static byte[] readBuffer(InputStream stream) throws IOException {
        int size = Unmarshaller.readInt(stream);
        return Unmarshaller.readData(size, stream);
    }
}

