/*
 * Decompiled with CFR 0.152.
 */
package obp.tina;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import obp.aut.Aut;
import obp.aut.Edge;
import obp.fiacre.util.FiacrePrinter;
import obp.fiacre.util.FiacreUtil;
import obp.fiacre.util.FracBranch;
import obp.states.Element;
import obp.states.PID;
import obp.states.Process;
import obp.states.State;
import obp.states.States;
import obp.states.Time;
import obp.states.ValueSimple;
import obp.states.Variable;
import obp.tina.SeltResult;
import obp.tina.TinaController;
import obp.tool.OutputAnalyzer;

public class SeltResultAnalyzer
implements OutputAnalyzer<List<SeltResult>> {
    private static final Pattern infoPattern = Pattern.compile("^Selt version.*$");
    private static final Pattern timePattern = Pattern.compile("^([0-9]*\\.[0-9]*)s$");
    private static final Pattern verifiedPattern = Pattern.compile("^(TRUE|FALSE)$");
    private static final Pattern statePattern = Pattern.compile("^(\\* \\[accepting\\])? *state ([0-9]+):(.*)$");
    private static final Pattern transitionPattern = Pattern.compile("^ *-([^ ]*)( \\.\\.\\. .*)?->$");
    private final TinaController controller;
    private InternalState internalState = InternalState.waitTime;
    private List<SeltResult> results;
    private double time;
    private boolean verified;
    private List<Integer> statesNumber;
    private List<String> statesDescription;
    private List<String> transitions;
    private double totalTime;
    private final boolean useDescription;

    public SeltResultAnalyzer(TinaController controller, boolean useDescription) {
        this.controller = controller;
        this.useDescription = useDescription;
    }

    @Override
    public boolean hideOutput() {
        return false;
    }

    @Override
    public void analyze(String line) {
        Matcher infoMatcher = infoPattern.matcher(line);
        if (infoMatcher.matches()) {
            this.results = new ArrayList<SeltResult>();
            this.internalState = InternalState.waitTime;
            return;
        }
        switch (this.internalState) {
            case waitVerified: {
                Matcher verifiedMatcher = verifiedPattern.matcher(line);
                if (verifiedMatcher.matches()) {
                    this.verified = verifiedMatcher.group(1).equals("TRUE");
                    if (this.verified) {
                        this.saveCurrentResult();
                        this.internalState = InternalState.waitTime;
                        break;
                    }
                    this.statesNumber = new ArrayList<Integer>();
                    this.statesDescription = new ArrayList<String>();
                    this.transitions = new ArrayList<String>();
                    this.internalState = InternalState.waitState;
                    break;
                }
                this.internalState = InternalState.waitTime;
                break;
            }
            case waitState: {
                Matcher stateMatcher = statePattern.matcher(line);
                if (!stateMatcher.matches()) break;
                this.statesNumber.add(Integer.parseInt(stateMatcher.group(2)));
                this.statesDescription.add(stateMatcher.group(3));
                this.internalState = InternalState.waitTransition;
                break;
            }
            case waitTransition: {
                Matcher transitionMatcher = transitionPattern.matcher(line);
                if (transitionMatcher.matches()) {
                    this.transitions.add(transitionMatcher.group(1));
                    this.internalState = InternalState.waitState;
                }
            }
            case waitTime: {
                Matcher timeMatcher = timePattern.matcher(line);
                if (!timeMatcher.matches()) break;
                if (this.internalState == InternalState.waitTransition) {
                    this.saveCurrentResult();
                }
                this.time = Double.parseDouble(timeMatcher.group(1));
                this.internalState = InternalState.waitVerified;
            }
        }
    }

    private void saveCurrentResult() {
        Aut aut = null;
        States states = null;
        if (!this.verified) {
            FiacrePrinter printer = new FiacrePrinter();
            printer.setSeparator(" ");
            aut = new Aut();
            aut.setName("CounterExample");
            for (int i = 0; i < this.transitions.size(); ++i) {
                Edge edge = new Edge();
                edge.setId(i);
                edge.setSource(this.statesNumber.get(i));
                edge.setTarget(this.statesNumber.get(i + 1));
                String[] ids = FiacreUtil.decomposeFracTransition(this.transitions.get(i));
                if (ids != null) {
                    StringBuilder newLabel = new StringBuilder();
                    for (String id : ids) {
                        if ("deadlock".equals(id)) {
                            newLabel.append(id);
                            continue;
                        }
                        FracBranch transitionBranch = this.controller.getTransitionBranch(id);
                        if (transitionBranch == null) continue;
                        if (this.useDescription) {
                            newLabel.append(transitionBranch.getDescription());
                            continue;
                        }
                        if (newLabel.length() > 0) {
                            newLabel.append("\\n");
                        }
                        newLabel.append(printer.print(transitionBranch.getAction()));
                    }
                    if (newLabel.length() > 0) {
                        edge.setLabel(newLabel.toString());
                    } else {
                        edge.setLabel("*internal*");
                    }
                } else {
                    edge.setLabel(this.transitions.get(i));
                }
                aut.addEdge(edge);
            }
            State[] stateArray = new State[this.statesDescription.size()];
            for (int i = 0; i < this.statesDescription.size(); ++i) {
                stateArray[i] = this.createState(this.statesNumber.get(i), this.statesDescription.get(i));
            }
            states = new States(stateArray);
        }
        SeltResult result = new SeltResult(this.results.size() + 1, this.verified, this.time, aut, states);
        this.results.add(result);
        this.time = -1.0;
        this.verified = false;
        this.statesNumber = null;
        this.statesDescription = null;
        this.transitions = null;
    }

    private State createState(int number, String description) {
        String[] fragments;
        HashMap<String, PID> pids = new HashMap<String, PID>();
        HashMap<String, String> states = new HashMap<String, String>();
        HashMap variables = new HashMap();
        for (String fragment : fragments = description.trim().split(" ")) {
            String[] parts = FiacreUtil.decomposeFracDescription(fragment);
            if (parts == null) continue;
            String id = parts[0] + parts[1];
            if ("s".equals(parts[2])) {
                pids.put(id, new PID(parts[0], Integer.parseInt(parts[1])));
                String state = parts[3];
                state = state.replaceAll("__", "_");
                states.put(id, state);
                continue;
            }
            if (!"v".equals(parts[2])) continue;
            ArrayList<Variable> list = (ArrayList<Variable>)variables.get(id);
            if (list == null) {
                list = new ArrayList<Variable>();
                variables.put(id, list);
            }
            String[] valueFragments = parts[3].split("\\*");
            ValueSimple value = null;
            value = valueFragments.length == 1 ? new ValueSimple("0") : new ValueSimple(valueFragments[1]);
            list.add(new Variable(valueFragments[0], value));
        }
        Element[] processes = new Process[pids.size()];
        int i = 0;
        for (String id : pids.keySet()) {
            List variableList = (List)variables.get(id);
            Variable[] variableArray = null;
            if (variableList != null) {
                variableArray = variableList.toArray(new Variable[variableList.size()]);
            }
            processes[i] = new Process((PID)pids.get(id), (String)states.get(id), variableArray, null, null);
            ++i;
        }
        State state = new State(number, processes, new Time(new String[]{"run"}));
        return state;
    }

    public double getTotalTime() {
        return this.totalTime;
    }

    @Override
    public boolean ended(int value, double duration) {
        this.totalTime = this.time;
        return value == 0;
    }

    @Override
    public List<SeltResult> getResult() {
        return this.results;
    }

    private static enum InternalState {
        waitTime,
        waitVerified,
        waitState,
        waitTransition;

    }
}

