/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.simulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import obp.cc.ConcreteContext;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.ProgramLoader;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.simulation.ITransitionSelectionPolicy;
import obp.explorer.runtime.simulation.Simulator;

public class GlobalNondeterministicSimulator
extends Simulator
implements Cloneable {
    protected boolean isForcedSynchronization = false;

    public GlobalNondeterministicSimulator(ProgramLoader programLoader) {
        this(programLoader, null);
    }

    public GlobalNondeterministicSimulator(ProgramLoader programLoader, ConcreteContext context) {
        this(programLoader, context, (ITransitionSelectionPolicy)null);
    }

    public GlobalNondeterministicSimulator(ProgramLoader programLoader, ConcreteContext context, ITransitionSelectionPolicy policy) {
        super(programLoader, context, policy);
    }

    public List<Transition> getFireable(Configuration configuration) {
        ArrayList<Transition> fireable = new ArrayList<Transition>();
        for (int i = 0; i < this.behaviorCount; i = (int)((short)(i + 1))) {
            ProcessBehavior behavior = (ProcessBehavior)this.behaviors[i];
            for (Transition transition : behavior.getTransitions(configuration)) {
                if (!transition.guard(configuration, this)) continue;
                fireable.add(transition);
            }
        }
        return fireable;
    }

    protected List<Transition> simulate(Configuration configuration, List<Transition> fireable) {
        List<Transition> toFire = this.mSelectionPolicy.selectFromFireable(fireable);
        this.fireTransitions(configuration, fireable, toFire);
        return toFire;
    }

    protected boolean fireTransitions(Configuration configuration, List<Transition> fireable, Transition toFire) {
        return this.fireTransitions(configuration, fireable, Arrays.asList(toFire));
    }

    protected boolean fireTransitions(Configuration configuration, List<Transition> fireable, List<Transition> toFire) {
        if (toFire == null) {
            return true;
        }
        boolean isNotBlocked = true;
        HashSet<Integer> channels = null;
        if (this.isForcedSynchronization) {
            channels = new HashSet<Integer>();
        }
        assert (toFire.size() == 1);
        for (Transition transition : toFire) {
            short channelId = transition.getSynchronisationChannelId();
            if (channelId == -1) {
                return isNotBlocked &= this.transitionExecutor.executeAlone(configuration, transition);
            }
            this.synchronizationExecuter.addTransition(channelId, transition);
            if (!this.isForcedSynchronization) continue;
            channels.add(Integer.valueOf(channelId));
        }
        if (this.isForcedSynchronization && channels.size() > 0) {
            HashSet<Transition> fired = new HashSet<Transition>(toFire);
            for (Transition transition : fireable) {
                short channelId;
                if (fired.contains(transition) || !channels.contains(channelId = transition.getSynchronisationChannelId())) continue;
                this.synchronizationExecuter.addTransition(channelId, transition);
                toFire.add(transition);
            }
        }
        return isNotBlocked &= this.synchronizationExecuter.computeSynchronizedTransition(configuration, this.transitionExecutor);
    }

    @Override
    protected void simulate(Configuration configuration) {
        this.simulate(configuration, this.getFireable(configuration));
    }

    public boolean isForcedSynchronization() {
        return this.isForcedSynchronization;
    }

    public void setForcedSynchronization(boolean isForcedSynchronization) {
        this.isForcedSynchronization = isForcedSynchronization;
    }
}

