/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.obs;

import java.util.Arrays;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.evaluator.Tester;
import obp.explorer.runtime.obs.ObsConfiguration;
import obp.explorer.runtime.obs.ObsTransition;

public class ObsTransitionDefault
extends ObsTransition {
    public static final short None = 0;
    public static final short Input = 1;
    public static final short Output = 2;
    private final short clockIndex;
    private final short[] when;
    private final short sourceState;
    private final Tester guardTester;
    private final short[] eventIds;
    private final int reset;
    private final short targetState;

    public ObsTransitionDefault(short behaviorId, short clockIndex, short[] when, short sourceState, Tester guardTester, short[] eventIds, short targetState, int reset) {
        super(behaviorId);
        this.clockIndex = clockIndex;
        this.when = when;
        this.sourceState = sourceState;
        this.guardTester = guardTester;
        this.eventIds = eventIds;
        this.reset = reset;
        this.targetState = targetState;
    }

    @Override
    public void when(short[] dbm) {
        if (this.when != null) {
            DBM.andGuard(dbm, this.when[0], this.when[1], this.when[2]);
        }
    }

    @Override
    public boolean guard(Configuration source, Configuration target) {
        ObsConfiguration meTarget = (ObsConfiguration)target.behaviorConfigurations[this.behaviorId];
        if (meTarget.state != this.sourceState) {
            return false;
        }
        return this.guardTester.test(source);
    }

    @Override
    public short[] getEventIds() {
        return this.eventIds;
    }

    @Override
    public void action(Configuration configuration) {
        ObsConfiguration me = (ObsConfiguration)configuration.behaviorConfigurations[this.behaviorId];
        me.state = this.targetState;
        if (this.reset >= 0) {
            DBM.set(configuration.dbm, this.clockIndex, this.reset);
        } else if (this.reset == -1) {
            DBM.disable(configuration.dbm, this.clockIndex);
        }
    }

    public String toString() {
        StringBuilder test = new StringBuilder();
        test.append(this.sourceState);
        test.append(" -- ");
        test.append(Arrays.toString(this.eventIds));
        test.append(" -> ");
        test.append(this.targetState);
        return test.toString();
    }
}

