/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.ProcessBehavior;
import obp.explorer.runtime.core.AbstractExplorer;
import obp.explorer.runtime.core.AbstractFoldingExplorer;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.core.ExploringTransitionExecutor;
import obp.explorer.runtime.core.FixedOrderTransitionExecutor;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.evaluator.Evaluator;
import obp.explorer.runtime.evaluator.Tester;
import obp.explorer.runtime.fiacre.PredicateToEvaluator;
import obp.explorer.runtime.obs.AtomicAction;
import obp.predicate.Predicate;

public class BasicFoldingExplorer
extends AbstractFoldingExplorer<Configuration> {
    private final Set<Configuration> targets;
    private final List<AtomicAction> atomicActionList;
    private final AbstractExplorer explorer;
    private final SilentFixedOrderTransitionExecutor silentFOExecutor;
    private final SilentExploringTransitionExecutor silentEExecutor;
    private Tester foldingTester;

    public BasicFoldingExplorer(AbstractExplorer explorer) {
        this.explorer = explorer;
        if (explorer.getContext() == null || explorer.getContext().getFoldingPredicate() == null) {
            throw new IllegalStateException("no folding predicate was found");
        }
        Predicate foldingPredicate = explorer.getContext().getFoldingPredicate();
        Evaluator foldingPredicateEvaluator = PredicateToEvaluator.toEvaluator(foldingPredicate, (ExplorationContext)explorer, explorer.symbols);
        this.foldingTester = new Tester(foldingPredicateEvaluator);
        this.silentEExecutor = new SilentExploringTransitionExecutor();
        this.silentEExecutor.setExplorer(explorer);
        this.silentEExecutor.init();
        this.silentFOExecutor = new SilentFixedOrderTransitionExecutor();
        this.silentFOExecutor.setExplorer(explorer);
        this.silentFOExecutor.init();
        this.atomicActionList = new ArrayList<AtomicAction>(5);
        this.targets = new HashSet<Configuration>();
    }

    @Override
    public boolean checkFoldingPredicate(Configuration configuration) {
        return this.foldingTester.test(configuration);
    }

    @Override
    public Collection<Configuration> getTargets(Configuration source) {
        this.targets.clear();
        for (int i = 0; i < this.explorer.behaviorCount; i = (int)((short)(i + 1))) {
            ProcessBehavior behavior = (ProcessBehavior)this.explorer.behaviors[i];
            for (Transition transition : behavior.getTransitions(source)) {
                if (!transition.guard(source, this.explorer)) continue;
                short channelId = transition.getSynchronisationChannelId();
                if (channelId == -1) {
                    Configuration target = new Configuration(source);
                    this.atomicActionList.clear();
                    if (!this.silentEExecutor.computeTargetAndFillActionList(source, target, transition, this.atomicActionList) || this.explorer.observe(source, this.atomicActionList, target)) continue;
                    if (target.dbm != null) {
                        this.explorer.applyDelayAndInvariant(source, target);
                    }
                    this.targets.add(target);
                    continue;
                }
                this.explorer.synchronizationExecuter.addTransition(channelId, transition);
            }
        }
        this.explorer.synchronizationExecuter.computeSynchronizedTransition(source, this.silentFOExecutor);
        this.targets.addAll(this.silentFOExecutor.getTargets());
        return this.targets;
    }

    private class SilentFixedOrderTransitionExecutor
    extends FixedOrderTransitionExecutor {
        private Collection<Configuration> targets = new HashSet<Configuration>();

        private SilentFixedOrderTransitionExecutor() {
        }

        @Override
        public boolean execute(Configuration configuration, Channel channel) {
            int i;
            this.targets.clear();
            Configuration newConfiguration = new Configuration(configuration);
            short[] newDbm = newConfiguration.dbm;
            if (newDbm != null) {
                if (channel != null && channel.clockId != -1) {
                    DBM.andGuard(newDbm, 0, channel.clockId, channel.minBoundInternal);
                }
                for (i = 0; i < this.transitionCount; ++i) {
                    this.transitionArray[i].when(newConfiguration, this.explorer);
                }
            }
            if (newDbm == null || !DBM.isEmpty(newDbm)) {
                boolean stop;
                Arrays.fill(this.modifiedBehaviors, false);
                for (i = 0; i < this.transitionCount; ++i) {
                    Transition transition = this.transitionArray[i];
                    this.modifiedBehaviors[transition.behaviorId] = true;
                    transition.updateModifiedBehaviors(newConfiguration, this.explorer, this.modifiedBehaviors);
                }
                for (i = 0; i < this.modifiedBehaviors.length; i = (short)(i + 1)) {
                    if (!this.modifiedBehaviors[i]) continue;
                    newConfiguration.replaceBehaviorConfigurationByCopy((short)i);
                }
                boolean isBlocked = false;
                ArrayList<AtomicAction> atomicActionList = new ArrayList<AtomicAction>(5);
                for (int i2 = 0; i2 < this.transitionCount; ++i2) {
                    if (this.transitionArray[i2].action(this.explorer, atomicActionList, newConfiguration)) continue;
                    isBlocked = true;
                    break;
                }
                if (!isBlocked && !(stop = this.explorer.observe(configuration, atomicActionList, newConfiguration))) {
                    if (newDbm != null) {
                        this.explorer.applyDelayAndInvariant(configuration, newConfiguration);
                    }
                    this.targets.add(newConfiguration);
                    this.reset();
                    return true;
                }
            }
            this.reset();
            return false;
        }

        public Collection<Configuration> getTargets() {
            return this.targets;
        }
    }

    private class SilentExploringTransitionExecutor
    extends ExploringTransitionExecutor {
        private Collection<Configuration> targets = new HashSet<Configuration>();

        private SilentExploringTransitionExecutor() {
        }

        @Override
        public boolean execute(Configuration source, Channel channel) {
            this.targets.clear();
            Configuration checkedSource = this.checkTimeBounds(source, channel);
            if (checkedSource == null) {
                this.reset();
                return false;
            }
            this.initExploration(checkedSource);
            while (this.hasNext()) {
                this.explorationStep();
            }
            boolean result = false;
            for (ExploringTransitionExecutor.IntermediateState state : this.known) {
                if (!state.isFinal()) continue;
                ArrayList<AtomicAction> atomicActionList = new ArrayList<AtomicAction>(state.actionSet);
                boolean stop = this.explorer.observe(source, atomicActionList, state.conf);
                if (state.conf.dbm != null) {
                    this.explorer.applyDelayAndInvariant(source, state.conf);
                }
                if (!stop) {
                    this.targets.add(state.conf);
                }
                result = true;
            }
            this.reset();
            return result;
        }

        public Collection<Configuration> getTargets() {
            return this.targets;
        }
    }
}

