/*
 * Decompiled with CFR 0.152.
 */
package spinja.search;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import spinja.model.Model;
import spinja.model.Transition;
import spinja.search.Simulation;
import spinja.search.TransitionCalculator;

public class TrailSimulation<M extends Model<T>, T extends Transition>
extends Simulation<M, T> {
    private final BufferedReader reader;
    private final String filename;

    public TrailSimulation(M m, TransitionCalculator<M, T> transitionCalculator) throws FileNotFoundException {
        super(m, transitionCalculator);
        this.filename = ((Model)m).getName() + ".trail";
        this.reader = new BufferedReader(new FileReader(this.filename));
    }

    @Override
    public T nextTransition() {
        Transition transition = null;
        try {
            String string = this.reader.readLine();
            if (string == null) {
                System.out.println("End of trail-file");
                return null;
            }
            int n = Integer.parseInt(string);
            while ((transition = this.nextTransition.next(this.model, transition)) != null) {
                if (transition.getId() != n) continue;
                return (T)transition;
            }
            throw new NumberFormatException("Transition with ID " + n + " not found");
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error while reading " + this.filename + ": " + numberFormatException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("Error while reading " + this.filename + ": " + iOException.getMessage());
        }
        return null;
    }
}

