/*
 * Decompiled with CFR 0.152.
 */
package spinja.search;

import java.util.ArrayList;
import java.util.Collection;
import spinja.model.Model;
import spinja.model.Transition;
import spinja.search.Algoritm;
import spinja.search.BreadthFirstSearch;
import spinja.search.Queue;
import spinja.search.TransitionCalculator;
import spinja.store.StateStore;
import spinja.util.ByteArrayStorage;

public class ConcurrentBFSearch<M extends Model<T>, T extends Transition>
extends Algoritm {
    private final Queue queue;
    private final StateStore store;
    private final M model;
    private final boolean checkForDeadlocks;
    private final boolean errorExceedDepth;
    private final int maxErrors;
    private final int nrThreads;
    private final Collection<BFSearch> searchThreads;
    private final TransitionCalculator<M, T> nextTransition;
    private final ByteArrayStorage storage = new ByteArrayStorage();

    public ConcurrentBFSearch(int n, M m, StateStore stateStore, boolean bl, int n2, boolean bl2, TransitionCalculator<M, T> transitionCalculator) {
        this.queue = new Queue();
        this.model = m;
        this.store = stateStore;
        this.checkForDeadlocks = bl;
        this.maxErrors = n2;
        this.errorExceedDepth = bl2;
        this.nrThreads = n;
        this.searchThreads = new ArrayList<BFSearch>();
        this.nextTransition = transitionCalculator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.storage.init(this.model.getSize());
        this.model.encode(this.storage);
        byte[] byArray = this.storage.getBuffer();
        Queue queue = this.queue;
        queue.getClass();
        this.queue.add(new Queue.State(queue, null, byArray, -1));
        this.store.addState(byArray);
        this.startNewThread();
        try {
            ConcurrentBFSearch concurrentBFSearch = this;
            synchronized (concurrentBFSearch) {
                while (!this.searchThreads.isEmpty()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public void freeMemory() {
    }

    @Override
    public long getBytes() {
        return this.store.getBytes();
    }

    @Override
    public long getNrStates() {
        return this.store.getStored();
    }

    @Override
    public void printSummary() {
        System.out.printf("%8d states, stored\n", this.store.getStored());
        this.store.printSummary();
    }

    private void startNewThread() {
        BFSearch bFSearch = new BFSearch(this, this.queue, (Model)((Model)this.model).clone(), this.store, this.checkForDeadlocks, this.maxErrors, this.errorExceedDepth, this.nextTransition);
        this.searchThreads.add(bFSearch);
        System.out.println("Started new Thread, now running " + this.searchThreads.size());
        new Thread(bFSearch).run();
    }

    private static class BFSearch
    extends BreadthFirstSearch<M, T>
    implements Runnable {
        private static final long serialVersionUID = 8891381374394851600L;
        final /* synthetic */ ConcurrentBFSearch this$0;

        public BFSearch(Queue queue, M m, StateStore stateStore, boolean bl, int n, boolean bl2, TransitionCalculator<M, T> transitionCalculator) {
            this.this$0 = var1_1;
            super(queue, m, stateStore, bl, n, bl2, transitionCalculator);
        }

        @Override
        protected boolean restoreState() {
            if (this.fromState == null) {
                this.fromState = this.this$0.queue.remove();
                if (this.fromState == null) {
                    return false;
                }
                ByteArrayStorage byteArrayStorage = new ByteArrayStorage();
                byteArrayStorage.setBuffer(this.fromState.state);
                this.model.decode(byteArrayStorage);
                this.last = null;
            } else if (this.last != null) {
                this.last.undo();
            }
            if (this.this$0.searchThreads.size() < this.this$0.nrThreads) {
                this.this$0.startNewThread();
            }
            return true;
        }

        @Override
        protected boolean print(String string) {
            return super.print("Thread " + Thread.currentThread().getName() + ":" + string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.execute();
            this.this$0.searchThreads.remove(this);
            ConcurrentBFSearch concurrentBFSearch = this.this$0;
            synchronized (concurrentBFSearch) {
                this.this$0.notifyAll();
            }
            System.out.println("Ended one thread: now running: " + this.this$0.searchThreads.size());
        }
    }
}

