/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.actions.Action;
import spinja.promela.compiler.actions.ActionContainer;
import spinja.promela.compiler.actions.ElseAction;
import spinja.promela.compiler.expression.Identifier;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.Variable;
import spinja.util.StringWriter;

public class Sequence
extends Action
implements ActionContainer,
Iterable<Action> {
    private final List<Action> actions = new ArrayList<Action>();

    public Sequence() {
        super(null);
    }

    @Override
    public Token getToken() {
        if (this.actions.isEmpty()) {
            return null;
        }
        return this.actions.get(0).getToken();
    }

    public boolean startsWithElse() {
        return !this.actions.isEmpty() && this.actions.get(0) instanceof ElseAction;
    }

    @Override
    public void addAction(Action action) {
        this.actions.add(action);
    }

    @Override
    public Iterator<Action> iterator() {
        return Collections.unmodifiableList(this.actions).iterator();
    }

    public int getNrActions() {
        return this.actions.size();
    }

    @Override
    public boolean isLocal(Proctype proctype) {
        for (Action action : this.actions) {
            if (action.isLocal(proctype)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getEnabledExpression() throws ParseException {
        if (this.actions.isEmpty()) {
            return null;
        }
        return this.actions.get(0).getEnabledExpression();
    }

    @Override
    public void printTakeStatement(StringWriter stringWriter) throws ParseException {
        this.printTakeStatement(stringWriter, !this.isComplex());
    }

    public void printTakeStatement(StringWriter stringWriter, boolean bl) throws ParseException {
        boolean bl2 = true;
        for (Action action : this) {
            Object object;
            if (bl) {
                object = action.getChangedVariables().iterator();
                while (object.hasNext()) {
                    Identifier identifier = object.next();
                    stringWriter.appendLine("_backup_", identifier.getVariable().getName(), " = ", identifier.getIntExpression(), ";");
                }
            }
            action.printTakeStatement(stringWriter);
            if (!bl2 && (object = action.getEnabledExpression()) != null) {
                stringWriter.appendLine("if(!", object, ") throw new ValidationException(\"Non-enabled action during a d_step\");");
            }
            bl2 = true;
        }
    }

    @Override
    public void printUndoStatement(StringWriter stringWriter) throws ParseException {
        this.printUndoStatement(stringWriter, !this.isComplex());
    }

    public void printUndoStatement(StringWriter stringWriter, boolean bl) throws ParseException {
        for (int i = this.actions.size() - 1; i >= 0; --i) {
            Action action = this.actions.get(i);
            action.printUndoStatement(stringWriter);
            if (!bl) continue;
            for (Identifier identifier : action.getChangedVariables()) {
                stringWriter.appendLine(identifier.getIntExpression(), " = _backup_", identifier.getVariable().getName(), ";");
            }
        }
    }

    @Override
    public boolean isComplex() {
        return this.getBackupVariables(new HashMap<Variable, Identifier>());
    }

    @Override
    public Collection<Identifier> getChangedVariables() {
        HashMap<Variable, Identifier> hashMap = new HashMap<Variable, Identifier>();
        this.getBackupVariables(hashMap);
        return hashMap.values();
    }

    public boolean getBackupVariables(Map<Variable, Identifier> map) {
        return this.getBackupVariables(map, false);
    }

    private boolean getBackupVariables(Map<Variable, Identifier> map, boolean bl) {
        map.clear();
        for (Action action : this) {
            if (!bl && action.isComplex()) {
                map.clear();
                return this.getBackupVariables(map, true);
            }
            for (Identifier identifier : action.getChangedVariables()) {
                Variable variable = identifier.getVariable();
                if (!map.containsKey(variable)) {
                    map.put(variable, identifier);
                    continue;
                }
                if (bl) continue;
                map.clear();
                return this.getBackupVariables(map, true);
            }
        }
        return bl;
    }

    public Action getAction(int n) {
        return this.actions.get(n);
    }

    @Override
    public String toString() {
        if (this.actions.size() == 1) {
            return this.actions.get(0).toString();
        }
        return "d_step";
    }
}

