/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.model;

import java.lang.reflect.Method;
import org.xid.basics.model.ChangeMark;
import org.xid.basics.model.ModelObject;

public class RemoveObjectChangeMark
extends ChangeMark {
    protected final ModelObject receiver;
    protected final String attributeName;
    protected final int index;
    protected final Object objectIndex;
    protected final Object removedObject;

    public RemoveObjectChangeMark(long timestamp, ModelObject receiver, String attributeName, int index, Object removedObject) {
        super(timestamp);
        this.receiver = receiver;
        this.attributeName = attributeName;
        this.index = index;
        this.objectIndex = null;
        this.removedObject = removedObject;
    }

    public RemoveObjectChangeMark(long timestamp, ModelObject receiver, String attributeName, Object index, Object removedObject) {
        super(timestamp);
        this.receiver = receiver;
        this.attributeName = attributeName;
        this.index = -1;
        this.objectIndex = index;
        this.removedObject = removedObject;
    }

    protected String getAdderName() {
        String firstUppercaseAttribute = this.attributeName.substring(0, 1).toUpperCase() + this.attributeName.substring(1);
        return "add" + firstUppercaseAttribute;
    }

    protected String getPutterName() {
        String firstUppercaseAttribute = this.attributeName.substring(0, 1).toUpperCase() + this.attributeName.substring(1);
        return "put" + firstUppercaseAttribute;
    }

    @Override
    public void undo() {
        try {
            if (this.objectIndex == null) {
                this.undoIntegerIndex();
            } else {
                this.undoObjectIndex();
            }
        }
        catch (Exception e) {
            System.err.println("RemoveObjectChangeMark.undo():" + e.getClass().getName());
        }
    }

    private void undoIntegerIndex() throws Exception {
        Method method = this.getMethod(this.receiver.getClass(), this.getAdderName(), Integer.TYPE, this.removedObject.getClass());
        if (method != null) {
            method.invoke((Object)this.receiver, this.index, this.removedObject);
        } else {
            System.err.println("RemoveObjectChangeMark.undoIntegerIndex():No method to undo");
        }
    }

    private void undoObjectIndex() throws Exception {
        Method method = this.getMethod(this.receiver.getClass(), this.getPutterName(), this.objectIndex.getClass(), this.removedObject.getClass());
        if (method != null) {
            method.invoke((Object)this.receiver, this.objectIndex, this.removedObject);
        } else {
            System.err.println("RemoveObjectChangeMark.undoObjectIndex():No method to undo");
        }
    }

    @Override
    public String toString() {
        return "Re|" + this.attributeName;
    }
}

