/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.grammar.xml.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.petitparser.grammar.xml.ast.XmlAttribute;
import org.petitparser.grammar.xml.ast.XmlName;
import org.petitparser.grammar.xml.ast.XmlNode;
import org.petitparser.grammar.xml.ast.XmlParent;

public class XmlElement
extends XmlParent {
    private final XmlName name;
    private final List<XmlAttribute> attributes;

    public XmlElement(XmlName name, Collection<XmlAttribute> attributes, Collection<XmlNode> children) {
        super(children);
        this.name = name;
        this.attributes = new ArrayList<XmlAttribute>(attributes);
        for (XmlAttribute attribute : attributes) {
            attribute.setParent(this);
        }
    }

    public XmlName getName() {
        return this.name;
    }

    @Override
    public List<XmlAttribute> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String key) {
        XmlAttribute attribute = this.getAttributeNode(key);
        return attribute != null ? attribute.getValue() : null;
    }

    public XmlAttribute getAttributeNode(String key) {
        for (XmlAttribute attribute : this.attributes) {
            if (!attribute.getName().getLocal().equals(key)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public void writeTo(StringBuffer buffer) {
        buffer.append('<');
        this.getName().writeTo(buffer);
        for (XmlAttribute attribute : this.getAttributes()) {
            buffer.append(' ');
            attribute.writeTo(buffer);
        }
        if (this.getChildren().isEmpty()) {
            buffer.append(" />");
        } else {
            buffer.append('>');
            super.writeTo(buffer);
            buffer.append("</");
            this.getName().writeTo(buffer);
            buffer.append('>');
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        XmlElement other = (XmlElement)obj;
        return this.name.equals(other.name) && this.attributes.equals(other.attributes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.attributes.size());
    }
}

