/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.ArgumentMap;
import org.cte.ABCD.model.declarations.Asynchronous;
import org.cte.ABCD.model.declarations.ChannelDecl;
import org.cte.ABCD.model.declarations.ChannelTypeDecl;
import org.cte.ABCD.model.declarations.ConstantDecl;
import org.cte.ABCD.model.declarations.DeclarationWithConstants;
import org.cte.ABCD.model.declarations.DeclarationWithParameters;
import org.cte.ABCD.model.declarations.DeclarationWithPorts;
import org.cte.ABCD.model.declarations.DeclarationWithVariables;
import org.cte.ABCD.model.declarations.ElementWithArgumentMap;
import org.cte.ABCD.model.declarations.EventPool;
import org.cte.ABCD.model.declarations.Field;
import org.cte.ABCD.model.declarations.FunctionDecl;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.PortMap;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;
import org.cte.ABCD.model.declarations.State;
import org.cte.ABCD.model.declarations.SynchronizationPolicy;
import org.cte.ABCD.model.declarations.Synchronous;
import org.cte.ABCD.model.declarations.TypeDecl;
import org.cte.ABCD.model.declarations.ValueHolder;
import org.cte.ABCD.model.declarations.VariableDecl;
import org.cte.ABCD.model.expressions.Any;
import org.cte.ABCD.model.expressions.ArrayLit;
import org.cte.ABCD.model.expressions.BinaryExp;
import org.cte.ABCD.model.expressions.FalseLit;
import org.cte.ABCD.model.expressions.FieldLiteral;
import org.cte.ABCD.model.expressions.FunctionCall;
import org.cte.ABCD.model.expressions.IndexedExp;
import org.cte.ABCD.model.expressions.IntegerLit;
import org.cte.ABCD.model.expressions.QueueLit;
import org.cte.ABCD.model.expressions.RecordLit;
import org.cte.ABCD.model.expressions.Reference;
import org.cte.ABCD.model.expressions.SelectedExp;
import org.cte.ABCD.model.expressions.TrueLit;
import org.cte.ABCD.model.expressions.UnaryExp;
import org.cte.ABCD.model.expressions.UnionLiteral;
import org.cte.ABCD.model.kernel.Declaration;
import org.cte.ABCD.model.kernel.Element;
import org.cte.ABCD.model.kernel.Expression;
import org.cte.ABCD.model.kernel.Statement;
import org.cte.ABCD.model.kernel.Type;
import org.cte.ABCD.model.statements.AssignStmt;
import org.cte.ABCD.model.statements.Block;
import org.cte.ABCD.model.statements.CaseItem;
import org.cte.ABCD.model.statements.CaseStmt;
import org.cte.ABCD.model.statements.DeferredEvent;
import org.cte.ABCD.model.statements.ForeachStmt;
import org.cte.ABCD.model.statements.GuardStmt;
import org.cte.ABCD.model.statements.IfStmt;
import org.cte.ABCD.model.statements.InputStmt;
import org.cte.ABCD.model.statements.LoopStmt;
import org.cte.ABCD.model.statements.NullStmt;
import org.cte.ABCD.model.statements.OutputStmt;
import org.cte.ABCD.model.statements.ReceiveStmt;
import org.cte.ABCD.model.statements.ReturnStmt;
import org.cte.ABCD.model.statements.SelectStmt;
import org.cte.ABCD.model.statements.SendStmt;
import org.cte.ABCD.model.statements.SpecialTypeStmt;
import org.cte.ABCD.model.statements.ToStmt;
import org.cte.ABCD.model.statements.Transition;
import org.cte.ABCD.model.statements.WaitStmt;
import org.cte.ABCD.model.statements.WhileStmt;
import org.cte.ABCD.model.types.Array;
import org.cte.ABCD.model.types.BoolType;
import org.cte.ABCD.model.types.FieldBasedType;
import org.cte.ABCD.model.types.IntType;
import org.cte.ABCD.model.types.Interval;
import org.cte.ABCD.model.types.MutexType;
import org.cte.ABCD.model.types.NatType;
import org.cte.ABCD.model.types.NoneType;
import org.cte.ABCD.model.types.Queue;
import org.cte.ABCD.model.types.Record;
import org.cte.ABCD.model.types.SemaphoreType;
import org.cte.ABCD.model.types.TimerType;
import org.cte.ABCD.model.types.Union;
import org.xid.basics.model.AbstractCloner;

public class ABCDReplacer
extends AbstractCloner
implements ABCDVisitor {
    private final Set<Element> replaced = new HashSet<Element>();

    public ABCDReplacer() {
        this(null);
    }

    public ABCDReplacer(Map<Element, Element> replacementMap) {
        if (replacementMap != null) {
            for (Map.Entry<Element, Element> entry : replacementMap.entrySet()) {
                this.addReplacement(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addReplacement(Element original, Element replacement) {
        this.registerClone(original, replacement);
    }

    public void addRemove(Element original) {
        this.registerClone(original, null);
    }

    protected boolean hasContainmentReplacement(Element original) {
        return this.hasClone(original) && !this.replaced.contains(original);
    }

    public boolean hasReplacement(Element original) {
        return this.hasClone(original);
    }

    protected Element getContainmentReplacement(Element original) {
        this.replaced.add(original);
        return this.getReplacement(original);
    }

    public Element getReplacement(Element original) {
        return (Element)this.getClone(original);
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitNatType(NatType toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitIntType(IntType toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitNoneType(NoneType toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitTimerType(TimerType toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitSemaphoreType(SemaphoreType toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitMutexType(MutexType toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitInterval(Interval toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getMini() != null) {
                toVisit.getMini().accept(this);
                toVisit.setMini((Expression)this.popObject(Expression.class));
            }
            if (toVisit.getMaxi() != null) {
                toVisit.getMaxi().accept(this);
                toVisit.setMaxi((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitUnion(Union toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            for (int i = 0; i < toVisit.getFieldsCount(); ++i) {
                toVisit.getFields(i).accept(this);
                Field child = (Field)this.popObject(Field.class);
                if (child != null) {
                    toVisit.setFields(i, child);
                    continue;
                }
                toVisit.removeFields(i);
                --i;
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitRecord(Record toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            for (int i = 0; i < toVisit.getFieldsCount(); ++i) {
                toVisit.getFields(i).accept(this);
                Field child = (Field)this.popObject(Field.class);
                if (child != null) {
                    toVisit.setFields(i, child);
                    continue;
                }
                toVisit.removeFields(i);
                --i;
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitArray(Array toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getType() != null && this.hasReplacement(toVisit.getType())) {
                Type child = (Type)this.getClone(toVisit.getType());
                toVisit.setType(child);
            }
            if (toVisit.getSize() != null) {
                toVisit.getSize().accept(this);
                toVisit.setSize((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitQueue(Queue toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getType() != null && this.hasReplacement(toVisit.getType())) {
                Type child = (Type)this.getClone(toVisit.getType());
                toVisit.setType(child);
            }
            if (toVisit.getSize() != null) {
                toVisit.getSize().accept(this);
                toVisit.setSize((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitTypeDecl(TypeDecl toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getType() != null && this.hasReplacement(toVisit.getType())) {
                Type child = (Type)this.getClone(toVisit.getType());
                toVisit.setType(child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitField(Field toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            Type child;
            if (toVisit.getType() != null && this.hasReplacement(toVisit.getType())) {
                child = (Type)this.getClone(toVisit.getType());
                toVisit.setType(child);
            }
            if (toVisit.getParent() != null && this.hasReplacement(toVisit.getParent())) {
                child = (FieldBasedType)this.getClone(toVisit.getParent());
                toVisit.setParent((FieldBasedType)child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitSynchronous(Synchronous toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitAsynchronous(Asynchronous toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getSize() != null) {
                toVisit.getSize().accept(this);
                toVisit.setSize((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitEventPool(EventPool toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getSize() != null) {
                toVisit.getSize().accept(this);
                toVisit.setSize((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitChannelTypeDecl(ChannelTypeDecl toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getType() != null && this.hasReplacement(toVisit.getType())) {
                Type child = (Type)this.getClone(toVisit.getType());
                toVisit.setType(child);
            }
            if (toVisit.getSynchronizationPolicy() != null) {
                toVisit.getSynchronizationPolicy().accept(this);
                toVisit.setSynchronizationPolicy((SynchronizationPolicy)this.popObject(SynchronizationPolicy.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitConstantDecl(ConstantDecl toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            Element child;
            if (toVisit.getType() != null && this.hasReplacement(toVisit.getType())) {
                child = (Type)this.getClone(toVisit.getType());
                toVisit.setType((Type)child);
            }
            if (toVisit.getValue() != null) {
                toVisit.getValue().accept(this);
                toVisit.setValue((Expression)this.popObject(Expression.class));
            }
            if (toVisit.getContainer() != null && this.hasReplacement(toVisit.getContainer())) {
                child = (DeclarationWithConstants)this.getClone(toVisit.getContainer());
                toVisit.setContainer((DeclarationWithConstants)child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitVariableDecl(VariableDecl toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            Element child;
            if (toVisit.getType() != null && this.hasReplacement(toVisit.getType())) {
                child = (Type)this.getClone(toVisit.getType());
                toVisit.setType((Type)child);
            }
            if (toVisit.getValue() != null) {
                toVisit.getValue().accept(this);
                toVisit.setValue((Expression)this.popObject(Expression.class));
            }
            if (toVisit.getContainer() != null && this.hasReplacement(toVisit.getContainer())) {
                child = (DeclarationWithVariables)this.getClone(toVisit.getContainer());
                toVisit.setContainer((DeclarationWithVariables)child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitParameterDecl(ParameterDecl toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            Element child;
            if (toVisit.getType() != null && this.hasReplacement(toVisit.getType())) {
                child = (Type)this.getClone(toVisit.getType());
                toVisit.setType((Type)child);
            }
            if (toVisit.getValue() != null) {
                toVisit.getValue().accept(this);
                toVisit.setValue((Expression)this.popObject(Expression.class));
            }
            if (toVisit.getContainer() != null && this.hasReplacement(toVisit.getContainer())) {
                child = (DeclarationWithParameters)this.getClone(toVisit.getContainer());
                toVisit.setContainer((DeclarationWithParameters)child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitChannelDecl(ChannelDecl toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getType() != null && this.hasReplacement(toVisit.getType())) {
                Type child = (Type)this.getClone(toVisit.getType());
                toVisit.setType(child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitPort(Port toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            Element child;
            if (toVisit.getType() != null && this.hasReplacement(toVisit.getType())) {
                child = (Type)this.getClone(toVisit.getType());
                toVisit.setType((Type)child);
            }
            if (toVisit.getContainer() != null && this.hasReplacement(toVisit.getContainer())) {
                child = (DeclarationWithPorts)this.getClone(toVisit.getContainer());
                toVisit.setContainer((DeclarationWithPorts)child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitProcessDecl(ProcessDecl toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            Element child;
            int i;
            for (i = 0; i < toVisit.getPortsCount(); ++i) {
                toVisit.getPorts(i).accept(this);
                child = (Port)this.popObject(Port.class);
                if (child != null) {
                    toVisit.setPorts(i, (Port)child);
                    continue;
                }
                toVisit.removePorts(i);
                --i;
            }
            for (i = 0; i < toVisit.getParametersCount(); ++i) {
                toVisit.getParameters(i).accept(this);
                child = (ParameterDecl)this.popObject(ParameterDecl.class);
                if (child != null) {
                    toVisit.setParameters(i, (ParameterDecl)child);
                    continue;
                }
                toVisit.removeParameters(i);
                --i;
            }
            for (i = 0; i < toVisit.getVariablesCount(); ++i) {
                toVisit.getVariables(i).accept(this);
                child = (VariableDecl)this.popObject(VariableDecl.class);
                if (child != null) {
                    toVisit.setVariables(i, (VariableDecl)child);
                    continue;
                }
                toVisit.removeVariables(i);
                --i;
            }
            for (i = 0; i < toVisit.getTransitionsCount(); ++i) {
                toVisit.getTransitions(i).accept(this);
                child = (Transition)this.popObject(Transition.class);
                if (child != null) {
                    toVisit.setTransitions(i, (Transition)child);
                    continue;
                }
                toVisit.removeTransitions(i);
                --i;
            }
            for (i = 0; i < toVisit.getStatesCount(); ++i) {
                toVisit.getStates(i).accept(this);
                child = (State)this.popObject(State.class);
                if (child != null) {
                    toVisit.setStates(i, (State)child);
                    continue;
                }
                toVisit.removeStates(i);
                --i;
            }
            if (toVisit.getInitialization() != null) {
                toVisit.getInitialization().accept(this);
                toVisit.setInitialization((Block)this.popObject(Block.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitFunctionDecl(FunctionDecl toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            ValueHolder child;
            int i;
            if (toVisit.getType() != null && this.hasReplacement(toVisit.getType())) {
                Type child2 = (Type)this.getClone(toVisit.getType());
                toVisit.setType(child2);
            }
            for (i = 0; i < toVisit.getParametersCount(); ++i) {
                toVisit.getParameters(i).accept(this);
                child = (ParameterDecl)this.popObject(ParameterDecl.class);
                if (child != null) {
                    toVisit.setParameters(i, (ParameterDecl)child);
                    continue;
                }
                toVisit.removeParameters(i);
                --i;
            }
            for (i = 0; i < toVisit.getVariablesCount(); ++i) {
                toVisit.getVariables(i).accept(this);
                child = (VariableDecl)this.popObject(VariableDecl.class);
                if (child != null) {
                    toVisit.setVariables(i, (VariableDecl)child);
                    continue;
                }
                toVisit.removeVariables(i);
                --i;
            }
            if (toVisit.getBody() != null) {
                toVisit.getBody().accept(this);
                toVisit.setBody((Block)this.popObject(Block.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitState(State toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getParent() != null && this.hasReplacement(toVisit.getParent())) {
                ProcessDecl child = (ProcessDecl)this.getClone(toVisit.getParent());
                toVisit.setParent(child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitPortMap(PortMap toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getFormal() != null && this.hasReplacement(toVisit.getFormal())) {
                Port child = (Port)this.getClone(toVisit.getFormal());
                toVisit.setFormal(child);
            }
            if (toVisit.getActual() != null) {
                toVisit.getActual().accept(this);
                toVisit.setActual((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitArgumentMap(ArgumentMap toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            Element child;
            if (toVisit.getFormal() != null && this.hasReplacement(toVisit.getFormal())) {
                child = (ParameterDecl)this.getClone(toVisit.getFormal());
                toVisit.setFormal((ParameterDecl)child);
            }
            if (toVisit.getActual() != null) {
                toVisit.getActual().accept(this);
                toVisit.setActual((Expression)this.popObject(Expression.class));
            }
            if (toVisit.getContainer() != null && this.hasReplacement(toVisit.getContainer())) {
                child = (ElementWithArgumentMap)this.getClone(toVisit.getContainer());
                toVisit.setContainer((ElementWithArgumentMap)child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitProcessInstance(ProcessInstance toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            int i;
            Declaration child;
            for (int i2 = 0; i2 < toVisit.getArgumentsCount(); ++i2) {
                toVisit.getArguments(i2).accept(this);
                child = (ArgumentMap)this.popObject(ArgumentMap.class);
                if (child != null) {
                    toVisit.setArguments(i2, (ArgumentMap)child);
                    continue;
                }
                toVisit.removeArguments(i2);
                --i2;
            }
            if (toVisit.getProcess() != null && this.hasReplacement(toVisit.getProcess())) {
                ProcessDecl child2 = (ProcessDecl)this.getClone(toVisit.getProcess());
                toVisit.setProcess(child2);
            }
            for (i = 0; i < toVisit.getInputsCount(); ++i) {
                toVisit.getInputs(i).accept(this);
                child = (PortMap)this.popObject(PortMap.class);
                if (child != null) {
                    toVisit.setInputs(i, (PortMap)child);
                    continue;
                }
                toVisit.removeInputs(i);
                --i;
            }
            for (i = 0; i < toVisit.getOutputsCount(); ++i) {
                toVisit.getOutputs(i).accept(this);
                child = (PortMap)this.popObject(PortMap.class);
                if (child != null) {
                    toVisit.setOutputs(i, (PortMap)child);
                    continue;
                }
                toVisit.removeOutputs(i);
                --i;
            }
            if (toVisit.getParent() != null && this.hasReplacement(toVisit.getParent())) {
                ABCDSystem child3 = (ABCDSystem)this.getClone(toVisit.getParent());
                toVisit.setParent(child3);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitABCDSystem(ABCDSystem toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            Element child;
            int i;
            for (i = 0; i < toVisit.getConstantsCount(); ++i) {
                toVisit.getConstants(i).accept(this);
                child = (ConstantDecl)this.popObject(ConstantDecl.class);
                if (child != null) {
                    toVisit.setConstants(i, (ConstantDecl)child);
                    continue;
                }
                toVisit.removeConstants(i);
                --i;
            }
            for (i = 0; i < toVisit.getVariablesCount(); ++i) {
                toVisit.getVariables(i).accept(this);
                child = (VariableDecl)this.popObject(VariableDecl.class);
                if (child != null) {
                    toVisit.setVariables(i, (VariableDecl)child);
                    continue;
                }
                toVisit.removeVariables(i);
                --i;
            }
            for (i = 0; i < toVisit.getCoreTypesCount(); ++i) {
                toVisit.getCoreTypes(i).accept(this);
                child = (Type)this.popObject(Type.class);
                if (child != null) {
                    toVisit.setCoreTypes(i, (Type)child);
                    continue;
                }
                toVisit.removeCoreTypes(i);
                --i;
            }
            for (i = 0; i < toVisit.getTypesCount(); ++i) {
                toVisit.getTypes(i).accept(this);
                child = (TypeDecl)this.popObject(TypeDecl.class);
                if (child != null) {
                    toVisit.setTypes(i, (TypeDecl)child);
                    continue;
                }
                toVisit.removeTypes(i);
                --i;
            }
            for (i = 0; i < toVisit.getChannelTypesCount(); ++i) {
                toVisit.getChannelTypes(i).accept(this);
                child = (ChannelTypeDecl)this.popObject(ChannelTypeDecl.class);
                if (child != null) {
                    toVisit.setChannelTypes(i, (ChannelTypeDecl)child);
                    continue;
                }
                toVisit.removeChannelTypes(i);
                --i;
            }
            for (i = 0; i < toVisit.getChannelsCount(); ++i) {
                toVisit.getChannels(i).accept(this);
                child = (ChannelDecl)this.popObject(ChannelDecl.class);
                if (child != null) {
                    toVisit.setChannels(i, (ChannelDecl)child);
                    continue;
                }
                toVisit.removeChannels(i);
                --i;
            }
            for (i = 0; i < toVisit.getFunctionsCount(); ++i) {
                toVisit.getFunctions(i).accept(this);
                child = (FunctionDecl)this.popObject(FunctionDecl.class);
                if (child != null) {
                    toVisit.setFunctions(i, (FunctionDecl)child);
                    continue;
                }
                toVisit.removeFunctions(i);
                --i;
            }
            for (i = 0; i < toVisit.getProcessesCount(); ++i) {
                toVisit.getProcesses(i).accept(this);
                child = (ProcessDecl)this.popObject(ProcessDecl.class);
                if (child != null) {
                    toVisit.setProcesses(i, (ProcessDecl)child);
                    continue;
                }
                toVisit.removeProcesses(i);
                --i;
            }
            for (i = 0; i < toVisit.getCompositionCount(); ++i) {
                toVisit.getComposition(i).accept(this);
                child = (ProcessInstance)this.popObject(ProcessInstance.class);
                if (child != null) {
                    toVisit.setComposition(i, (ProcessInstance)child);
                    continue;
                }
                toVisit.removeComposition(i);
                --i;
            }
            for (i = 0; i < toVisit.getDeclarationsCount(); ++i) {
                child = toVisit.getDeclarations(i);
                if (!this.hasReplacement(child)) continue;
                Declaration replacement = (Declaration)this.getReplacement(child);
                if (replacement != null) {
                    toVisit.setDeclarations(i, replacement);
                    continue;
                }
                toVisit.removeDeclarations(i);
                --i;
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitInputStmt(InputStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getPort() != null && this.hasReplacement(toVisit.getPort())) {
                Port child = (Port)this.getClone(toVisit.getPort());
                toVisit.setPort(child);
            }
            if (toVisit.getExpression() != null) {
                toVisit.getExpression().accept(this);
                toVisit.setExpression((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitOutputStmt(OutputStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getPort() != null && this.hasReplacement(toVisit.getPort())) {
                Port child = (Port)this.getClone(toVisit.getPort());
                toVisit.setPort(child);
            }
            if (toVisit.getExpression() != null) {
                toVisit.getExpression().accept(this);
                toVisit.setExpression((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitSendStmt(SendStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getPort() != null && this.hasReplacement(toVisit.getPort())) {
                Port child = (Port)this.getClone(toVisit.getPort());
                toVisit.setPort(child);
            }
            if (toVisit.getExpression() != null) {
                toVisit.getExpression().accept(this);
                toVisit.setExpression((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitReceiveStmt(ReceiveStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getPort() != null && this.hasReplacement(toVisit.getPort())) {
                Port child = (Port)this.getClone(toVisit.getPort());
                toVisit.setPort(child);
            }
            if (toVisit.getExpression() != null) {
                toVisit.getExpression().accept(this);
                toVisit.setExpression((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitToStmt(ToStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getState() != null && this.hasReplacement(toVisit.getState())) {
                State child = (State)this.getClone(toVisit.getState());
                toVisit.setState(child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitLoopStmt(LoopStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getParent() != null && this.hasReplacement(toVisit.getParent())) {
                Transition child = (Transition)this.getClone(toVisit.getParent());
                toVisit.setParent(child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitIfStmt(IfStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getCondition() != null) {
                toVisit.getCondition().accept(this);
                toVisit.setCondition((Expression)this.popObject(Expression.class));
            }
            if (toVisit.getTrueBranch() != null) {
                toVisit.getTrueBranch().accept(this);
                toVisit.setTrueBranch((Statement)this.popObject(Statement.class));
            }
            if (toVisit.getFalseBranch() != null) {
                toVisit.getFalseBranch().accept(this);
                toVisit.setFalseBranch((Statement)this.popObject(Statement.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitSelectStmt(SelectStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            for (int i = 0; i < toVisit.getStatementsCount(); ++i) {
                toVisit.getStatements(i).accept(this);
                Statement child = (Statement)this.popObject(Statement.class);
                if (child != null) {
                    toVisit.setStatements(i, child);
                    continue;
                }
                toVisit.removeStatements(i);
                --i;
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitSpecialTypeStmt(SpecialTypeStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getReceiver() != null && this.hasReplacement(toVisit.getReceiver())) {
                ValueHolder child = (ValueHolder)this.getClone(toVisit.getReceiver());
                toVisit.setReceiver(child);
            }
            for (int i = 0; i < toVisit.getArgumentsCount(); ++i) {
                toVisit.getArguments(i).accept(this);
                Expression child = (Expression)this.popObject(Expression.class);
                if (child != null) {
                    toVisit.setArguments(i, child);
                    continue;
                }
                toVisit.removeArguments(i);
                --i;
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitWaitStmt(WaitStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getMinBound() != null) {
                toVisit.getMinBound().accept(this);
                toVisit.setMinBound((Expression)this.popObject(Expression.class));
            }
            if (toVisit.getMaxBound() != null) {
                toVisit.getMaxBound().accept(this);
                toVisit.setMaxBound((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitAssignStmt(AssignStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getLhs() != null) {
                toVisit.getLhs().accept(this);
                toVisit.setLhs((Expression)this.popObject(Expression.class));
            }
            if (toVisit.getRhs() != null) {
                toVisit.getRhs().accept(this);
                toVisit.setRhs((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitDeferredEvent(DeferredEvent toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            Element child;
            if (toVisit.getPort() != null && this.hasReplacement(toVisit.getPort())) {
                child = (Port)this.getClone(toVisit.getPort());
                toVisit.setPort((Port)child);
            }
            if (toVisit.getEventType() != null && this.hasReplacement(toVisit.getEventType())) {
                child = (UnionLiteral)this.getClone(toVisit.getEventType());
                toVisit.setEventType((UnionLiteral)child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitTransition(Transition toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getFrom() != null && this.hasReplacement(toVisit.getFrom())) {
                State child = (State)this.getClone(toVisit.getFrom());
                toVisit.setFrom(child);
            }
            for (int i = 0; i < toVisit.getDeferredEventsCount(); ++i) {
                toVisit.getDeferredEvents(i).accept(this);
                DeferredEvent child = (DeferredEvent)this.popObject(DeferredEvent.class);
                if (child != null) {
                    toVisit.setDeferredEvents(i, child);
                    continue;
                }
                toVisit.removeDeferredEvents(i);
                --i;
            }
            if (toVisit.getBehavior() != null) {
                toVisit.getBehavior().accept(this);
                toVisit.setBehavior((Block)this.popObject(Block.class));
            }
            if (toVisit.getParent() != null && this.hasReplacement(toVisit.getParent())) {
                ProcessDecl child = (ProcessDecl)this.getClone(toVisit.getParent());
                toVisit.setParent(child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitBlock(Block toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            for (int i = 0; i < toVisit.getStatementsCount(); ++i) {
                toVisit.getStatements(i).accept(this);
                Statement child = (Statement)this.popObject(Statement.class);
                if (child != null) {
                    toVisit.setStatements(i, child);
                    continue;
                }
                toVisit.removeStatements(i);
                --i;
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitWhileStmt(WhileStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getCondition() != null) {
                toVisit.getCondition().accept(this);
                toVisit.setCondition((Expression)this.popObject(Expression.class));
            }
            if (toVisit.getBody() != null) {
                toVisit.getBody().accept(this);
                toVisit.setBody((Block)this.popObject(Block.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitForeachStmt(ForeachStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getVariable() != null) {
                toVisit.getVariable().accept(this);
                toVisit.setVariable((Reference)this.popObject(Reference.class));
            }
            if (toVisit.getBody() != null) {
                toVisit.getBody().accept(this);
                toVisit.setBody((Block)this.popObject(Block.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitNullStmt(NullStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitReturnStmt(ReturnStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getExpression() != null) {
                toVisit.getExpression().accept(this);
                toVisit.setExpression((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitCaseStmt(CaseStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            for (int i = 0; i < toVisit.getItemsCount(); ++i) {
                toVisit.getItems(i).accept(this);
                CaseItem child = (CaseItem)this.popObject(CaseItem.class);
                if (child != null) {
                    toVisit.setItems(i, child);
                    continue;
                }
                toVisit.removeItems(i);
                --i;
            }
            if (toVisit.getExpression() != null) {
                toVisit.getExpression().accept(this);
                toVisit.setExpression((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitCaseItem(CaseItem toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getExpression() != null) {
                toVisit.getExpression().accept(this);
                toVisit.setExpression((Expression)this.popObject(Expression.class));
            }
            if (toVisit.getBlock() != null) {
                toVisit.getBlock().accept(this);
                toVisit.setBlock((Statement)this.popObject(Statement.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitGuardStmt(GuardStmt toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getExpression() != null) {
                toVisit.getExpression().accept(this);
                toVisit.setExpression((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitIntegerLit(IntegerLit toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitTrueLit(TrueLit toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitFalseLit(FalseLit toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitRecordLit(RecordLit toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            for (int i = 0; i < toVisit.getValueCount(); ++i) {
                toVisit.getValue(i).accept(this);
                FieldLiteral child = (FieldLiteral)this.popObject(FieldLiteral.class);
                if (child != null) {
                    toVisit.setValue(i, child);
                    continue;
                }
                toVisit.removeValue(i);
                --i;
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitFieldLiteral(FieldLiteral toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getValue() != null) {
                toVisit.getValue().accept(this);
                toVisit.setValue((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitUnionLiteral(UnionLiteral toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getExpression() != null) {
                toVisit.getExpression().accept(this);
                toVisit.setExpression((Expression)this.popObject(Expression.class));
            }
            if (toVisit.getType() != null && this.hasReplacement(toVisit.getType())) {
                Union child = (Union)this.getClone(toVisit.getType());
                toVisit.setType(child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitArrayLit(ArrayLit toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            for (int i = 0; i < toVisit.getValueCount(); ++i) {
                toVisit.getValue(i).accept(this);
                Expression child = (Expression)this.popObject(Expression.class);
                if (child != null) {
                    toVisit.setValue(i, child);
                    continue;
                }
                toVisit.removeValue(i);
                --i;
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitQueueLit(QueueLit toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            for (int i = 0; i < toVisit.getValueCount(); ++i) {
                toVisit.getValue(i).accept(this);
                Expression child = (Expression)this.popObject(Expression.class);
                if (child != null) {
                    toVisit.setValue(i, child);
                    continue;
                }
                toVisit.removeValue(i);
                --i;
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitUnaryExp(UnaryExp toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getOperand() != null) {
                toVisit.getOperand().accept(this);
                toVisit.setOperand((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitBinaryExp(BinaryExp toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            for (int i = 0; i < toVisit.getOperandsCount(); ++i) {
                toVisit.getOperands(i).accept(this);
                Expression child = (Expression)this.popObject(Expression.class);
                if (child != null) {
                    toVisit.setOperands(i, child);
                    continue;
                }
                toVisit.removeOperands(i);
                --i;
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitIndexedExp(IndexedExp toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getPrefix() != null) {
                toVisit.getPrefix().accept(this);
                toVisit.setPrefix((Expression)this.popObject(Expression.class));
            }
            if (toVisit.getIndex() != null) {
                toVisit.getIndex().accept(this);
                toVisit.setIndex((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitSelectedExp(SelectedExp toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getPrefix() != null) {
                toVisit.getPrefix().accept(this);
                toVisit.setPrefix((Expression)this.popObject(Expression.class));
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitReference(Reference toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            if (toVisit.getRef() != null && this.hasReplacement(toVisit.getRef())) {
                NamedDeclaration child = (NamedDeclaration)this.getClone(toVisit.getRef());
                toVisit.setRef(child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitFunctionCall(FunctionCall toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            for (int i = 0; i < toVisit.getArgumentsCount(); ++i) {
                toVisit.getArguments(i).accept(this);
                ArgumentMap child = (ArgumentMap)this.popObject(ArgumentMap.class);
                if (child != null) {
                    toVisit.setArguments(i, child);
                    continue;
                }
                toVisit.removeArguments(i);
                --i;
            }
            if (toVisit.getFunctionDeclaration() != null && this.hasReplacement(toVisit.getFunctionDeclaration())) {
                FunctionDecl child = (FunctionDecl)this.getClone(toVisit.getFunctionDeclaration());
                toVisit.setFunctionDeclaration(child);
            }
            this.pushObject(toVisit);
        }
    }

    @Override
    public void visitAny(Any toVisit) {
        if (this.hasContainmentReplacement(toVisit)) {
            Element replacement = this.getContainmentReplacement(toVisit);
            if (replacement != null) {
                replacement.accept(this);
            } else {
                this.pushObject(null);
            }
        } else {
            this.pushObject(toVisit);
        }
    }
}

