/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import obp.simulation.graph.DotWriter;
import obp.simulation.observer.GraphicsObservable;
import obp.simulation.observer.GraphicsObserver;

public class GraphicsModel
implements GraphicsObservable {
    private List<GraphicsObserver> observers = new ArrayList<GraphicsObserver>();
    private DotWriter writer;

    public GraphicsModel(File dotFile) {
        this.writer = new DotWriter(dotFile, false);
        this.writer.init();
    }

    public void addToGraph(String noeud1, String noeud2, String label) {
        this.writer.newLine(noeud1, noeud2, label);
        this.notifyObserver(noeud2);
    }

    public void addToGraph(String noeud) {
        this.writer.newLine(noeud);
        this.notifyObserver(noeud);
    }

    public void reset() {
        this.writer.init();
    }

    @Override
    public void addObserver(GraphicsObserver obs) {
        this.observers.add(obs);
    }

    @Override
    public void removeObserver() {
        this.observers.clear();
    }

    @Override
    public void notifyObserver(String focusOn) {
        for (GraphicsObserver obs : this.observers) {
            obs.graphChange(focusOn);
        }
    }

    public void exit() {
        this.writer.exit();
    }

    public File getFile() {
        return this.writer.getFile();
    }
}

