/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import obp.fiacre.model.CaseStmt;
import obp.fiacre.model.IfStmt;
import obp.fiacre.model.ProcessDecl;
import obp.fiacre.model.Seq;
import obp.fiacre.model.Statement;
import obp.fiacre.model.To;
import obp.fiacre.model.Transition;
import obp.fiacre.util.BranchExtractor;
import obp.fiacre.util.FiacrePrinter;
import obp.fiacre.util.FiacreUtil;
import obp.fiacre.util.StatementUtil;
import obp.fiacre.util.TransitionBranch;

public class FiacreDotPrinter {
    private boolean useDescription;
    private int seed;
    private final FiacrePrinter printer = new FiacrePrinter();

    public FiacreDotPrinter(boolean useDescription) {
        this.useDescription = useDescription;
        this.printer.setSeparator("\\n");
    }

    public boolean isUseDescription() {
        return this.useDescription;
    }

    public void setUseDescription(boolean useDescription) {
        this.useDescription = useDescription;
    }

    public String toDot(ProcessDecl process) {
        this.seed = 0;
        StringBuilder dot = new StringBuilder();
        dot.append("digraph ");
        dot.append(process.getName());
        dot.append(" { \n\trankdir=TB;\n");
        dot.append("\tinit [peripheries=2];\n");
        dot.append(this.toDotStatements("init", "", process.getInitAction(), new LinkedList<Statement>()));
        for (Transition transition : process.getTransitionList()) {
            Collection<TransitionBranch> branches = BranchExtractor.extractForCompiler(transition.getFrom().getName(), transition);
            for (TransitionBranch branch : branches) {
                String branchDot = this.toDotStatements(branch.getSource(), "", branch.getAction(), new LinkedList<Statement>());
                dot.append(branchDot);
            }
        }
        dot.append("}\n");
        return dot.toString();
    }

    private String toDotStatements(String sourceDotState, String description, Statement statement, LinkedList<Statement> nexts) {
        if (statement == null) {
            return "";
        }
        if (statement instanceof CaseStmt) {
            CaseStmt caseStmt = (CaseStmt)statement;
            if (StatementUtil.findFirst(To.class, caseStmt) != null) {
                String newSource = "s" + this.seed++;
                StringBuilder dot = new StringBuilder();
                dot.append("\t");
                dot.append(newSource);
                dot.append(" [shape=\"point\";label=\"\"];\n");
                dot.append(this.newEdge(sourceDotState, newSource, this.appendDescription(description, statement, false)));
                for (int i = 0; i < caseStmt.getRuleCount(); ++i) {
                    LinkedList<Statement> nextRule = new LinkedList<Statement>(nexts);
                    String dotRule = this.toDotStatements(newSource, "", caseStmt.getRule(i).getAction(), nextRule);
                    dot.append(dotRule);
                }
                return dot.toString();
            }
            if (nexts.size() > 0) {
                Statement next = nexts.removeFirst();
                return this.toDotStatements(sourceDotState, this.appendDescription(description, statement, true), next, nexts);
            }
            return "";
        }
        if (statement instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)statement;
            if (StatementUtil.findFirst(To.class, ifStmt) != null) {
                String newSource = "s" + this.seed++;
                StringBuilder dot = new StringBuilder();
                dot.append("\t");
                dot.append(newSource);
                dot.append(" [shape=\"point\";label=\"\"];\n");
                dot.append(this.newEdge(sourceDotState, newSource, this.appendDescription(description, statement, false)));
                dot.append(this.toDotStatements(newSource, "", ifStmt.getThen(), new LinkedList<Statement>(nexts)));
                dot.append(this.toDotStatements(newSource, "", ifStmt.getElse(), new LinkedList<Statement>(nexts)));
                return dot.toString();
            }
            if (nexts.size() > 0) {
                Statement next = nexts.removeFirst();
                return this.toDotStatements(sourceDotState, this.appendDescription(description, statement, true), next, nexts);
            }
            return "";
        }
        if (statement instanceof Seq) {
            Seq seq = (Seq)statement;
            Statement first = null;
            ArrayList<Statement> newNexts = new ArrayList<Statement>();
            for (Statement child : seq.getStatementList()) {
                if (first == null) {
                    first = child;
                    continue;
                }
                newNexts.add(child);
            }
            for (int i = newNexts.size() - 1; i >= 0; --i) {
                nexts.addFirst((Statement)newNexts.get(i));
            }
            return this.toDotStatements(sourceDotState, description, first, nexts);
        }
        if (statement instanceof To) {
            return this.newEdge(sourceDotState, ((To)statement).getDest().getName(), this.appendDescription(description, statement, false));
        }
        if (nexts.size() > 0) {
            Statement next = nexts.removeFirst();
            return this.toDotStatements(sourceDotState, this.appendDescription(description, statement, true), next, nexts);
        }
        return "";
    }

    private String appendDescription(String currentDescription, Statement statement, boolean showCode) {
        StringBuilder result = new StringBuilder();
        if (currentDescription.length() > 0) {
            result.append(currentDescription);
            result.append("\\n");
        }
        if (this.useDescription) {
            result.append(FiacreUtil.createDescription(statement, "\\n"));
        } else if (showCode) {
            result.append(this.printer.print(statement));
        }
        return result.toString();
    }

    private String newEdge(String source, String target, String description) {
        StringBuilder dot = new StringBuilder();
        dot.append("\t");
        dot.append(source);
        dot.append(" -> ");
        dot.append(target);
        dot.append(" [label=\"");
        dot.append(description);
        dot.append("\"];\n");
        return dot.toString();
    }
}

