/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import obp.explorer.ExplorerResult;
import obp.explorer.NullExplorerResult;
import obp.tool.OutputAnalyzer;
import org.xid.basics.error.Diagnostic;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.serializer.JBoost;

public class ExplorerResultAnalyzer
implements OutputAnalyzer<ExplorerResult> {
    private final StringBuilder resultString;
    private ExplorerResult result;

    public ExplorerResultAnalyzer(ExplorerResult result) {
        this.result = result;
        this.resultString = new StringBuilder();
    }

    @Override
    public boolean hideOutput() {
        return true;
    }

    @Override
    public void analyze(String line) {
        if (this.resultString.length() > 0) {
            this.resultString.append("\n");
        }
        this.resultString.append(line);
    }

    @Override
    public boolean ended(int value, double duration) {
        try {
            JBoost boost = new JBoost("ExplorerResult", 1);
            ByteArrayInputStream in = new ByteArrayInputStream(this.resultString.toString().getBytes());
            final boolean[] res = new boolean[]{true};
            ErrorHandler errH = new ErrorHandler(){

                public void handleError(int type, String message) {
                    System.err.println(message);
                    res[0] = false;
                }

                public void handleError(Diagnostic diagnostic) {
                    System.err.println(diagnostic);
                    res[0] = false;
                }
            };
            boost.setErrorHandler(errH);
            boost.initializeReading((InputStream)in);
            if (res[0]) {
                this.result = (ExplorerResult)boost.readObject(ExplorerResult.class);
                this.result.setDuration(duration);
            } else {
                this.result = new NullExplorerResult();
                this.result.setDuration(duration);
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    @Override
    public ExplorerResult getResult() {
        return this.result;
    }
}

