/*
 * Decompiled with CFR 0.152.
 */
package spinja.promela.compiler.expression;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import spinja.promela.compiler.Proctype;
import spinja.promela.compiler.Specification;
import spinja.promela.compiler.expression.CompoundExpression;
import spinja.promela.compiler.expression.Expression;
import spinja.promela.compiler.parser.MyParseException;
import spinja.promela.compiler.parser.ParseException;
import spinja.promela.compiler.parser.Token;
import spinja.promela.compiler.variable.VariableAccess;
import spinja.promela.compiler.variable.VariableType;
import spinja.util.StringWriter;

public class RunExpression
extends Expression
implements CompoundExpression {
    private final String id;
    private final Specification specification;
    private final List<Expression> exprs;

    public RunExpression(Token token, Specification specification, String string) {
        super(token);
        this.specification = specification;
        this.id = string;
        this.exprs = new ArrayList<Expression>();
    }

    @Override
    public void addExpression(Expression expression) throws ParseException {
        this.exprs.add(expression);
    }

    private String getArgs() throws ParseException {
        StringWriter stringWriter = new StringWriter();
        for (Expression expression : this.exprs) {
            stringWriter.append(expression == this.exprs.get(0) ? "" : ", ").append(expression.getIntExpression());
        }
        return stringWriter.toString();
    }

    @Override
    public String getBoolExpression() {
        return "true";
    }

    @Override
    public String getIntExpression() throws ParseException {
        Proctype proctype = this.specification.getProcess(this.id);
        if (proctype == null) {
            throw new MyParseException("Could not find proctype", this.getToken());
        }
        return "addProcess(new " + proctype.getName() + "(" + this.getArgs() + "))";
    }

    @Override
    public VariableType getResultType() {
        return VariableType.PID;
    }

    @Override
    public String getSideEffect() throws ParseException {
        return this.getIntExpression();
    }

    @Override
    public Set<VariableAccess> readVariables() {
        HashSet<VariableAccess> hashSet = new HashSet<VariableAccess>();
        for (Expression expression : this.exprs) {
            hashSet.addAll(expression.readVariables());
        }
        return hashSet;
    }

    @Override
    public String toString() {
        try {
            return "run " + this.id + "(" + this.getArgs() + ")";
        }
        catch (Exception exception) {
            return "run " + this.id + "()";
        }
    }
}

