/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.grammar.smalltalk;

import org.petitparser.parser.Parser;
import org.petitparser.parser.primitive.CharacterParser;
import org.petitparser.parser.primitive.EpsilonParser;
import org.petitparser.parser.primitive.StringParser;
import org.petitparser.tools.CompositeParser;

public class SmalltalkGrammar
extends CompositeParser {
    protected void initialize() {
        this.other();
        this.number();
        this.smalltalk();
    }

    private void other() {
        this.def("whitespace", CharacterParser.whitespace().or(new Parser[]{this.ref("comment")}));
        this.def("comment", CharacterParser.of((char)'\"').seq(new Parser[]{CharacterParser.any().starLazy(CharacterParser.of((char)'\"'))}).seq(new Parser[]{CharacterParser.of((char)'\"')}));
    }

    private void number() {
        this.def("number", CharacterParser.of((char)'-').optional().seq(new Parser[]{this.ref("positiveNumber")}));
        this.def("positiveNumber", this.ref("scaledDecimal").or(new Parser[]{this.ref("float")}).or(new Parser[]{this.ref("integer")}));
        this.def("integer", this.ref("radixInteger").or(new Parser[]{this.ref("decimalInteger")}));
        this.def("decimalInteger", this.ref("digits"));
        this.def("digits", CharacterParser.digit().plus());
        this.def("radixInteger", this.ref("radixSpecifier").seq(new Parser[]{CharacterParser.of((char)'r')}).seq(new Parser[]{this.ref("radixDigits")}));
        this.def("radixSpecifier", this.ref("digits"));
        this.def("radixDigits", CharacterParser.pattern((String)"0-9A-Z").plus());
        this.def("float", this.ref("mantissa").seq(new Parser[]{this.ref("exponentLetter").seq(new Parser[]{this.ref("exponent")}).optional()}));
        this.def("mantissa", this.ref("digits").seq(new Parser[]{CharacterParser.of((char)'.')}).seq(new Parser[]{this.ref("digits")}));
        this.def("exponent", CharacterParser.of((char)'-').seq(new Parser[]{this.ref("decimalInteger")}));
        this.def("exponentLetter", CharacterParser.pattern((String)"edq"));
        this.def("scaledDecimal", this.ref("scaledMantissa").seq(new Parser[]{CharacterParser.of((char)'s')}).seq(new Parser[]{this.ref("fractionalDigits").optional()}));
        this.def("scaledMantissa", this.ref("decimalInteger").or(new Parser[]{this.ref("mantissa")}));
        this.def("fractionalDigits", this.ref("decimalInteger"));
    }

    private Parser token(Object input) {
        Parser parser;
        if (input instanceof Parser) {
            parser = (Parser)input;
        } else if (input instanceof Character) {
            parser = CharacterParser.of((char)((Character)input).charValue());
        } else if (input instanceof String) {
            parser = StringParser.of((String)((String)input));
        } else {
            throw new IllegalStateException("Object not parsable: " + input);
        }
        return parser.token().trim(this.ref("whitespace"));
    }

    void smalltalk() {
        this.def("array", this.token("{").seq(new Parser[]{this.ref("expression").separatedBy(this.ref("periodToken")).seq(new Parser[]{this.ref("periodToken").optional()}).optional()}).seq(new Parser[]{this.token("}")}));
        this.def("arrayItem", this.ref("literal").or(new Parser[]{this.ref("symbolLiteralArray")}).or(new Parser[]{this.ref("arrayLiteralArray")}).or(new Parser[]{this.ref("byteLiteralArray")}));
        this.def("arrayLiteral", this.token("#(").seq(new Parser[]{this.ref("arrayItem").star()}).seq(new Parser[]{this.token(")")}));
        this.def("arrayLiteralArray", this.token("(").seq(new Parser[]{this.ref("arrayItem").star()}).seq(new Parser[]{this.token(")")}));
        this.def("assignment", this.ref("variable").seq(new Parser[]{this.ref("assignmentToken")}));
        this.def("assignmentToken", this.token(":="));
        this.def("binary", CharacterParser.pattern((String)"!%&*+,-/<=>?@\\|~").plus());
        this.def("binaryExpression", this.ref("unaryExpression").seq(new Parser[]{this.ref("binaryMessage").star()}));
        this.def("binaryMessage", this.ref("binaryToken").seq(new Parser[]{this.ref("unaryExpression")}));
        this.def("binaryMethod", this.ref("binaryToken").seq(new Parser[]{this.ref("variable")}));
        this.def("binaryPragma", this.ref("binaryToken").seq(new Parser[]{this.ref("arrayItem")}));
        this.def("binaryToken", this.token(this.ref("binary")));
        this.def("block", this.token("[").seq(new Parser[]{this.ref("blockBody")}).seq(new Parser[]{this.token("]")}));
        this.def("blockArgument", this.token(":").seq(new Parser[]{this.ref("variable")}));
        this.def("blockArguments", this.ref("blockArgumentsWith").or(new Parser[]{this.ref("blockArgumentsWithout")}));
        this.def("blockArgumentsWith", this.ref("blockArgument").plus().seq(new Parser[]{this.token("|").or(new Parser[]{this.token("]").and()})}));
        this.def("blockArgumentsWithout", (Parser)new EpsilonParser());
        this.def("blockBody", this.ref("blockArguments").seq(new Parser[]{this.ref("sequence")}));
        this.def("byteLiteral", this.token("#[").seq(new Parser[]{this.ref("numberLiteral").star()}).seq(new Parser[]{this.token("]")}));
        this.def("byteLiteralArray", this.token("[").seq(new Parser[]{this.ref("numberLiteral").star()}).seq(new Parser[]{this.token("]")}));
        this.def("cascadeExpression", this.ref("keywordExpression").seq(new Parser[]{this.ref("cascadeMessage").star()}));
        this.def("cascadeMessage", this.token(";").seq(new Parser[]{this.ref("message")}));
        this.def("char", CharacterParser.of((char)'$').seq(new Parser[]{CharacterParser.any()}));
        this.def("charLiteral", this.ref("charToken"));
        this.def("charToken", this.token(this.ref("char")));
        this.def("expression", this.ref("assignment").star().seq(new Parser[]{this.ref("cascadeExpression")}));
        this.def("falseLiteral", this.ref("falseToken"));
        this.def("falseToken", this.token("false").seq(new Parser[]{CharacterParser.word().not()}));
        this.def("identifier", CharacterParser.pattern((String)"a-zA-Z_").seq(new Parser[]{CharacterParser.pattern((String)"a-zA-Z0-9_").star()}));
        this.def("identifierToken", this.token(this.ref("identifier")));
        this.def("keyword", this.ref("identifier").seq(new Parser[]{CharacterParser.of((char)':')}));
        this.def("keywordExpression", this.ref("binaryExpression").seq(new Parser[]{this.ref("keywordMessage").optional()}));
        this.def("keywordMessage", this.ref("keywordToken").seq(new Parser[]{this.ref("binaryExpression")}).plus());
        this.def("keywordMethod", this.ref("keywordToken").seq(new Parser[]{this.ref("variable")}).plus());
        this.def("keywordPragma", this.ref("keywordToken").seq(new Parser[]{this.ref("arrayItem")}).plus());
        this.def("keywordToken", this.token(this.ref("keyword")));
        this.def("literal", this.ref("numberLiteral").or(new Parser[]{this.ref("stringLiteral")}).or(new Parser[]{this.ref("charLiteral")}).or(new Parser[]{this.ref("arrayLiteral")}).or(new Parser[]{this.ref("byteLiteral")}).or(new Parser[]{this.ref("symbolLiteral")}).or(new Parser[]{this.ref("nilLiteral")}).or(new Parser[]{this.ref("trueLiteral")}).or(new Parser[]{this.ref("falseLiteral")}));
        this.def("message", this.ref("keywordMessage").or(new Parser[]{this.ref("binaryMessage")}).or(new Parser[]{this.ref("unaryMessage")}));
        this.def("method", this.ref("methodDeclaration").seq(new Parser[]{this.ref("methodSequence")}));
        this.def("methodDeclaration", this.ref("keywordMethod").or(new Parser[]{this.ref("unaryMethod")}).or(new Parser[]{this.ref("binaryMethod")}));
        this.def("methodSequence", this.ref("periodToken").star().seq(new Parser[]{this.ref("pragmas")}).seq(new Parser[]{this.ref("periodToken").star()}).seq(new Parser[]{this.ref("temporaries")}).seq(new Parser[]{this.ref("periodToken").star()}).seq(new Parser[]{this.ref("pragmas")}).seq(new Parser[]{this.ref("periodToken").star()}).seq(new Parser[]{this.ref("statements")}));
        this.def("multiword", this.ref("keyword").plus());
        this.def("nilLiteral", this.ref("nilToken"));
        this.def("nilToken", this.token("nil").seq(new Parser[]{CharacterParser.word().not()}));
        this.def("numberLiteral", this.ref("numberToken"));
        this.def("numberToken", this.token(this.ref("number")));
        this.def("parens", this.token("(").seq(new Parser[]{this.ref("expression")}).seq(new Parser[]{this.token(")")}));
        this.def("period", CharacterParser.of((char)'.'));
        this.def("periodToken", this.token(this.ref("period")));
        this.def("pragma", this.token("<").seq(new Parser[]{this.ref("pragmaMessage")}).seq(new Parser[]{this.token(">")}));
        this.def("pragmaMessage", this.ref("keywordPragma").or(new Parser[]{this.ref("unaryPragma")}).or(new Parser[]{this.ref("binaryPragma")}));
        this.def("pragmas", this.ref("pragma").star());
        this.def("primary", this.ref("literal").or(new Parser[]{this.ref("variable")}).or(new Parser[]{this.ref("block")}).or(new Parser[]{this.ref("parens")}).or(new Parser[]{this.ref("array")}));
        this.def("return", this.token("^").seq(new Parser[]{this.ref("expression")}));
        this.def("sequence", this.ref("temporaries").seq(new Parser[]{this.ref("periodToken").star()}).seq(new Parser[]{this.ref("statements")}));
        this.def("start", this.ref("startMethod"));
        this.def("startMethod", this.ref("method").end());
        this.def("statements", this.ref("expression").seq(new Parser[]{this.ref("periodToken").plus().seq(new Parser[]{this.ref("statements")}).or(new Parser[]{this.ref("periodToken").star()})}).or(new Parser[]{this.ref("return").seq(new Parser[]{this.ref("periodToken").star()})}).or(new Parser[]{this.ref("periodToken").star()}));
        this.def("string", CharacterParser.of((char)'\'').seq(new Parser[]{StringParser.of((String)"''").or(new Parser[]{CharacterParser.pattern((String)"^'")}).star()}).seq(new Parser[]{CharacterParser.of((char)'\'')}));
        this.def("stringLiteral", this.ref("stringToken"));
        this.def("stringToken", this.token(this.ref("string")));
        this.def("symbol", this.ref("unary").or(new Parser[]{this.ref("binary")}).or(new Parser[]{this.ref("multiword")}).or(new Parser[]{this.ref("string")}));
        this.def("symbolLiteral", this.token("#").plus().seq(new Parser[]{this.token(this.ref("symbol"))}));
        this.def("symbolLiteralArray", this.token(this.ref("symbol")));
        this.def("temporaries", this.token("|").seq(new Parser[]{this.ref("variable").star()}).seq(new Parser[]{this.token("|")}).optional());
        this.def("trueLiteral", this.ref("trueToken"));
        this.def("trueToken", this.token("true").seq(new Parser[]{CharacterParser.word().not()}));
        this.def("unary", this.ref("identifier").seq(new Parser[]{CharacterParser.of((char)':').not()}));
        this.def("unaryExpression", this.ref("primary").seq(new Parser[]{this.ref("unaryMessage").star()}));
        this.def("unaryMessage", this.ref("unaryToken"));
        this.def("unaryMethod", this.ref("identifierToken"));
        this.def("unaryPragma", this.ref("identifierToken"));
        this.def("unaryToken", this.token(this.ref("unary")));
        this.def("variable", this.ref("identifierToken"));
    }
}

